---
generated_at: 2026-01-13 18:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-カスタムフィールド管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/fields_controller.rb`（15-16行目: indexアクション）
- E-02: `app/controllers/admin/fields_controller.rb`（9行目: setup_current_tab）
- E-03: `app/controllers/admin/fields_controller.rb`（123-125行目: setup_current_tab定義）
- E-04: `app/controllers/admin/application_controller.rb`（9行目: before_action）
- E-05: `app/models/fields/field.rb`（31-36行目: serialize設定）
- E-06: `app/models/fields/field.rb`（37行目: belongs_to :field_group）
- E-07: `app/models/fields/field.rb`（45-60行目: BASE_FIELD_TYPES）
- E-08: `app/models/fields/field_group.rb`（24行目: has_many :fields）
- E-09: `app/models/fields/custom_field.rb`（52行目: CustomField < Field）
- E-10: `config/routes.rb`（190-198行目: admin/fields routes）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（85-86行目: 画面No.43, 44との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カスタムフィールド管理は管理者専用機能である | E-04 | ○ |
| C-02 | indexアクションで一覧表示を行う | E-01 | ○ |
| C-03 | setup_current_tabでタブ設定を行う | E-02, E-03 | ○ |
| C-04 | FieldはSTIを使用してCoreFieldとCustomFieldを区別 | E-05, E-09 | ○ |
| C-05 | FieldはFieldGroupに属する（belongs_to） | E-06 | ○ |
| C-06 | FieldGroupはFieldsを持つ（has_many） | E-08 | ○ |
| C-07 | BASE_FIELD_TYPESでサポートされるフィールドタイプを定義 | E-07 | ○ |
| C-08 | ルーティングは /admin/fields で定義 | E-10 | ○ |
| C-09 | 画面No.43, 44と関連 | E-11 | ○ |
| C-10 | collectionとsettingsはserialize設定されている | E-05 | ○ |
| C-11 | CustomFieldはFieldを継承 | E-09 | ○ |
| C-12 | フィールドはpositionで並び順を管理 | E-08（order :position） | ○ |
| C-13 | FieldGroupはklass_nameでエンティティを区別 | E-08（klass_nameカラム） | ○ |
| C-14 | 読み取り専用のためデータ改ざんリスクなし | E-01（SELECT操作のみ） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の一覧表示機能であり、セキュリティリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] 管理者権限チェックが正しく機能しているか確認
- [ ] フィールドグループとフィールドの関連が正しく表示されるか確認
- [ ] エンティティタイプの切り替えが正しく動作するか確認
