---
generated_at: 2026-01-13 18:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-カスタムフィールド並び替え

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/fields_controller.rb`（84-93行目: sortアクション）
- E-02: `app/controllers/admin/application_controller.rb`（9行目: before_action）
- E-03: `app/models/fields/field.rb`（32行目: acts_as_list）
- E-04: `config/routes.rb`（195行目: post :sort）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（89行目: 画面No.43との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フィールド並び替えは管理者専用機能である | E-02 | ○ |
| C-02 | sortアクションで並び順を更新 | E-01 | ○ |
| C-03 | field_group_idパラメータからグループIDを取得 | E-01（85行目） | ○ |
| C-04 | fields_field_group_{id}パラメータからフィールドID配列を取得 | E-01（86行目） | ○ |
| C-05 | each_with_indexでposition更新 | E-01（88-90行目） | ○ |
| C-06 | Field.update_allでposition, field_group_idを更新 | E-01（89行目） | ○ |
| C-07 | render nothing: trueでレスポンスなし返却 | E-01（92行目） | ○ |
| C-08 | acts_as_listを使用 | E-03 | ○ |
| C-09 | ルーティングは POST /admin/fields/sort で定義 | E-04 | ○ |
| C-10 | 画面No.43と関連 | E-05 | ○ |
| C-11 | positionは1始まり（index + 1） | E-01（89行目） | ○ |
| C-12 | グループ間移動時にfield_group_idも更新 | E-01（89行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 並び順の更新のみで、データ損失リスクは低い
- 1: 中リスク - トランザクション制御がないため、途中失敗時の一貫性に注意

## 6) レビュアーチェックリスト（最小）
- [ ] 管理者権限チェックが正しく機能しているか確認
- [ ] ドラッグ&ドロップ操作が正しく動作するか確認
- [ ] フィールドグループ間の移動が正しく動作するか確認
- [ ] 並び順が正しく反映されるか確認
