---
generated_at: 2026-01-13 18:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-プラグイン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/admin/plugins_controller.rb`（14-17行目: indexアクション）
- E-02: `app/controllers/admin/plugins_controller.rb`（9行目: setup_current_tab）
- E-03: `app/controllers/admin/plugins_controller.rb`（15行目: FatFreeCRM::Plugin.list）
- E-04: `app/controllers/admin/plugins_controller.rb`（17行目: respond_with）
- E-05: `app/controllers/admin/plugins_controller.rb`（22-24行目: setup_current_tab定義）
- E-06: `app/controllers/admin/application_controller.rb`（9行目: require_admin_user）
- E-07: `config/routes.rb`（214行目: resources :plugins, only: :index）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（93行目: 画面No.48との関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プラグイン一覧は管理者専用機能である | E-06 | ○ |
| C-02 | indexアクションでプラグイン一覧を表示 | E-01 | ○ |
| C-03 | setup_current_tabでタブ設定を行う | E-02, E-05 | ○ |
| C-04 | FatFreeCRM::Plugin.listでプラグイン一覧を取得 | E-03 | ○ |
| C-05 | respond_withで応答を返却 | E-04 | ○ |
| C-06 | ルーティングは GET /admin/plugins で定義 | E-07 | ○ |
| C-07 | 画面No.48と関連 | E-08 | ○ |
| C-08 | indexのみ（only: :index）でルーティング定義 | E-07 | ○ |
| C-09 | 読み取り専用でデータ改ざんリスクなし | E-01（参照のみ） | ○ |
| C-10 | @pluginsにプラグイン一覧を格納 | E-03 | ○ |
| C-11 | 現在タブは'admin/plugins'に設定 | E-05 | ○ |
| C-12 | データベースアクセスなし | E-01（Plugin.list呼び出しのみ） | ○ |

## 4) 不足情報（Unknown / Missing）
- FatFreeCRM::Plugin クラスの実装詳細（Plugin.listメソッドの内部実装）が確認できていない
  - 候補：プラグインシステムのドキュメント / Rails Engine の仕組み / コードベース内のPlugin関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の参照機能であり、セキュリティリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] 管理者権限チェックが正しく機能しているか確認
- [ ] プラグイン一覧が正しく表示されるか確認
- [ ] FatFreeCRM::Plugin.list の動作を確認
