---
generated_at: 2026-01-13 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-高度な検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件3秒以内**：数値の妥当性要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `config/initializers/ransack.rb` - Ransack設定（predicates、ajax_options）
- E-02: `app/controllers/entities_controller.rb` - 検索処理ロジック（13行目、130-134行目、143-161行目）
- E-03: `app/models/entities/account.rb` - モデルのRansack設定（55行目、73-74行目）
- E-04: `app/views/entities/_search.html.haml` - 検索フォームUI（5-16行目）
- E-05: `config/routes.rb` - ルーティング定義（46行目 advanced_search）
- E-06: `app/models/entities/lead.rb` - text_searchスコープ（62行目）
- E-07: `app/assets/javascripts/search.js.coffee` - 検索JS処理
- E-08: `app/models/users/ability.rb` - 権限設定（CanCan）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ransack gemを使用した高度な検索機能 | E-01, E-02 | ○ |
| C-02 | params[:q]から検索条件を抽出 | E-02 (143行目) | ○ |
| C-03 | ransack_ui_searchで検索フォーム生成 | E-04 (16行目) | ○ |
| C-04 | 高度検索時はセッションフィルタを無視 | E-02 (148-152行目) | ○ |
| C-05 | 検索結果はユーザー権限でフィルタリング | E-02 (146行目), E-08 | ○ |
| C-06 | DISTINCTで重複除去 | E-02 (146行目) | ○ |
| C-07 | has_ransackable_associationsで検索可能関連定義 | E-03 (73行目) | ○ |
| C-08 | ransack_can_autocompleteでオートコンプリート有効化 | E-03 (74行目) | ○ |
| C-09 | text_searchスコープでRansack使用 | E-06 (62行目) | ○ |
| C-10 | ルーティングにadvanced_searchアクション定義 | E-05 (46行目) | ○ |
| C-11 | 許可predicatesをcont,eq,gt,lt等に制限 | E-01 (11-14行目) | ○ |
| C-12 | ページネーション最大200件 | E-02 (231行目) | ○ |
| C-13 | 基本/高度検索のタブ切り替えUI | E-04 (5-7行目) | ○ |
| C-14 | build_sortでデフォルトソート設定 | E-02 (132行目) | ○ |
| C-15 | ajax_optionsでオートコンプリートURL設定 | E-01 (17-21行目) | ○ |
| C-16 | search.js.coffeeで検索フォーム動的処理 | E-07 (9行目) | ○ |
| C-17 | 検索結果の表示3秒以内 | **根拠なし** | △ |
| C-18 | CanCanによるアクセス制御 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-17: パフォーマンス要件3秒以内**
  - 理由：パフォーマンス要件の数値はソースコード上に定義がなく、推定値
  - 候補：パフォーマンステスト結果 / 要件定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）

- 0: Ransack設定・処理フロー（コードで確認済み）
- 0: 権限制御（CanCanコードで確認済み）
- 1: パフォーマンス要件（数値の妥当性は運用実績で確認必要）

## 6) レビュアーチェックリスト（最小）

- [ ] Ransackの許可predicatesが業務要件を満たしているか確認
- [ ] 検索可能な関連（has_ransackable_associations）の範囲が適切か確認
- [ ] パフォーマンス要件の数値が実運用で妥当か確認
- [ ] 権限フィルタリングが意図通り動作するか確認
