---
generated_at: 2026-01-13 17:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-バージョン履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目について根拠が確認できた

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/polymorphic/version.rb` - Versionモデル
- E-02: `app/models/entities/account.rb` - has_paper_trail設定（68行目）
- E-03: `app/controllers/entities_controller.rb` - update_recently_viewed（17行目、186-188行目）
- E-04: `app/controllers/application_controller.rb` - set_paper_trail_whodunnit（13行目）
- E-05: `db/migrate/20120216031616_create_versions.rb` - versionsテーブル定義
- E-06: `db/migrate/20120309070209_add_versions_related.rb` - related関連追加

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PaperTrail::Versionを継承 | E-01 (10行目) | ○ |
| C-02 | ASSETS, EVENTS, DURATION定数定義 | E-01 (11-13行目) | ○ |
| C-03 | belongs_to :related, :user | E-01 (15-16行目) | ○ |
| C-04 | default_order, include_events等のスコープ | E-01 (18-21行目) | ○ |
| C-05 | recent_for_userメソッド | E-01 (24-44行目) | ○ |
| C-06 | latestメソッドでフィルタ付き履歴取得 | E-01 (46-54行目) | ○ |
| C-07 | related_toメソッド | E-01 (56-59行目) | ○ |
| C-08 | historyメソッド（view除外） | E-01 (61-63行目) | ○ |
| C-09 | visible_toメソッドで権限フィルタ | E-01 (65-82行目) | ○ |
| C-10 | has_paper_trail設定 | E-02 (68行目) | ○ |
| C-11 | ignore: [:subscribed_users]で除外フィールド | E-02 (68行目) | ○ |
| C-12 | カスタムVersionモデル指定 | E-02 (68行目: class_name: 'Version') | ○ |
| C-13 | update_recently_viewedでview履歴記録 | E-03 (186-188行目) | ○ |
| C-14 | after_action :update_recently_viewed | E-03 (17行目) | ○ |
| C-15 | set_paper_trail_whodunnit | E-04 (13行目) | ○ |
| C-16 | versionsテーブル構造 | E-05 | ○ |
| C-17 | related_id, related_typeカラム | E-06 | ○ |
| C-18 | デフォルト2日間の履歴表示 | E-01 (51行目: 2.days) | ○ |

## 4) 不足情報（Unknown / Missing）

なし - 全項目について根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- 0: PaperTrail設定（コードで確認済み）
- 0: Versionモデルのメソッド（実装確認済み）
- 0: 権限フィルタリング（visible_to確認済み）
- 0: データベーススキーマ（マイグレーション確認済み）

## 6) レビュアーチェックリスト（最小）

- [ ] 全エンティティでhas_paper_trailが設定されているか確認
- [ ] ignoreフィールドが適切に設定されているか確認
- [ ] visible_toの権限フィルタリングが意図通り動作するか確認
- [ ] 閲覧履歴（event='view'）が正しく記録されるか確認
- [ ] 削除されたエンティティのreifyが正しく動作するか確認
