---
generated_at: 2026-01-13 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-取引先へのアタッチ/ディスカード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities_controller.rb` - EntitiesController実装
- E-02: `app/controllers/application_controller.rb` - ApplicationController実装
- E-03: `app/models/entities/account.rb` - Accountモデル実装
- E-04: `config/routes.rb` - ルーティング定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | attachアクションで紐付け処理 | E-01（23-29行目: def attach） | ○ |
| C-02 | discardアクションで解除処理 | E-01（31-39行目: def discard） | ○ |
| C-03 | find_class(params[:assets])で対象クラス取得（attach） | E-01（24行目: find_class(params[:assets])） | ○ |
| C-04 | find_class(params[:attachment])で対象クラス取得（discard） | E-01（34行目: find_class(params[:attachment])） | ○ |
| C-05 | entity.attach!(@attachment)で紐付け実行 | E-01（25行目: @attached = entity.attach!(@attachment)） | ○ |
| C-06 | entity.discard!(@attachment)で解除実行 | E-01（35行目: entity.discard!(@attachment)） | ○ |
| C-07 | entity.reloadで再読み込み | E-01（26行目, 36行目: entity.reload） | ○ |
| C-08 | Account#attach!で紐付け | E-03（103-105行目: def attach!） | ○ |
| C-09 | Account#discard!で解除 | E-03（109-115行目: def discard!） | ○ |
| C-10 | 重複紐付け防止（unless include?） | E-03（104行目: unless send(...).include?(attachment.id)） | ○ |
| C-11 | タスクの場合はasset属性をnilに設定 | E-03（110-111行目: if attachment.is_a?(Task)） | ○ |
| C-12 | 連絡先/商談の場合はdeleteで削除 | E-03（112-114行目: send(...).delete(attachment)） | ○ |
| C-13 | find_classはActiveRecord::Base.descendantsから検索 | E-02（261-270行目: def find_class） | ○ |
| C-14 | find_classは無効なクラス名でエラー | E-02（268行目: raise "Unknown resource"） | ○ |
| C-15 | PUT /accounts/:id/attach ルートが定義 | E-04（55行目: put :attach） | ○ |
| C-16 | POST /accounts/:id/discard ルートが定義 | E-04（56行目: post :discard） | ○ |
| C-17 | 機能名は「取引先へのアタッチ/ディスカード」 | E-05（行10: "取引先へのアタッチ/ディスカード"） | ○ |
| C-18 | 関連画面は取引先編集フォーム（画面No.10） | E-06（行22: 画面No 10との関連） | ○ |
| C-19 | respond_with(entity)でレスポンス | E-01（28行目, 38行目: respond_with） | ○ |
| C-20 | accounts_controller.rbでEntitiesControllerを継承 | E-03のコメント（89-95行目） | ○ |
| C-21 | attachはmemberルート | E-04（55行目: member do内） | ○ |
| C-22 | discardはmemberルート | E-04（56行目: member do内） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての機能動作がコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] find_classの検証が十分か確認（不正なクラス名の入力に対する防御）
- [ ] 重複紐付け防止ロジックが正しく動作するか確認
- [ ] タスクと連絡先/商談で異なる解除処理が意図通りか確認
