---
generated_at: 2026-01-13 12:00:00
metrics:
  claims_total: 51
  claims_with_evidence: 51
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：51 / 51、根拠なし：0
- 優先レビュー（高）
  - 該当なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `config/routes.rb` - Railsルーティング設定ファイル
- E-02: `app/controllers/home_controller.rb` - ホームコントローラー
- E-03: `app/controllers/sessions_controller.rb` - セッションコントローラー
- E-04: `app/controllers/registrations_controller.rb` - 登録コントローラー
- E-05: `app/controllers/passwords_controller.rb` - パスワードコントローラー
- E-06: `app/controllers/entities_controller.rb` - エンティティ基底コントローラー
- E-07: `app/controllers/entities/accounts_controller.rb` - 取引先コントローラー
- E-08: `app/controllers/entities/campaigns_controller.rb` - キャンペーンコントローラー
- E-09: `app/controllers/entities/leads_controller.rb` - リードコントローラー
- E-10: `app/controllers/entities/contacts_controller.rb` - 連絡先コントローラー
- E-11: `app/controllers/entities/opportunities_controller.rb` - 商談コントローラー
- E-12: `app/controllers/tasks_controller.rb` - タスクコントローラー
- E-13: `app/controllers/users_controller.rb` - ユーザーコントローラー
- E-14: `app/controllers/admin/users_controller.rb` - 管理ユーザーコントローラー
- E-15: `app/controllers/admin/groups_controller.rb` - 管理グループコントローラー
- E-16: `app/controllers/admin/tags_controller.rb` - 管理タグコントローラー
- E-17: `app/controllers/admin/fields_controller.rb` - 管理フィールドコントローラー
- E-18: `app/controllers/admin/settings_controller.rb` - 管理設定コントローラー
- E-19: `app/controllers/admin/plugins_controller.rb` - 管理プラグインコントローラー
- E-20: `app/controllers/admin/research_tools_controller.rb` - 管理調査ツールコントローラー
- E-21: `app/views/devise/sessions/new.html.haml` - ログイン画面テンプレート
- E-22: `app/views/devise/registrations/new.html.haml` - 登録画面テンプレート
- E-23: `app/views/devise/passwords/new.html.haml` - パスワードリセット申請テンプレート
- E-24: `app/views/devise/passwords/edit.html.haml` - パスワードリセットテンプレート
- E-25: `app/views/devise/confirmations/new.html.haml` - メール確認テンプレート
- E-26: `app/views/home/index.html.haml` - ホーム画面テンプレート
- E-27: `app/views/accounts/index.html.haml` - 取引先一覧テンプレート
- E-28: `app/views/accounts/show.html.haml` - 取引先詳細テンプレート
- E-29: `app/views/campaigns/index.html.haml` - キャンペーン一覧テンプレート
- E-30: `app/views/campaigns/show.html.haml` - キャンペーン詳細テンプレート
- E-31: `app/views/leads/index.html.haml` - リード一覧テンプレート
- E-32: `app/views/leads/show.html.haml` - リード詳細テンプレート
- E-33: `app/views/contacts/index.html.haml` - 連絡先一覧テンプレート
- E-34: `app/views/contacts/show.html.haml` - 連絡先詳細テンプレート
- E-35: `app/views/opportunities/index.html.haml` - 商談一覧テンプレート
- E-36: `app/views/opportunities/show.html.haml` - 商談詳細テンプレート
- E-37: `app/views/tasks/index.html.haml` - タスク一覧テンプレート
- E-38: `app/views/users/index.html.haml` - ユーザー一覧テンプレート
- E-39: `app/views/users/show.html.haml` - ユーザー詳細テンプレート
- E-40: `app/views/users/opportunities_overview.html.haml` - 商談概要テンプレート
- E-41: `app/views/admin/users/index.html.haml` - 管理ユーザー一覧テンプレート
- E-42: `app/views/admin/groups/index.html.haml` - 管理グループ一覧テンプレート
- E-43: `app/views/admin/tags/index.html.haml` - 管理タグ一覧テンプレート
- E-44: `app/views/admin/fields/index.html.haml` - 管理フィールド一覧テンプレート
- E-45: `app/views/admin/settings/index.html.haml` - 管理設定テンプレート
- E-46: `app/views/admin/plugins/index.html.haml` - 管理プラグインテンプレート
- E-47: `app/views/admin/research_tools/index.html.haml` - 管理調査ツールテンプレート
- E-48: `app/views/layouts/application.html.haml` - メインレイアウトテンプレート
- E-49: `app/views/layouts/admin/application.html.haml` - 管理レイアウトテンプレート
- E-50: `app/views/layouts/500.html.haml` - エラーページテンプレート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面が存在する | E-01, E-03, E-21 | ○ |
| C-02 | ユーザー登録画面が存在する | E-01, E-04, E-22 | ○ |
| C-03 | パスワードリセット申請画面が存在する | E-01, E-05, E-23 | ○ |
| C-04 | パスワードリセット画面が存在する | E-01, E-05, E-24 | ○ |
| C-05 | メール確認画面が存在する | E-01, E-25 | ○ |
| C-06 | ホーム画面（ダッシュボード）が存在する | E-01, E-02, E-26 | ○ |
| C-07 | 取引先一覧画面が存在する | E-01, E-07, E-27 | ○ |
| C-08 | 取引先詳細画面が存在する | E-01, E-07, E-28 | ○ |
| C-09 | 取引先新規作成フォームが存在する | E-07, E-27 | ○ |
| C-10 | 取引先編集フォームが存在する | E-07, E-28 | ○ |
| C-11 | キャンペーン一覧画面が存在する | E-01, E-08, E-29 | ○ |
| C-12 | キャンペーン詳細画面が存在する | E-01, E-08, E-30 | ○ |
| C-13 | キャンペーン新規作成フォームが存在する | E-08, E-29 | ○ |
| C-14 | キャンペーン編集フォームが存在する | E-08, E-30 | ○ |
| C-15 | リード一覧画面が存在する | E-01, E-09, E-31 | ○ |
| C-16 | リード詳細画面が存在する | E-01, E-09, E-32 | ○ |
| C-17 | リード新規作成フォームが存在する | E-09, E-31 | ○ |
| C-18 | リード編集フォームが存在する | E-09, E-32 | ○ |
| C-19 | リード変換画面が存在する | E-01, E-09 | ○ |
| C-20 | 連絡先一覧画面が存在する | E-01, E-10, E-33 | ○ |
| C-21 | 連絡先詳細画面が存在する | E-01, E-10, E-34 | ○ |
| C-22 | 連絡先新規作成フォームが存在する | E-10, E-33 | ○ |
| C-23 | 連絡先編集フォームが存在する | E-10, E-34 | ○ |
| C-24 | 商談一覧画面が存在する | E-01, E-11, E-35 | ○ |
| C-25 | 商談詳細画面が存在する | E-01, E-11, E-36 | ○ |
| C-26 | 商談新規作成フォームが存在する | E-11, E-35 | ○ |
| C-27 | 商談編集フォームが存在する | E-11, E-36 | ○ |
| C-28 | タスク一覧画面が存在する | E-01, E-12, E-37 | ○ |
| C-29 | タスク新規作成フォームが存在する | E-12, E-37 | ○ |
| C-30 | タスク編集フォームが存在する | E-12, E-37 | ○ |
| C-31 | ユーザー一覧画面が存在する | E-01, E-13, E-38 | ○ |
| C-32 | ユーザー詳細画面（プロフィール）が存在する | E-01, E-13, E-39 | ○ |
| C-33 | 商談概要画面が存在する | E-01, E-13, E-40 | ○ |
| C-34 | ユーザー管理一覧画面が存在する | E-01, E-14, E-41 | ○ |
| C-35 | ユーザー管理詳細画面が存在する | E-14, E-41 | ○ |
| C-36 | ユーザー管理新規作成フォームが存在する | E-14, E-41 | ○ |
| C-37 | ユーザー管理編集フォームが存在する | E-14, E-41 | ○ |
| C-38 | グループ管理一覧画面が存在する | E-01, E-15, E-42 | ○ |
| C-39 | グループ管理詳細画面が存在する | E-15, E-42 | ○ |
| C-40 | グループ管理新規作成フォームが存在する | E-15, E-42 | ○ |
| C-41 | グループ管理編集フォームが存在する | E-15, E-42 | ○ |
| C-42 | タグ管理画面が存在する | E-01, E-16, E-43 | ○ |
| C-43 | カスタムフィールド管理画面が存在する | E-01, E-17, E-44 | ○ |
| C-44 | カスタムフィールド詳細画面が存在する | E-17, E-44 | ○ |
| C-45 | 調査ツール管理画面が存在する | E-01, E-20, E-47 | ○ |
| C-46 | 調査ツール編集画面が存在する | E-20, E-47 | ○ |
| C-47 | 設定画面が存在する | E-01, E-18, E-45 | ○ |
| C-48 | プラグイン管理画面が存在する | E-01, E-19, E-46 | ○ |
| C-49 | メインレイアウトが存在する | E-48 | ○ |
| C-50 | 管理画面レイアウトが存在する | E-49 | ○ |
| C-51 | 500エラー画面が存在する | E-50 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての画面に対してソースコード上の根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての画面に明確なソースコード根拠あり
- 注意点：
  - 一部のフォーム（新規作成・編集）はパーシャルテンプレートとして実装されており、モーダルまたはAjaxで表示される
  - Deviseベースの認証画面は標準的なDeviseビューをカスタマイズして使用

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csvの全51画面がアプリケーションに存在することを確認
- [ ] 各テンプレートファイルパスが正しいことを確認
- [ ] 画面遷移図の遷移パターンがルーティング定義と整合していることを確認
- [ ] 管理画面へのアクセス制御（管理者のみ）が適切に機能していることを確認
- [ ] カテゴリ分類が適切であることを確認
