# 画面遷移図

Fat Free CRM の画面遷移図をMermaid形式で表現します。

## 全体遷移図

```mermaid
flowchart TB
    subgraph 認証
        Login[ログイン画面]
        Signup[ユーザー登録画面]
        ForgotPwd[パスワードリセット申請画面]
        ResetPwd[パスワードリセット画面]
        ConfirmEmail[メール確認画面]
    end

    subgraph メイン
        Dashboard[ホーム画面/ダッシュボード]
    end

    subgraph 取引先
        AccountList[取引先一覧]
        AccountShow[取引先詳細]
        AccountNew[取引先新規作成]
        AccountEdit[取引先編集]
    end

    subgraph キャンペーン
        CampaignList[キャンペーン一覧]
        CampaignShow[キャンペーン詳細]
        CampaignNew[キャンペーン新規作成]
        CampaignEdit[キャンペーン編集]
    end

    subgraph リード
        LeadList[リード一覧]
        LeadShow[リード詳細]
        LeadNew[リード新規作成]
        LeadEdit[リード編集]
        LeadConvert[リード変換]
    end

    subgraph 連絡先
        ContactList[連絡先一覧]
        ContactShow[連絡先詳細]
        ContactNew[連絡先新規作成]
        ContactEdit[連絡先編集]
    end

    subgraph 商談
        OpportunityList[商談一覧]
        OpportunityShow[商談詳細]
        OpportunityNew[商談新規作成]
        OpportunityEdit[商談編集]
    end

    subgraph タスク
        TaskList[タスク一覧]
        TaskNew[タスク新規作成]
        TaskEdit[タスク編集]
    end

    subgraph ユーザー
        UserList[ユーザー一覧]
        UserProfile[プロフィール]
        OpportunitiesOverview[商談概要]
    end

    subgraph 管理画面
        AdminUsers[ユーザー管理]
        AdminGroups[グループ管理]
        AdminTags[タグ管理]
        AdminFields[カスタムフィールド]
        AdminSettings[設定]
        AdminPlugins[プラグイン]
        AdminResearchTools[調査ツール]
    end

    %% 認証フロー
    Login -->|ログイン成功| Dashboard
    Login -->|新規登録| Signup
    Login -->|パスワード忘れ| ForgotPwd
    Signup -->|登録後| Login
    ForgotPwd -->|メール送信| ResetPwd
    ResetPwd -->|リセット完了| Login

    %% ダッシュボードからの遷移
    Dashboard -->|Accounts| AccountList
    Dashboard -->|Campaigns| CampaignList
    Dashboard -->|Leads| LeadList
    Dashboard -->|Contacts| ContactList
    Dashboard -->|Opportunities| OpportunityList
    Dashboard -->|Tasks| TaskList
    Dashboard -->|プロフィール| UserProfile
    Dashboard -->|管理| AdminUsers

    %% 取引先フロー
    AccountList -->|詳細表示| AccountShow
    AccountList -->|新規作成| AccountNew
    AccountShow -->|編集| AccountEdit
    AccountNew -->|作成完了| AccountList
    AccountEdit -->|更新完了| AccountShow

    %% キャンペーンフロー
    CampaignList -->|詳細表示| CampaignShow
    CampaignList -->|新規作成| CampaignNew
    CampaignShow -->|編集| CampaignEdit
    CampaignNew -->|作成完了| CampaignList
    CampaignEdit -->|更新完了| CampaignShow

    %% リードフロー
    LeadList -->|詳細表示| LeadShow
    LeadList -->|新規作成| LeadNew
    LeadShow -->|編集| LeadEdit
    LeadShow -->|変換| LeadConvert
    LeadNew -->|作成完了| LeadList
    LeadEdit -->|更新完了| LeadShow
    LeadConvert -->|変換成功| ContactShow

    %% 連絡先フロー
    ContactList -->|詳細表示| ContactShow
    ContactList -->|新規作成| ContactNew
    ContactShow -->|編集| ContactEdit
    ContactNew -->|作成完了| ContactList
    ContactEdit -->|更新完了| ContactShow

    %% 商談フロー
    OpportunityList -->|詳細表示| OpportunityShow
    OpportunityList -->|新規作成| OpportunityNew
    OpportunityShow -->|編集| OpportunityEdit
    OpportunityNew -->|作成完了| OpportunityList
    OpportunityEdit -->|更新完了| OpportunityShow

    %% タスクフロー
    TaskList -->|新規作成| TaskNew
    TaskList -->|編集| TaskEdit
    TaskNew -->|作成完了| TaskList
    TaskEdit -->|更新完了| TaskList

    %% ユーザーフロー
    UserList -->|詳細表示| UserProfile
    UserProfile -->|商談概要| OpportunitiesOverview

    %% 管理画面フロー
    AdminUsers --> AdminGroups
    AdminUsers --> AdminTags
    AdminUsers --> AdminFields
    AdminUsers --> AdminSettings
    AdminUsers --> AdminPlugins
    AdminUsers --> AdminResearchTools

    %% エンティティ間の関連
    AccountShow -.->|関連商談| OpportunityShow
    AccountShow -.->|関連連絡先| ContactShow
    CampaignShow -.->|関連リード| LeadShow
    CampaignShow -.->|関連商談| OpportunityShow
    ContactShow -.->|関連商談| OpportunityShow
    OpportunityShow -.->|関連連絡先| ContactShow
```

## 認証フロー詳細

```mermaid
flowchart TD
    Start((開始)) --> Login[ログイン画面]
    Login -->|認証成功| Dashboard[ダッシュボード]
    Login -->|新規登録| Signup[ユーザー登録画面]
    Login -->|パスワード忘れ| ForgotPwd[パスワードリセット申請]

    Signup -->|登録完了| ConfirmPending[メール確認待ち]
    ConfirmPending -->|確認メールリンク| Login
    Signup -->|確認再送| ConfirmResend[メール確認再送画面]
    ConfirmResend --> ConfirmPending

    ForgotPwd -->|申請完了| ResetEmail[リセットメール送信]
    ResetEmail -->|メールリンク| ResetPwd[パスワードリセット画面]
    ResetPwd -->|リセット完了| Login

    Dashboard -->|ログアウト| Login
```

## CRMエンティティ管理フロー

```mermaid
flowchart TD
    subgraph 一覧画面
        List[エンティティ一覧]
        Filter[フィルタ]
        Search[検索]
    end

    subgraph 詳細画面
        Show[詳細表示]
        Timeline[タイムライン]
        Comments[コメント]
        RelatedItems[関連アイテム]
    end

    subgraph 編集機能
        New[新規作成フォーム]
        Edit[編集フォーム]
        Delete[削除確認]
    end

    List --> Filter
    List --> Search
    Filter --> List
    Search --> List

    List -->|選択| Show
    Show --> Timeline
    Show --> Comments
    Show --> RelatedItems

    List -->|新規| New
    Show -->|編集| Edit
    Show -->|削除| Delete

    New -->|保存| List
    Edit -->|更新| Show
    Delete -->|確認| List

    RelatedItems -->|関連エンティティ| Show
```

## 管理画面フロー

```mermaid
flowchart LR
    Admin[管理画面トップ] --> Users[ユーザー管理]
    Admin --> Groups[グループ管理]
    Admin --> Tags[タグ管理]
    Admin --> Fields[カスタムフィールド]
    Admin --> Settings[設定]
    Admin --> Plugins[プラグイン]
    Admin --> ResearchTools[調査ツール]

    Users -->|一覧| UserList[ユーザー一覧]
    Users -->|新規| UserNew[ユーザー作成]
    Users -->|編集| UserEdit[ユーザー編集]
    Users -->|停止/再開| UserSuspend[ユーザー停止]

    Groups -->|一覧| GroupList[グループ一覧]
    Groups -->|新規| GroupNew[グループ作成]
    Groups -->|編集| GroupEdit[グループ編集]

    Tags -->|一覧| TagList[タグ一覧]
    Tags -->|新規| TagNew[タグ作成]
    Tags -->|編集| TagEdit[タグ編集]

    Fields -->|エンティティ選択| FieldEntity[エンティティ別表示]
    FieldEntity -->|フィールドグループ| FieldGroup[フィールドグループ]
    FieldEntity -->|フィールド追加| FieldNew[フィールド作成]

    Settings -->|アプリ設定| AppSettings[アプリケーション設定]
    Settings -->|メール設定| EmailSettings[メール設定]
    Settings -->|検証設定| ValidationSettings[検証設定]
```

## リード変換フロー

```mermaid
flowchart TD
    Lead[リード詳細画面] -->|変換開始| Convert[変換画面]

    Convert --> CreateAccount{取引先を作成?}
    CreateAccount -->|新規| NewAccount[取引先新規入力]
    CreateAccount -->|既存選択| SelectAccount[既存取引先選択]
    CreateAccount -->|なし| NoAccount[取引先なし]

    Convert --> CreateOpp{商談を作成?}
    CreateOpp -->|作成| OppDetails[商談情報入力]
    CreateOpp -->|なし| NoOpp[商談なし]

    NewAccount --> Promote[変換実行]
    SelectAccount --> Promote
    NoAccount --> Promote
    OppDetails --> Promote
    NoOpp --> Promote

    Promote -->|成功| Contact[連絡先詳細画面]
    Promote -->|失敗| Convert
```
