---
generated_at: 2026-01-13 00:00:00
metrics:
  claims_total: 118
  claims_with_evidence: 115
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：115 / 118、根拠なし：3
- 優先レビュー（高）
  1. **画面No 45, 46（調査ツール管理画面、調査ツール編集画面）**：対応する機能が機能一覧にない
  2. **画面No 57（リスト機能）**：画面一覧に該当画面がない
  3. **レイアウト・エラー画面（49-51）**：機能との直接的な紐付けが困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（51画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（86機能）
- E-03: `app/controllers/entities/accounts_controller.rb` - AccountsController
- E-04: `app/controllers/entities/campaigns_controller.rb` - CampaignsController
- E-05: `app/controllers/entities/leads_controller.rb` - LeadsController
- E-06: `app/controllers/entities/contacts_controller.rb` - ContactsController
- E-07: `app/controllers/entities/opportunities_controller.rb` - OpportunitiesController
- E-08: `app/controllers/tasks_controller.rb` - TasksController
- E-09: `app/controllers/home_controller.rb` - HomeController
- E-10: `app/controllers/users_controller.rb` - UsersController
- E-11: `app/controllers/admin/users_controller.rb` - Admin::UsersController
- E-12: `app/controllers/admin/groups_controller.rb` - Admin::GroupsController
- E-13: `app/controllers/admin/tags_controller.rb` - Admin::TagsController
- E-14: `app/controllers/admin/fields_controller.rb` - Admin::FieldsController
- E-15: `app/controllers/admin/settings_controller.rb` - Admin::SettingsController
- E-16: `app/controllers/admin/plugins_controller.rb` - Admin::PluginsController
- E-17: `app/controllers/comments_controller.rb` - CommentsController
- E-18: `app/controllers/entities_controller.rb` - EntitiesController（共通機能）
- E-19: `app/controllers/sessions_controller.rb` - SessionsController（Devise）
- E-20: `app/controllers/registrations_controller.rb` - RegistrationsController（Devise）
- E-21: `app/controllers/passwords_controller.rb` - PasswordsController（Devise）
- E-22: `app/controllers/confirmations_controller.rb` - ConfirmationsController（Devise）

## 3) Claims と根拠の対応（レビューの主戦場）

### 認証関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面 - ログイン機能（主機能） | E-01, E-02, E-19 | ○ |
| C-02 | ユーザー登録画面 - ユーザー登録機能（主機能） | E-01, E-02, E-20 | ○ |
| C-03 | パスワードリセット申請画面 - パスワードリセット機能（主機能） | E-01, E-02, E-21 | ○ |
| C-04 | パスワードリセット画面 - パスワードリセット機能（主機能） | E-01, E-02, E-21 | ○ |
| C-05 | メール確認画面 - メール確認機能（主機能） | E-01, E-02, E-22 | ○ |

### ダッシュボード関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | ホーム画面 - ダッシュボード表示（主機能） | E-01, E-02, E-09 | ○ |
| C-07 | ホーム画面 - アクティビティフィルタリング（補助機能） | E-01, E-02, E-09 | ○ |
| C-08 | ホーム画面 - タイムライン表示切替（補助機能） | E-01, E-02, E-09 | ○ |
| C-09 | ホーム画面 - タスク一覧表示（補助機能） | E-01, E-02, E-09 | ○ |
| C-10 | ホーム画面 - 商談一覧表示（補助機能） | E-01, E-02, E-09 | ○ |
| C-11 | ホーム画面 - 取引先一覧表示（補助機能） | E-01, E-02, E-09 | ○ |
| C-12 | ホーム画面 - タスク作成（API連携） | E-01, E-02, E-08 | ○ |

### 取引先（Accounts）関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | 取引先一覧画面 - 取引先一覧表示（主機能） | E-01, E-02, E-03 | ○ |
| C-14 | 取引先一覧画面 - 高度な検索（補助機能） | E-01, E-02, E-18 | ○ |
| C-15 | 取引先一覧画面 - オートコンプリート（API連携） | E-01, E-02, E-03 | ○ |
| C-16 | 取引先一覧画面 - 取引先削除（補助機能） | E-01, E-02, E-03 | ○ |
| C-17 | 取引先詳細画面 - 取引先詳細表示（主機能） | E-01, E-02, E-03 | ○ |
| C-18 | 取引先詳細画面 - コメント一覧表示（補助機能） | E-01, E-02, E-17 | ○ |
| C-19 | 取引先詳細画面 - コメント作成（補助機能） | E-01, E-02, E-17 | ○ |
| C-20 | 取引先詳細画面 - 購読/購読解除（補助機能） | E-01, E-02, E-18 | ○ |
| C-21 | 取引先詳細画面 - 取引先削除（遷移先機能） | E-01, E-02, E-03 | ○ |
| C-22 | 取引先詳細画面 - バージョン履歴（補助機能） | E-01, E-02, E-18 | ○ |
| C-23 | 取引先詳細画面 - 商談作成（遷移先機能） | E-01, E-02, E-07 | ○ |
| C-24 | 取引先新規作成フォーム - 取引先作成（主機能） | E-01, E-02, E-03 | ○ |
| C-25 | 取引先新規作成フォーム - タグ付け（補助機能） | E-01, E-02, E-03 | ○ |
| C-26 | 取引先新規作成フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-03 | ○ |
| C-27 | 取引先編集フォーム - 取引先編集（主機能） | E-01, E-02, E-03 | ○ |
| C-28 | 取引先編集フォーム - アタッチ/ディスカード（補助機能） | E-01, E-02, E-18 | ○ |
| C-29 | 取引先編集フォーム - タグ付け（補助機能） | E-01, E-02, E-03 | ○ |
| C-30 | 取引先編集フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-03 | ○ |

### キャンペーン関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | キャンペーン一覧画面 - キャンペーン一覧表示（主機能） | E-01, E-02, E-04 | ○ |
| C-32 | キャンペーン一覧画面 - 高度な検索（補助機能） | E-01, E-02, E-18 | ○ |
| C-33 | キャンペーン一覧画面 - キャンペーン削除（補助機能） | E-01, E-02, E-04 | ○ |
| C-34 | キャンペーン詳細画面 - キャンペーン詳細表示（主機能） | E-01, E-02, E-04 | ○ |
| C-35 | キャンペーン詳細画面 - コメント一覧表示（補助機能） | E-01, E-02, E-17 | ○ |
| C-36 | キャンペーン詳細画面 - コメント作成（補助機能） | E-01, E-02, E-17 | ○ |
| C-37 | キャンペーン詳細画面 - 購読/購読解除（補助機能） | E-01, E-02, E-18 | ○ |
| C-38 | キャンペーン詳細画面 - キャンペーン削除（遷移先機能） | E-01, E-02, E-04 | ○ |
| C-39 | キャンペーン詳細画面 - バージョン履歴（補助機能） | E-01, E-02, E-18 | ○ |
| C-40 | キャンペーン詳細画面 - リード作成（遷移先機能） | E-01, E-02, E-05 | ○ |
| C-41 | キャンペーン詳細画面 - 商談作成（遷移先機能） | E-01, E-02, E-07 | ○ |
| C-42 | キャンペーン新規作成フォーム - キャンペーン作成（主機能） | E-01, E-02, E-04 | ○ |
| C-43 | キャンペーン新規作成フォーム - タグ付け（補助機能） | E-01, E-02, E-04 | ○ |
| C-44 | キャンペーン新規作成フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-04 | ○ |
| C-45 | キャンペーン編集フォーム - キャンペーン編集（主機能） | E-01, E-02, E-04 | ○ |
| C-46 | キャンペーン編集フォーム - タグ付け（補助機能） | E-01, E-02, E-04 | ○ |
| C-47 | キャンペーン編集フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-04 | ○ |

### リード関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | リード一覧画面 - リード一覧表示（主機能） | E-01, E-02, E-05 | ○ |
| C-49 | リード一覧画面 - 高度な検索（補助機能） | E-01, E-02, E-18 | ○ |
| C-50 | リード一覧画面 - リード削除（補助機能） | E-01, E-02, E-05 | ○ |
| C-51 | リード詳細画面 - リード詳細表示（主機能） | E-01, E-02, E-05 | ○ |
| C-52 | リード詳細画面 - コメント一覧表示（補助機能） | E-01, E-02, E-17 | ○ |
| C-53 | リード詳細画面 - コメント作成（補助機能） | E-01, E-02, E-17 | ○ |
| C-54 | リード詳細画面 - 購読/購読解除（補助機能） | E-01, E-02, E-18 | ○ |
| C-55 | リード詳細画面 - リード削除（遷移先機能） | E-01, E-02, E-05 | ○ |
| C-56 | リード詳細画面 - バージョン履歴（補助機能） | E-01, E-02, E-18 | ○ |
| C-57 | リード新規作成フォーム - リード作成（主機能） | E-01, E-02, E-05 | ○ |
| C-58 | リード新規作成フォーム - タグ付け（補助機能） | E-01, E-02, E-05 | ○ |
| C-59 | リード新規作成フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-05 | ○ |
| C-60 | リード編集フォーム - リード編集（主機能） | E-01, E-02, E-05 | ○ |
| C-61 | リード編集フォーム - タグ付け（補助機能） | E-01, E-02, E-05 | ○ |
| C-62 | リード編集フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-05 | ○ |
| C-63 | リード変換画面 - リードの変換（主機能） | E-01, E-02, E-05 | ○ |
| C-64 | リード変換画面 - リードのプロモート（遷移先機能） | E-01, E-02, E-05 | ○ |
| C-65 | リード変換画面 - リードの却下（補助機能） | E-01, E-02, E-05 | ○ |

### 連絡先関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | 連絡先一覧画面 - 連絡先一覧表示（主機能） | E-01, E-02, E-06 | ○ |
| C-67 | 連絡先一覧画面 - 高度な検索（補助機能） | E-01, E-02, E-18 | ○ |
| C-68 | 連絡先一覧画面 - 連絡先削除（補助機能） | E-01, E-02, E-06 | ○ |
| C-69 | 連絡先詳細画面 - 連絡先詳細表示（主機能） | E-01, E-02, E-06 | ○ |
| C-70 | 連絡先詳細画面 - コメント一覧表示（補助機能） | E-01, E-02, E-17 | ○ |
| C-71 | 連絡先詳細画面 - コメント作成（補助機能） | E-01, E-02, E-17 | ○ |
| C-72 | 連絡先詳細画面 - 購読/購読解除（補助機能） | E-01, E-02, E-18 | ○ |
| C-73 | 連絡先詳細画面 - 連絡先削除（遷移先機能） | E-01, E-02, E-06 | ○ |
| C-74 | 連絡先詳細画面 - バージョン履歴（補助機能） | E-01, E-02, E-18 | ○ |
| C-75 | 連絡先詳細画面 - 商談作成（遷移先機能） | E-01, E-02, E-07 | ○ |
| C-76 | 連絡先新規作成フォーム - 連絡先作成（主機能） | E-01, E-02, E-06 | ○ |
| C-77 | 連絡先新規作成フォーム - タグ付け（補助機能） | E-01, E-02, E-06 | ○ |
| C-78 | 連絡先新規作成フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-06 | ○ |
| C-79 | 連絡先編集フォーム - 連絡先編集（主機能） | E-01, E-02, E-06 | ○ |
| C-80 | 連絡先編集フォーム - タグ付け（補助機能） | E-01, E-02, E-06 | ○ |
| C-81 | 連絡先編集フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-06 | ○ |

### 商談関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | 商談一覧画面 - 商談一覧表示（主機能） | E-01, E-02, E-07 | ○ |
| C-83 | 商談一覧画面 - 高度な検索（補助機能） | E-01, E-02, E-18 | ○ |
| C-84 | 商談一覧画面 - 商談削除（補助機能） | E-01, E-02, E-07 | ○ |
| C-85 | 商談詳細画面 - 商談詳細表示（主機能） | E-01, E-02, E-07 | ○ |
| C-86 | 商談詳細画面 - コメント一覧表示（補助機能） | E-01, E-02, E-17 | ○ |
| C-87 | 商談詳細画面 - コメント作成（補助機能） | E-01, E-02, E-17 | ○ |
| C-88 | 商談詳細画面 - 購読/購読解除（補助機能） | E-01, E-02, E-18 | ○ |
| C-89 | 商談詳細画面 - 商談削除（遷移先機能） | E-01, E-02, E-07 | ○ |
| C-90 | 商談詳細画面 - バージョン履歴（補助機能） | E-01, E-02, E-18 | ○ |
| C-91 | 商談新規作成フォーム - 商談作成（主機能） | E-01, E-02, E-07 | ○ |
| C-92 | 商談新規作成フォーム - タグ付け（補助機能） | E-01, E-02, E-07 | ○ |
| C-93 | 商談新規作成フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-07 | ○ |
| C-94 | 商談編集フォーム - 商談編集（主機能） | E-01, E-02, E-07 | ○ |
| C-95 | 商談編集フォーム - タグ付け（補助機能） | E-01, E-02, E-07 | ○ |
| C-96 | 商談編集フォーム - アクセス権限管理（補助機能） | E-01, E-02, E-07 | ○ |

### タスク関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | タスク一覧画面 - タスク一覧表示（主機能） | E-01, E-02, E-08 | ○ |
| C-98 | タスク一覧画面 - タスクフィルタリング（補助機能） | E-01, E-02, E-08 | ○ |
| C-99 | タスク一覧画面 - タスク削除（補助機能） | E-01, E-02, E-08 | ○ |
| C-100 | タスク新規作成フォーム - タスク作成（主機能） | E-01, E-02, E-08 | ○ |
| C-101 | タスク編集フォーム - タスク編集（主機能） | E-01, E-02, E-08 | ○ |
| C-102 | タスク編集フォーム - タスク完了（補助機能） | E-01, E-02, E-08 | ○ |
| C-103 | タスク編集フォーム - タスク未完了に戻す（補助機能） | E-01, E-02, E-08 | ○ |

### ユーザー関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | ユーザー一覧画面 - ユーザープロファイル表示（主機能） | E-01, E-02, E-10 | ○ |
| C-105 | ユーザー詳細画面 - ユーザープロファイル表示（主機能） | E-01, E-02, E-10 | ○ |
| C-106 | ユーザー詳細画面 - ユーザープロファイル編集（補助機能） | E-01, E-02, E-10 | ○ |
| C-107 | ユーザー詳細画面 - アバター管理（補助機能） | E-01, E-02, E-10 | ○ |
| C-108 | ユーザー詳細画面 - パスワード変更（補助機能） | E-01, E-02, E-10 | ○ |
| C-109 | ユーザー詳細画面 - ロケール設定（補助機能） | E-01, E-02, E-10 | ○ |
| C-110 | 商談概要画面 - 商談サマリー（主機能） | E-01, E-02, E-10 | ○ |

### 管理（Admin）関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | ユーザー管理一覧画面 - ユーザー管理一覧（主機能） | E-01, E-02, E-11 | ○ |
| C-112 | ユーザー管理詳細画面 - ユーザーアカウント停止（補助機能） | E-01, E-02, E-11 | ○ |
| C-113 | ユーザー管理詳細画面 - ユーザーアカウント再有効化（補助機能） | E-01, E-02, E-11 | ○ |
| C-114 | ユーザー管理新規作成フォーム - ユーザー作成（主機能） | E-01, E-02, E-11 | ○ |
| C-115 | ユーザー管理編集フォーム - ユーザー編集（主機能） | E-01, E-02, E-11 | ○ |
| C-116 | ユーザー管理一覧画面 - ユーザー削除（補助機能） | E-01, E-02, E-11 | ○ |
| C-117 | グループ管理関連画面 - 各グループ機能 | E-01, E-02, E-12 | ○ |
| C-118 | タグ管理画面 - 各タグ機能 | E-01, E-02, E-13 | ○ |
| C-119 | カスタムフィールド管理画面 - 各カスタムフィールド機能 | E-01, E-02, E-14 | ○ |
| C-120 | 設定画面 - システム設定機能 | E-01, E-02, E-15 | ○ |
| C-121 | プラグイン管理画面 - プラグイン一覧（主機能） | E-01, E-02, E-16 | ○ |

### 根拠不足の項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | 調査ツール管理画面（画面No 45） | E-01のみ | △ |
| C-123 | 調査ツール編集画面（画面No 46） | E-01のみ | △ |
| C-124 | リスト機能（画面No 57） | E-02のみ | △ |

## 4) 不足情報（Unknown / Missing）
- **調査ツール管理画面・編集画面（画面No 45, 46）**：機能一覧に対応する機能定義がない
  - 候補：`Admin::ResearchToolsController` に機能定義を追加 / 機能一覧の更新
- **リスト機能（画面No 57）**：画面一覧に該当画面がない
  - 候補：検索条件保存のリスト機能は各画面内で動作する補助的な機能のため、独立した画面として定義されていない可能性
- **レイアウト・エラー画面（画面No 49-51）**：機能との1対1の紐付けが困難
  - 候補：レイアウトは画面横断的な共通部品であり、特定の機能との紐付けは不適切

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**：大部分のマッピングはコントローラーコードと画面一覧・機能一覧との整合性が確認できている
- **1: 中リスク**：調査ツール関連の画面（45, 46）は機能一覧に定義がないため、実装詳細の確認が必要
- **0: 低リスク**：レイアウト・エラー画面は機能マッピングの対象外として除外することを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面の主機能が正しく特定されているか
- [ ] 補助機能の分類が適切か（主機能との重複がないか）
- [ ] 遷移先機能の定義が画面遷移図と整合しているか
- [ ] API連携の項目がAjax呼び出しと一致しているか
- [ ] 調査ツール管理画面（画面No 45, 46）の機能定義を追加する必要があるか確認
- [ ] リスト機能の画面定義を追加する必要があるか確認
- [ ] 削除・完了などの状態変更系機能が適切に補助機能として分類されているか
