# 画面設計書 1-ログイン画面

## 概要

本ドキュメントは、Fat Free CRMのログイン画面の設計仕様を記述したものです。

### 本画面の処理概要

ユーザーがメールアドレス（またはユーザー名）とパスワードを入力してシステムにログインするための認証画面です。

**業務上の目的・背景**：本画面は、Fat Free CRMシステムへのアクセスを制御するための認証ゲートウェイとして機能します。セキュリティを確保しながら、正規ユーザーのみがCRMデータにアクセスできるようにすることを目的としています。未認証ユーザーがシステムの機能や顧客データにアクセスすることを防ぎ、企業の営業情報・顧客情報を保護します。

**画面へのアクセス方法**：ブラウザでアプリケーションのルートURL（`/`）にアクセスすると、未認証の場合は自動的にこのログイン画面（`/users/sign_in`）にリダイレクトされます。また、レガシー互換のため `/login` からもアクセス可能です。

**主要な操作・処理内容**：
1. メールアドレスまたはユーザー名を入力フィールドに入力する
2. パスワードを入力フィールドに入力する
3. 必要に応じて「Remember Me」チェックボックスをオンにする
4. 「Login」ボタンをクリックして認証を実行する
5. 認証成功時、ダッシュボード画面にリダイレクトされる
6. 認証失敗時、エラーメッセージが表示される

**画面遷移**：
- この画面に遷移してくる画面: 任意の認証が必要なページ（未認証時のリダイレクト）、ログアウト後、パスワードリセット完了後
- この画面から遷移できる画面: ホーム画面（ダッシュボード）、ユーザー登録画面、パスワードリセット申請画面

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- `Setting.user_signup` が `:allowed` または `:needs_approval` の場合、新規登録リンクが表示される
- 認証済みユーザーがアクセスした場合は、ダッシュボードにリダイレクトされる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | ログイン | 主機能 | メールアドレス・パスワード入力、認証実行、セッション作成 |

## 画面種別

認証（ログイン）

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/users/sign_in` | sessions#new |
| POST | `/users/sign_in` | sessions#create |
| GET | `/login` | リダイレクト → `/users/sign_in` |

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| メールアドレス/ユーザー名 | email | 入力 | String | 必須 | 254 | ログイン用のメールアドレスまたはユーザー名 |
| パスワード | password | 入力 | String | 必須 | - | ユーザーのパスワード |
| ログイン状態を保持 | remember_me | 入力 | Boolean | 任意 | - | チェック時、セッションを長期間保持 |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| タイトル「Login」 | 常時 | 画面タイトル |
| 新規登録案内テキスト | `User.can_signup?` が true の場合 | "Do not have an account?" |
| 新規登録リンク | `User.can_signup?` が true の場合 | "Sign Up Now!" |
| パスワードリセットリンク | 常時 | "Forgot Password?" |
| エラーメッセージ | 認証失敗時 | 認証エラーの詳細 |

## イベント仕様

### 1-ログインボタン押下

**トリガー**: 「Login」ボタンのクリック

**処理フロー**:
1. フォームデータ（email, password, remember_me）がPOSTリクエストとして送信される
2. `SessionsController#create`（Devise::SessionsController継承）が呼び出される
3. `User.find_for_database_authentication` メソッドでユーザーを検索
   - メールアドレスまたはユーザー名（大文字小文字を区別しない）で検索
4. パスワードの検証を実行
5. ユーザーのアクティブ状態を確認（`active_for_authentication?`）
   - 確認済み（confirmed）
   - 承認待ちでない（not awaiting approval）
   - 停止されていない（not suspended）
6. 認証成功時:
   - セッションを作成
   - `sign_in_count`、`current_sign_in_at`、`current_sign_in_ip`等を更新
   - `remember_me` がオンの場合、remember_tokenを設定
   - ダッシュボード（`/`）にリダイレクト
7. 認証失敗時:
   - エラーメッセージを設定
   - ログイン画面を再表示

### 2-新規登録リンク押下

**トリガー**: "Sign Up Now!" リンクのクリック

**処理フロー**:
1. `/users/sign_up`（ユーザー登録画面）に遷移

### 3-パスワードリセットリンク押下

**トリガー**: "Forgot Password?" リンクのクリック

**処理フロー**:
1. `/users/password/new`（パスワードリセット申請画面）に遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログインボタン押下（成功時） | users | UPDATE | ログイン関連カラムの更新 |
| ログインボタン押下（成功時） | sessions | INSERT/UPDATE | セッション情報の保存 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sign_in_count | 現在値 + 1 | ログイン回数をインクリメント |
| UPDATE | current_sign_in_at | 現在日時 | ログイン日時 |
| UPDATE | last_sign_in_at | 更新前のcurrent_sign_in_at | 前回ログイン日時 |
| UPDATE | current_sign_in_ip | クライアントIPアドレス | 現在のログインIP |
| UPDATE | last_sign_in_ip | 更新前のcurrent_sign_in_ip | 前回ログインIP |
| UPDATE | remember_created_at | 現在日時 | remember_me有効時のみ |
| UPDATE | remember_token | 生成されたトークン | remember_me有効時のみ |

#### sessions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | session_id | 生成されたセッションID | 一意のセッション識別子 |
| INSERT/UPDATE | data | シリアライズされたセッションデータ | ユーザー情報等 |
| INSERT/UPDATE | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| msg_invalig_login | エラー | Invalid username or password. | 認証失敗時 |
| msg_account_suspended | エラー | User account has been suspended. | 停止アカウントでログイン試行時 |
| msg_account_not_approved | エラー | Your account has not been approved yet. | 未承認アカウントでログイン試行時 |
| msg_welcome | 成功 | Welcome to Fat Free CRM! | 初回ログイン成功時 |
| msg_last_login | 情報 | Your last login was on %{value}. | 2回目以降のログイン成功時 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| メールアドレス/ユーザー名が未入力 | バリデーションエラー表示 | ログイン画面（再表示） |
| パスワードが未入力 | バリデーションエラー表示 | ログイン画面（再表示） |
| ユーザーが存在しない | 認証エラーメッセージ表示 | ログイン画面（再表示） |
| パスワードが不一致 | 認証エラーメッセージ表示 | ログイン画面（再表示） |
| アカウントが未確認 | 確認エラーメッセージ表示 | ログイン画面（再表示） |
| アカウントが停止中 | 停止エラーメッセージ表示 | ログイン画面（再表示） |
| アカウントが承認待ち | 承認待ちメッセージ表示 | ログイン画面（再表示） |

## 備考

- Deviseの`database_authenticatable`、`rememberable`、`trackable`モジュールを使用
- ユーザー検索は大文字小文字を区別しない（case-insensitive）
- パスワードは`bcrypt`で暗号化されている
- セッションタイムアウトはRailsのデフォルト設定に依存
- スタンドアロンレイアウト（`_tabless.html.haml`）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザー認証に関わるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | Userモデルの構造、Deviseモジュールの設定、認証関連メソッド（`active_for_authentication?`、`find_for_database_authentication`）を確認 |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブルの構造（認証関連カラム: `sign_in_count`, `current_sign_in_at`等）を確認 |

**読解のコツ**: Userモデルの8-50行目でDeviseの設定とスキーマ情報が確認できます。`devise :database_authenticatable, :registerable, :confirmable, :encryptable, :recoverable, :rememberable, :trackable`（49-50行目）で使用するDeviseモジュールが定義されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sessions_controller.rb | `app/controllers/sessions_controller.rb` | SessionsControllerがDevise::SessionsControllerを継承していることを確認 |
| 2-2 | routes.rb | `config/routes.rb` | `devise_for :users`によるルーティング設定を確認（17-20行目） |

**主要処理フロー**:
1. **8行目**: `SessionsController < Devise::SessionsController` - Devise標準コントローラーを継承
2. **12-14行目**: `after_sign_out_path_for` - ログアウト後のリダイレクト先を定義

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/sessions/new.html.haml` | ログインフォームの構造、入力フィールド、条件分岐を確認 |

**主要処理フロー**:
- **14行目**: `simple_form_for(resource, ...)` - Deviseのresourceを使用したフォーム生成
- **15-18行目**: `User.can_signup?` による新規登録リンクの表示制御
- **22-24行目**: メールアドレス・パスワード入力フィールド
- **27行目**: Remember Meチェックボックス
- **28行目**: ログインボタン
- **31行目**: パスワードリセットリンク

#### Step 4: 認証ロジックを理解する

認証の詳細ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | user.rb | `app/models/users/user.rb` | `find_for_database_authentication`メソッド（206-211行目）、`active_for_authentication?`メソッド（120-122行目）を確認 |

**主要処理フロー**:
- **206-211行目**: ユーザー名またはメールアドレスでユーザーを検索（大文字小文字を区別しない）
- **120-122行目**: 認証可能かどうかの判定（confirmed、not awaiting approval、not suspended）
- **124-134行目**: 認証不可時のメッセージ生成

### プログラム呼び出し階層図

```
ブラウザ (POST /users/sign_in)
    │
    ├─ routes.rb (devise_for :users)
    │      └─ sessions: 'sessions'
    │
    └─ SessionsController#create (継承: Devise::SessionsController)
           │
           ├─ User.find_for_database_authentication
           │      └─ ユーザー検索（email or username）
           │
           ├─ Warden認証（パスワード検証）
           │
           ├─ User#active_for_authentication?
           │      ├─ confirmed?
           │      ├─ awaits_approval?
           │      └─ suspended?
           │
           └─ セッション作成 & リダイレクト
```

### データフロー図

```
[入力]                    [処理]                         [出力]

email/username    ───▶  User.find_for_database_authentication
                             │
password          ───▶  Warden::Strategies::DatabaseAuthenticatable
                             │
remember_me       ───▶  Devise::Rememberable
                             │
                             ▼
                       認証結果判定
                             │
                   ┌─────────┴─────────┐
                   ▼                   ▼
             [成功]                [失敗]
                │                     │
                ▼                     ▼
        usersテーブル更新        エラーメッセージ
        sessionsテーブル更新        │
                │                     ▼
                ▼                 ログイン画面
        ダッシュボード画面         （再表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sessions_controller.rb | `app/controllers/sessions_controller.rb` | コントローラー | ログイン処理の制御 |
| new.html.haml | `app/views/devise/sessions/new.html.haml` | テンプレート | ログインフォームの表示 |
| user.rb | `app/models/users/user.rb` | モデル | ユーザー認証ロジック |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| application.html.haml | `app/views/layouts/application.html.haml` | レイアウト | 共通レイアウト |
| _tabless.html.haml | `app/views/layouts/_tabless.html.haml` | レイアウト | スタンドアロン画面用レイアウト |
| fat_free_crm.en-US.yml | `config/locales/fat_free_crm.en-US.yml` | 設定 | 国際化メッセージ定義 |
