# 画面設計書 16-リード詳細画面

## 概要

Fat Free CRM における特定のリード（見込み客）の詳細情報を表示し、フォローアップ活動を管理するための画面設計書である。

### 本画面の処理概要

本画面は、選択されたリードの詳細情報を表示し、そのリードに対するタスク・コメントを一元的に管理する画面である。また、リードを連絡先・商談・取引先に変換（コンバート）するための導線を提供する。

**業務上の目的・背景**：
営業担当者がリードの詳細情報を確認し、適切なフォローアップを行う必要がある。本画面を通じて、リードの連絡先情報、所属会社、獲得元（キャンペーンなど）、レーティングを確認できる。また、リードに対するタスク管理やコメントによる活動記録を行い、チーム間での情報共有を促進する。十分な商談機会があると判断された場合は、リードを連絡先に変換し、商談プロセスに移行する。

**画面へのアクセス方法**：
1. リード一覧画面でリード名をクリック
2. キャンペーン詳細画面のリード一覧からリンクをクリック
3. URL直接入力: `/leads/:id`

**主要な操作・処理内容**：
1. リード基本情報の表示（氏名、会社、連絡先、ステータス等）
2. レーティング（星評価）の表示
3. 関連タスクの一覧表示・管理
4. タイムライン（コメント・メール）の表示
5. コメントの追加
6. リード情報の編集
7. リードの削除
8. リードの変換（コンバート）画面への遷移
9. リードの却下
10. vCardエクスポート
11. 購読/購読解除（変更通知）
12. バージョン履歴の表示

**画面遷移**：
- 遷移元: リード一覧画面、キャンペーン詳細画面
- 遷移先: リード編集フォーム、リード変換画面、キャンペーン詳細画面、連絡先詳細画面（変換後）

**権限による表示制御**：
- 認証済みユーザーのみアクセス可能
- リードのアクセス権限（Public/Private/Shared/Campaign）に基づいて表示・操作可否が決定
- 編集・削除・変換は作成者または共有されたユーザーのみ可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | リード詳細表示 | 主機能 | リード詳細情報、タイムライン表示、vCardエクスポート |
| 42 | コメント一覧表示 | 補助機能 | リードに紐付くコメント表示 |
| 43 | コメント作成 | 補助機能 | リードへのコメント追加 |
| 86 | 購読/購読解除 | 補助機能 | リードの変更通知購読/解除 |
| 24 | リード削除 | 遷移先機能 | 詳細画面からのリード削除 |
| 85 | バージョン履歴 | 補助機能 | リードの変更履歴追跡 |

## 画面種別

詳細

## URL/ルーティング

| HTTPメソッド | URL | アクション | 説明 |
|-------------|-----|----------|------|
| GET | /leads/:id | show | 詳細表示 |
| GET | /leads/:id.vcf | show | vCard形式でエクスポート |
| DELETE | /leads/:id | destroy | 削除 |
| POST | /leads/:id/subscribe | subscribe | 購読 |
| POST | /leads/:id/unsubscribe | unsubscribe | 購読解除 |
| GET | /leads/:id/convert | convert | 変換画面表示 |
| PUT | /leads/:id/reject | reject | 却下 |

## 入出力項目

### コメント入力

| 項目名 | 入力形式 | 必須 | 説明 |
|--------|---------|------|------|
| コメント本文 | テキストエリア | ○ | リードへのコメント |

## 表示項目

### リード基本情報（サイドバー）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| アバター | image | リードのアバター画像 |
| 役職・会社名 | string | "役職 at 会社名" 形式 |
| 住所 | string | ビジネス住所 |
| 電話番号 | string | 電話番号（do_not_call時は取り消し線） |
| 携帯電話 | string | 携帯番号（do_not_call時は取り消し線） |
| メールアドレス | string | メールアドレス |
| 代替メール | string | 代替メールアドレス |
| Web情報 | string | Blog, LinkedIn, Facebook, Twitter |
| ステータス | string | new/contacted/converted/rejected |
| ソース | string | リード獲得元 |
| レーティング | integer | 星表示 |
| 紹介者 | string | 紹介者名 |
| 担当者 | string | アサインされたユーザー |
| キャンペーン | string | 紐付いたキャンペーン（リンク） |
| 連絡先 | string | 変換後の連絡先（リンク） |
| 背景情報 | text | 背景説明 |
| タグ | string | 付与されたタグ |

### 関連タスク一覧

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| タスク名 | string | タスクの名称 |
| カテゴリ | string | タスクカテゴリ |
| 期日 | date | タスク期日 |
| 担当者 | string | タスク担当者 |

### タイムライン

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| コメント | text | コメント内容 |
| 作成者 | string | コメント作成者名 |
| 作成日時 | datetime | コメント作成日時 |
| メール | text | 関連メール（存在する場合） |

## イベント仕様

### 01-編集ボタン押下

「Edit」ボタンをクリックすると、Ajax通信でリード編集フォーム（_edit.html.haml）が展開される。

### 02-削除ボタン押下

「Delete」ボタンをクリックすると確認ダイアログが表示され、確認後にリードが論理削除され、一覧画面にリダイレクトする。

### 03-変換ボタン押下

「Convert」ボタンをクリックすると、リード変換画面（convert.html.haml）に遷移する。

### 04-却下ボタン押下

「Reject」ボタンをクリックすると、リードのステータスが「rejected」に変更され、一覧画面にリダイレクトする。

### 05-コメント投稿

コメントフォームに入力して送信すると、Ajax通信でコメントが保存され、タイムラインに追加される。

### 06-購読ボタン押下

「Subscribe」ボタンをクリックすると、現在のユーザーがsubscribed_usersに追加される。

### 07-vCardエクスポート

「vCard」リンクをクリックすると、リードの連絡先情報がvCard形式（.vcf）でダウンロードされる。

### 08-キャンペーンリンク押下

サイドバーのキャンペーン名リンクをクリックすると、紐付いたキャンペーンの詳細画面に遷移する。

### 09-連絡先リンク押下

変換済みの場合、サイドバーの連絡先リンクをクリックすると、変換後の連絡先詳細画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | leads | SELECT | リード情報取得 |
| 詳細表示 | tasks | SELECT | 関連タスク取得 |
| 詳細表示 | comments | SELECT | コメント取得 |
| 詳細表示 | versions | INSERT | 閲覧履歴記録 |
| コメント投稿 | comments | INSERT | コメント追加 |
| 削除 | leads | UPDATE | deleted_at への論理削除 |
| 削除 | campaigns | UPDATE | leads_count デクリメント |
| 却下 | leads | UPDATE | status を rejected に変更 |
| 購読 | leads | UPDATE | subscribed_users 配列更新 |

### テーブル別更新項目詳細

#### leads

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | id = :id | 詳細情報取得 |
| UPDATE (削除時) | deleted_at | 現在日時 | 論理削除 |
| UPDATE (却下時) | status | 'rejected' | |
| UPDATE (購読時) | subscribed_users | 配列に current_user.id 追加 | |

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | commentable_type='Lead', commentable_id=:id | |
| INSERT | commentable_type | 'Lead' | |
| INSERT | commentable_id | リードID | |
| INSERT | comment | コメント本文 | |
| INSERT | user_id | current_user.id | |

## メッセージ仕様

| メッセージ種別 | メッセージコード | 表示内容 | 表示条件 |
|--------------|----------------|---------|---------|
| 成功 | msg_asset_deleted | "#{name} has been deleted." | 削除成功時 |
| 成功 | msg_asset_rejected | "#{name} has been rejected." | 却下成功時 |

## 例外処理

| 例外ケース | 処理内容 | 表示 |
|-----------|---------|------|
| 認証エラー | ログイン画面にリダイレクト | Deviseのデフォルトメッセージ |
| 権限エラー | 403エラー | アクセス権限がありません |
| データ未存在 | 404エラー | 該当するリードが見つかりません |

## 備考

- do_not_call フラグがtrueの場合、電話番号は取り消し線で表示される
- vCardエクスポートは helpers.vcard_for メソッドで生成
- タイムラインはコメントとメールを作成日時の降順でマージ
- paper_trail により詳細画面アクセス時にviewイベントが記録される
- リサーチツールへのリンクが設定されている場合、サイドバーに表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lead.rb | `app/models/entities/lead.rb` | リードの関連定義（belongs_to :campaign, has_one :contact）を確認 |
| 1-2 | lead.rb | `app/models/entities/lead.rb` | convert, reject メソッドの実装（136-143行目） |

**読解のコツ**: `full_name` メソッド（158-164行目）で名前表示形式を理解。`do_not_call` フラグで電話番号表示制御を把握。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | leads_controller.rb | `app/controllers/entities/leads_controller.rb` | showアクション（26-32行目） |
| 2-2 | leads_controller.rb | `app/controllers/entities/leads_controller.rb` | rejectアクション（138-148行目） |

**主要処理フロー**:
1. **27-28行目**: コメントオブジェクトとタイムライン取得
2. **30行目**: vCard形式でのレスポンス処理

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/leads/show.html.haml` | メインテンプレート構成 |
| 3-2 | _sidebar_show.html.haml | `app/views/leads/_sidebar_show.html.haml` | サイドバー詳細情報 |
| 3-3 | _title_bar.html.haml | `app/views/leads/_title_bar.html.haml` | タイトルバー |

**主要処理フロー**:
- **9-10行目（show.html.haml）**: タイトルバーとサイドバーのレンダリング
- **11-12行目**: コメント入力フォームとタイムライン表示
- **16-18行目**: タスクとバージョン履歴のセクション

### プログラム呼び出し階層図

```
[HTTP Request: GET /leads/:id]
    │
    ├─ routes.rb (103行目)
    │      └─ LeadsController#show
    │
    ├─ LeadsController#show (26-32行目)
    │      ├─ @lead (CanCanCanによるロード)
    │      ├─ @comment = Comment.new
    │      └─ @timeline = timeline(@lead)
    │             └─ (comments + emails).sort
    │
    └─ leads/show.html.haml
           ├─ leads/_title_bar.html.haml
           ├─ leads/_sidebar_show.html.haml
           │      ├─ アバター表示
           │      ├─ 連絡先情報
           │      ├─ ステータス・ソース・レーティング
           │      ├─ キャンペーン・連絡先リンク
           │      └─ リサーチツール
           ├─ comments/_new.html.haml
           ├─ shared/_timeline.html.haml (collection)
           ├─ tasks/_tasks.html.haml
           └─ versions/_versions.html.haml
```

### データフロー図

```
[入力]                      [処理]                         [出力]

HTTPリクエスト ───▶ ルーティング ───▶ leads/show.html.haml
(GET /leads/:id)          │
                          ▼
                   LeadsController#show
                          │
                   ┌──────┼──────┐
                   ▼      ▼      ▼
                leads   tasks  comments
                  DB      DB      DB
                   │      │      │
                   └──────┼──────┘
                          ▼
                   @lead (詳細)
                   @timeline (コメント+メール)
                          │
                          ▼
                   ビューレンダリング ───▶ HTML/vCard
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lead.rb | `app/models/entities/lead.rb` | モデル | リードのデータモデル定義 |
| leads_controller.rb | `app/controllers/entities/leads_controller.rb` | コントローラー | show, rejectアクション |
| show.html.haml | `app/views/leads/show.html.haml` | ビュー | 詳細画面メインテンプレート |
| _sidebar_show.html.haml | `app/views/leads/_sidebar_show.html.haml` | ビュー | サイドバー詳細情報 |
| _title_bar.html.haml | `app/views/leads/_title_bar.html.haml` | ビュー | タイトルバー |
| _tasks.html.haml | `app/views/tasks/_tasks.html.haml` | ビュー | 関連タスク一覧 |
| _timeline.html.haml | `app/views/shared/_timeline.html.haml` | ビュー | タイムラインパーシャル |
| routes.rb | `config/routes.rb` | 設定 | URLルーティング定義 |
