# 画面設計書 2-ユーザー登録画面

## 概要

本ドキュメントは、Fat Free CRMのユーザー登録画面の設計仕様を記述したものです。

### 本画面の処理概要

新規ユーザーがアカウントを作成するための登録画面です。ユーザー名、メールアドレス、パスワードを入力してアカウントを作成できます。

**業務上の目的・背景**：本画面は、Fat Free CRMシステムに新規ユーザーを登録するためのセルフサービス機能を提供します。システム管理者を介さずにユーザー自身がアカウントを作成できることで、組織への導入時の初期セットアップや新しいチームメンバーの追加を効率化します。ただし、セキュリティ上の観点から、管理者がユーザー登録を無効化したり、承認制にしたりする設定も可能です。

**画面へのアクセス方法**：ログイン画面の「Sign Up Now!」リンクをクリックするか、直接URL `/users/sign_up` にアクセスします。レガシー互換のため `/signup` からもアクセス可能です。ただし、`Setting.user_signup` が `:not_allowed` の場合はアクセスできません。

**主要な操作・処理内容**：
1. ユーザー名を入力フィールドに入力する
2. メールアドレスを入力フィールドに入力する
3. パスワードを入力フィールドに入力する
4. パスワード確認を入力フィールドに入力する
5. 「Sign Up」ボタンをクリックしてアカウントを作成する
6. 登録成功時、確認メールが送信され、ログイン画面にリダイレクトされる
7. 承認制の場合、管理者の承認待ち状態になる

**画面遷移**：
- この画面に遷移してくる画面: ログイン画面（新規登録リンク）
- この画面から遷移できる画面: ログイン画面（登録完了後）、ログイン画面（既存アカウントリンク）

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- `Setting.user_signup` が `:not_allowed` の場合、この画面は利用不可
- 認証済みユーザーがアクセスした場合は、プロフィール画面にリダイレクトされる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 54 | ユーザー登録 | 主機能 | 新規ユーザー情報入力、アカウント作成 |

## 画面種別

登録

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/users/sign_up` | registrations#new |
| POST | `/users` | registrations#create |
| GET | `/signup` | リダイレクト → `/users/sign_up` |

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| ユーザー名 | username | 入力 | String | 必須 | 32 | 英数字、アンダースコア、ハイフンのみ使用可能 |
| メールアドレス | email | 入力 | String | 必須 | 254 | 有効なメールアドレス形式 |
| パスワード | password | 入力 | String | 必須 | - | 新しいパスワード |
| パスワード確認 | password_confirmation | 入力 | String | 必須 | - | パスワードの確認入力 |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| タイトル「Sign Up」 | 常時 | 画面タイトル |
| 既存アカウント案内テキスト | 常時 | "Already signed up?" |
| ログインリンク | 常時 | "Login Now!" |
| エラーメッセージ | バリデーションエラー時 | 入力エラーの詳細 |

## イベント仕様

### 1-Sign Upボタン押下

**トリガー**: 「Sign Up」ボタンのクリック

**処理フロー**:
1. フォームデータ（username, email, password, password_confirmation）がPOSTリクエストとして送信される
2. `RegistrationsController#create`（Devise::RegistrationsController継承）が呼び出される
3. バリデーションを実行
   - ユーザー名: 必須、一意性、フォーマット（英数字・アンダースコア・ハイフン）
   - メールアドレス: 必須、一意性、フォーマット、3-254文字
   - パスワード: 必須、確認との一致
4. `Setting.user_signup` が `:needs_approval` の場合:
   - `suspend_if_needs_approval` コールバックで `suspended_at` を設定
5. Userレコードを作成
6. 確認メールを送信（Deviseの`confirmable`機能）
7. ログイン画面にリダイレクト

### 2-Login Now!リンク押下

**トリガー**: "Login Now!" リンクのクリック

**処理フロー**:
1. `/users/sign_in`（ログイン画面）に遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Sign Upボタン押下（成功時） | users | INSERT | ユーザーレコードの作成 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | username | フォーム入力値 | 必須、一意 |
| INSERT | email | フォーム入力値 | 必須、一意 |
| INSERT | encrypted_password | bcryptでハッシュ化されたパスワード | |
| INSERT | confirmation_token | 生成されたトークン | メール確認用 |
| INSERT | confirmation_sent_at | 現在日時 | 確認メール送信日時 |
| INSERT | sign_in_count | 0 | 初期値 |
| INSERT | admin | false | 初期値 |
| INSERT | suspended_at | 現在日時 or NULL | `needs_approval`設定時のみ設定 |
| INSERT | created_at | 現在日時 | 作成日時 |
| INSERT | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| msg_account_created | 成功 | Your account has been created and is awaiting approval by the system administrator. | 承認制で登録成功時 |
| msg_successful_signup | 成功 | Successful signup, welcome to Fat Free CRM! | 通常登録成功時（確認後） |
| missing_username | エラー | Please specify username. | ユーザー名未入力時 |
| username_taken | エラー | This username is already taken. | ユーザー名重複時 |
| missing_email | エラー | Please specify email address. | メールアドレス未入力時 |
| email_in_use | エラー | There is another user with the same email. | メールアドレス重複時 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| ユーザー名が未入力 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| ユーザー名が重複 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| ユーザー名のフォーマット不正 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| メールアドレスが未入力 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| メールアドレスが重複 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| メールアドレスのフォーマット不正 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| パスワードが未入力 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| パスワード確認が不一致 | バリデーションエラー表示 | ユーザー登録画面（再表示） |
| 新規登録が無効化されている | アクセス拒否 | ログイン画面 |

## 備考

- Deviseの`registerable`、`confirmable`モジュールを使用
- ユーザー名は英数字、アンダースコア、ハイフンのみ許可（`/\A[a-z0-9_-]+\z/i`）
- 登録後、メール確認が完了するまでログインできない
- `Setting.user_signup` が `:needs_approval` の場合、管理者の承認が必要
- スタンドアロンレイアウトを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザー登録に関わるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | Userモデルの構造、バリデーション（87-98行目）、`suspend_if_needs_approval`コールバック（182-184行目）を確認 |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブルの構造を確認 |

**読解のコツ**: Userモデルの87-98行目でバリデーション定義が確認できます。`validates :username, format: { with: /\A[a-z0-9_-]+\z/i }`（95行目）でユーザー名のフォーマットが定義されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | registrations_controller.rb | `app/controllers/registrations_controller.rb` | RegistrationsControllerがDevise::RegistrationsControllerを継承していることを確認 |
| 2-2 | routes.rb | `config/routes.rb` | `devise_for :users`によるルーティング設定を確認（17-20行目） |

**主要処理フロー**:
1. **8行目**: `RegistrationsController < Devise::RegistrationsController` - Devise標準コントローラーを継承
2. **12-14行目**: `edit` - プロフィール画面へリダイレクト
3. **16-18行目**: `after_inactive_sign_up_path_for` - 登録後のリダイレクト先

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/registrations/new.html.haml` | 登録フォームの構造、入力フィールドを確認 |

**主要処理フロー**:
- **2行目**: `simple_form_for(@user, html: one_submit_only)` - フォーム生成
- **3-5行目**: 既存アカウント案内とログインリンク
- **6行目**: タイトル「Sign Up」
- **8行目**: エラーメッセージ表示
- **11-12行目**: ユーザー名入力フィールド
- **13-14行目**: メールアドレス入力フィールド
- **15-16行目**: パスワード入力フィールド
- **17-18行目**: パスワード確認入力フィールド
- **21行目**: Sign Upボタン

#### Step 4: ユーザー登録設定を理解する

登録可否の設定を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | user.rb | `app/models/users/user.rb` | `can_signup?`クラスメソッド（200-202行目）、`suspend_if_needs_approval`（182-184行目）を確認 |
| 4-2 | setting.rb | `app/models/setting.rb` | Settingモデルの構造を確認 |

**主要処理フロー**:
- **200-202行目**: `can_signup?` - `:allowed` または `:needs_approval` の場合に true
- **182-184行目**: `suspend_if_needs_approval` - 承認制の場合に `suspended_at` を設定

### プログラム呼び出し階層図

```
ブラウザ (POST /users)
    │
    ├─ routes.rb (devise_for :users)
    │      └─ registrations: 'registrations'
    │
    └─ RegistrationsController#create (継承: Devise::RegistrationsController)
           │
           ├─ User.new (パラメータ設定)
           │
           ├─ バリデーション実行
           │      ├─ username バリデーション
           │      ├─ email バリデーション
           │      └─ password バリデーション
           │
           ├─ before_create コールバック
           │      └─ suspend_if_needs_approval
           │
           ├─ User.save (DBに保存)
           │
           ├─ 確認メール送信 (Devise::Confirmable)
           │
           └─ リダイレクト (after_inactive_sign_up_path_for)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

username          ───▶  バリデーション
                             │
email             ───▶  バリデーション
                             │
password          ───▶  パスワードハッシュ化
password_confirmation         │
                             ▼
                       User.save
                             │
                   ┌─────────┴─────────┐
                   ▼                   ▼
             [成功]                [失敗]
                │                     │
                ▼                     ▼
        usersテーブルINSERT      エラーメッセージ
        確認メール送信              │
                │                     ▼
                ▼                 ユーザー登録画面
        ログイン画面               （再表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| registrations_controller.rb | `app/controllers/registrations_controller.rb` | コントローラー | ユーザー登録処理の制御 |
| new.html.haml | `app/views/devise/registrations/new.html.haml` | テンプレート | 登録フォームの表示 |
| user.rb | `app/models/users/user.rb` | モデル | ユーザーモデル、バリデーション |
| setting.rb | `app/models/setting.rb` | モデル | システム設定 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| fat_free_crm.en-US.yml | `config/locales/fat_free_crm.en-US.yml` | 設定 | 国際化メッセージ定義 |
