# 画面設計書 3-パスワードリセット申請画面

## 概要

本ドキュメントは、Fat Free CRMのパスワードリセット申請画面の設計仕様を記述したものです。

### 本画面の処理概要

ユーザーがパスワードを忘れた場合に、リセット用のメールを送信するための画面です。メールアドレスを入力することで、パスワードリセット手順を記載したメールが送信されます。

**業務上の目的・背景**：本画面は、パスワードを忘れたユーザーがセルフサービスでアカウントを回復できる機能を提供します。システム管理者やヘルプデスクの負担を軽減し、ユーザーが業務を迅速に再開できるようにすることを目的としています。セキュリティを確保しつつ、ユーザビリティを高めるための重要な機能です。

**画面へのアクセス方法**：ログイン画面の「Forgot Password?」リンクをクリックするか、直接URL `/users/password/new` にアクセスします。

**主要な操作・処理内容**：
1. 登録済みメールアドレスを入力フィールドに入力する
2. 「Reset Password」ボタンをクリックしてリセットメールの送信を要求する
3. メールアドレスが登録されている場合、リセット手順を記載したメールが送信される
4. ログイン画面にリダイレクトされ、メール送信完了メッセージが表示される

**画面遷移**：
- この画面に遷移してくる画面: ログイン画面（パスワードリセットリンク）
- この画面から遷移できる画面: ログイン画面（リセットメール送信後）

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- 認証済みユーザーがアクセスした場合は、ダッシュボードにリダイレクトされる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | パスワードリセット | 主機能 | メールアドレス入力、リセットメール送信 |

## 画面種別

申請（パスワードリセット）

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/users/password/new` | passwords#new |
| POST | `/users/password` | passwords#create |

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| メールアドレス | email | 入力 | String | 必須 | 254 | 登録済みのメールアドレス |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| タイトル「Forgot Password」 | 常時 | 画面タイトル |
| 案内テキスト | 常時 | パスワードリセット手順の説明 |
| エラーメッセージ | メールアドレスが見つからない場合 | エラーの詳細 |

## イベント仕様

### 1-Reset Passwordボタン押下

**トリガー**: 「Reset Password」ボタンのクリック

**処理フロー**:
1. フォームデータ（email）がPOSTリクエストとして送信される
2. `PasswordsController#create`（Devise::PasswordsController継承）が呼び出される
3. メールアドレスでユーザーを検索
4. ユーザーが見つかった場合:
   - `reset_password_token` を生成
   - `reset_password_sent_at` に現在日時を設定
   - usersテーブルを更新
   - リセット手順を記載したメールを送信
5. ユーザーが見つからない場合:
   - エラーメッセージを設定（セキュリティ上、存在しないメールでもメッセージは同じ）
6. ログイン画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Reset Passwordボタン押下（ユーザー存在時） | users | UPDATE | パスワードリセットトークン等の更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | reset_password_token | 生成されたランダムトークン | ハッシュ化して保存 |
| UPDATE | reset_password_sent_at | 現在日時 | トークン送信日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| password_intro | 案内 | Please specify your email address, and the instructions to reset your password will be sent to you. | 常時表示 |
| msg_pwd_instructions_sent | 成功 | Instructions to reset your password have been sent to you. Please check your email. | リセットメール送信成功時 |
| msg_email_not_found | エラー | No user was found with that email address. | メールアドレスが見つからない場合 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| メールアドレスが未入力 | バリデーションエラー表示 | パスワードリセット申請画面（再表示） |
| メールアドレスが登録されていない | エラーメッセージ表示 | パスワードリセット申請画面（再表示） |
| メール送信に失敗 | エラーメッセージ表示 | パスワードリセット申請画面（再表示） |

## 備考

- Deviseの`recoverable`モジュールを使用
- セキュリティ上、メールアドレスの存在有無を漏洩させないよう注意が必要
- リセットトークンには有効期限がある（Deviseの設定による）
- スタンドアロンレイアウトを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パスワードリセットに関わるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | Userモデルの構造、Deviseモジュール（`recoverable`）の設定を確認 |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブルの`reset_password_token`、`reset_password_sent_at`カラムを確認 |

**読解のコツ**: Userモデルの49-50行目で`recoverable`が設定されていることを確認。これによりパスワードリセット機能が有効になります。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/passwords_controller.rb` | PasswordsControllerがDevise::PasswordsControllerを継承していることを確認 |
| 2-2 | routes.rb | `config/routes.rb` | `devise_for :users`によるルーティング設定を確認 |

**主要処理フロー**:
1. **8行目**: `PasswordsController < Devise::PasswordsController` - Devise標準コントローラーを継承
2. Devise::PasswordsController#createが実際の処理を行う

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/passwords/new.html.haml` | パスワードリセット申請フォームの構造を確認 |

**主要処理フロー**:
- **2行目**: `simple_form_for(resource, ...)` - Deviseのresourceを使用したフォーム生成
- **3行目**: タイトル「Forgot Password」
- **4行目**: 案内テキスト（password_intro）
- **6-7行目**: メールアドレス入力フィールド
- **10行目**: Reset Passwordボタン

### プログラム呼び出し階層図

```
ブラウザ (POST /users/password)
    │
    ├─ routes.rb (devise_for :users)
    │      └─ passwords: 'passwords'
    │
    └─ PasswordsController#create (継承: Devise::PasswordsController)
           │
           ├─ User.find_by(email: params[:email])
           │
           ├─ User#send_reset_password_instructions
           │      ├─ generate_reset_password_token
           │      ├─ save (reset_password_token, reset_password_sent_at)
           │      └─ send_email
           │
           └─ リダイレクト (after_sending_reset_password_instructions_path_for)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

email             ───▶  User.find_by(email: ...)
                             │
                   ┌─────────┴─────────┐
                   ▼                   ▼
             [ユーザー存在]        [存在しない]
                │                     │
                ▼                     │
        トークン生成                   │
        usersテーブル更新              │
        リセットメール送信              │
                │                     │
                └─────────┬───────────┘
                          ▼
                    ログイン画面
                    （メッセージ表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/passwords_controller.rb` | コントローラー | パスワードリセット処理の制御 |
| new.html.haml | `app/views/devise/passwords/new.html.haml` | テンプレート | リセット申請フォームの表示 |
| user.rb | `app/models/users/user.rb` | モデル | ユーザーモデル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| fat_free_crm.en-US.yml | `config/locales/fat_free_crm.en-US.yml` | 設定 | 国際化メッセージ定義 |
