# 画面設計書 31-ユーザー一覧画面

## 概要

本ドキュメントは、Fat Free CRMにおけるユーザー一覧画面の設計仕様を記載する。本画面はシステム内の登録ユーザーを一覧表示し、ユーザー情報へのアクセスを提供する。

### 本画面の処理概要

本画面は、Fat Free CRMシステムに登録されているユーザーの一覧を表示する機能を提供する。ただし、現在の実装では「not implemented（未実装）」と表示されており、ユーザー一覧機能は開発中の状態である。

**業務上の目的・背景**：組織内のCRMユーザーを把握し、他のユーザーのプロフィールにアクセスするためのエントリーポイントを提供する。チームメンバー間のコラボレーションや、担当者の確認、ユーザープロフィールへの遷移に利用される。営業チームのメンバー確認や、タスク・商談の担当者を調べる際の起点となる画面である。

**画面へのアクセス方法**：ログイン後、ナビゲーションメニューから「Users」を選択してアクセスする。URLは `/users` となる。Deviseによるユーザーセッションのスコープでアクセスされるため、認証済みユーザーのみがアクセス可能。

**主要な操作・処理内容**：
1. システム内のユーザー一覧を表示（現在は未実装）
2. 個別ユーザーのプロフィール画面への遷移リンク（実装予定）
3. ユーザーの検索・フィルタリング（実装予定）

**画面遷移**：
- 遷移元：ダッシュボード、ナビゲーションメニュー
- 遷移先：ユーザー詳細画面（プロフィール）、商談概要画面

**権限による表示制御**：CanCanCan（load_and_authorize_resource）による権限制御が行われ、認証済みユーザーのみがアクセス可能。管理者と一般ユーザーで表示内容に差異はない（現在は未実装のため表示なし）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | ユーザープロファイル表示 | 主機能 | システム内のユーザー一覧表示 |

## 画面種別

一覧

## URL/ルーティング

| HTTPメソッド | URL | コントローラ#アクション |
|-------------|-----|----------------------|
| GET | /users | users#index (DeviseスコープでUsersControllerにルーティング) |

**ルーティング定義（config/routes.rb 22-29行目）**:
```ruby
devise_scope :user do
  resources :users, only: %i[index show] do
    collection do
      get :opportunities_overview
      match :auto_complete, via: %i[get post]
    end
  end
end
```

## 入出力項目

本画面は現在「未実装」のため、入出力項目は存在しない。

## 表示項目

| 項目名 | 表示内容 | 備考 |
|--------|---------|------|
| タイトル | "User" | t(:user)キーで国際化対応 |
| メッセージ | "not implemented" | t(:not_implemented)キーで国際化対応 |

## イベント仕様

### 1-画面表示

**処理フロー**:
1. ユーザーが `/users` にアクセス
2. UsersController#index は定義されていないため、DeviseスコープのUsersControllerにルーティング
3. index.html.haml が描画され、「未実装」メッセージを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | - | 現在は未実装のためDB操作なし |

## メッセージ仕様

| 種別 | メッセージキー | 表示内容 | 表示条件 |
|------|--------------|---------|---------|
| 情報 | not_implemented | 未実装です | 常時表示 |

## 例外処理

| 例外 | 対応 |
|------|------|
| 未認証アクセス | ログイン画面へリダイレクト |
| 権限なし | 403 Forbiddenを返却 |

## 備考

- 現在の実装では「not implemented」と表示されており、ユーザー一覧機能は実質的に未提供
- 管理者向けのユーザー管理機能（Admin::UsersController）は別途存在し、完全な機能を提供
- 一般ユーザー向けのユーザー一覧機能の実装は将来の課題として残されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Userモデルはシステムの認証・認可の基盤となるデータ構造である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | Userモデルの属性、バリデーション、スコープ、アソシエーション |

**読解のコツ**: Deviseモジュールの組み込み（49-50行目）やhas_manyアソシエーション（53-65行目）を確認し、Userの役割を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routes.rb | `config/routes.rb` | devise_scope内でのルーティング定義（22-29行目） |
| 2-2 | users_controller.rb | `app/controllers/users_controller.rb` | indexアクションが未定義であることを確認 |

**主要処理フロー**:
1. **22行目**: devise_scope :user でDeviseのユーザーセッションスコープを定義
2. **23行目**: resources :users, only: %i[index show] でindex/showのみを許可

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/users/index.html.haml` | 未実装メッセージの表示 |

**主要処理フロー**:
- **1行目**: .title_tools のスタイルクラスを適用
- **2行目**: .title でタイトル「User」を表示
- **3行目**: 「not implemented」メッセージを表示

### プログラム呼び出し階層図

```
リクエスト: GET /users
    │
    ├─ routes.rb (devise_scope)
    │      └─ resources :users, only: [:index, :show]
    │
    ├─ UsersController
    │      └─ indexアクション（未定義）
    │
    └─ index.html.haml
           └─ 「not implemented」を表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト   ───▶ ルーティング解決 ───▶ ビュー描画（未実装表示）
GET /users
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/users/index.html.haml` | ビュー | 一覧画面テンプレート |
| users_controller.rb | `app/controllers/users_controller.rb` | コントローラ | ユーザー関連のアクション処理 |
| user.rb | `app/models/users/user.rb` | モデル | Userモデル定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
