# 画面設計書 32-ユーザー詳細画面（プロフィール）

## 概要

本ドキュメントは、Fat Free CRMにおけるユーザー詳細画面（プロフィール）の設計仕様を記載する。本画面はユーザーの個人情報を表示し、プロフィール編集、アバター管理、パスワード変更などの機能を提供する。

### 本画面の処理概要

本画面は、ユーザーのプロフィール情報を表示し、自身または管理者権限を持つユーザーに対して編集機能を提供する。ユーザーの基本情報（氏名、連絡先等）の閲覧・編集、アバター画像のアップロード・変更、パスワード変更、ロケール設定の変更が可能である。

**業務上の目的・背景**：CRMシステムを利用するユーザーが自身のプロフィール情報を管理し、チームメンバーが他のユーザーの連絡先情報を確認できるようにする。営業活動におけるチーム連携や、システム上の担当者情報の把握に必要な基盤機能を提供する。また、個人設定（ロケール等）のカスタマイズにより、ユーザー体験の向上を図る。

**画面へのアクセス方法**：以下の方法でアクセス可能：
1. ナビゲーションメニューから「Profile」を選択（自分のプロフィール）
2. URL `/profile` または `/users/:id` に直接アクセス
3. ユーザー管理画面や他の画面からのリンク経由

**主要な操作・処理内容**：
1. ユーザープロフィール情報の表示（氏名、役職、会社、メール、電話等）
2. プロフィール情報の編集（edit_profile）
3. アバター画像のアップロード・変更（upload_avatar）
4. Gravatarの利用設定
5. パスワード変更（change_password）
6. ロケール（言語）設定の変更（per_user_locale設定が有効な場合）

**画面遷移**：
- 遷移元：ダッシュボード、ナビゲーションメニュー、ユーザー一覧画面、管理者ユーザー一覧
- 遷移先：商談概要画面、ダッシュボード

**権限による表示制御**：
- 自分自身のプロフィール：全機能（表示・編集）が利用可能
- 管理者によるアクセス：他ユーザーのプロフィール表示・編集が可能
- 一般ユーザーによる他ユーザー閲覧：表示のみ可能（編集リンク非表示）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | ユーザープロファイル表示 | 主機能 | ユーザーのプロフィール情報表示 |
| 48 | ユーザープロファイル編集 | 補助機能 | プロフィール情報の編集 |
| 49 | アバター管理 | 補助機能 | アバター画像のアップロード/変更 |
| 50 | パスワード変更 | 補助機能 | パスワードの変更 |
| 51 | ロケール設定 | 補助機能 | ユーザーのロケール設定変更 |

## 画面種別

詳細 / 編集

## URL/ルーティング

| HTTPメソッド | URL | コントローラ#アクション | 説明 |
|-------------|-----|----------------------|------|
| GET | /users/:id | users#show | プロフィール表示 |
| GET | /profile | users#show | 自分のプロフィール表示 |
| GET | /users/:id/edit | users#edit | プロフィール編集フォーム取得 |
| PUT/PATCH | /users/:id | users#update | プロフィール更新 |
| GET | /users/:id/avatar | users#avatar | アバター編集フォーム取得 |
| PUT/PATCH | /users/:id/upload_avatar | users#upload_avatar | アバターアップロード |
| GET | /users/:id/password | users#password | パスワード変更フォーム取得 |
| PATCH | /users/:id/change_password | users#change_password | パスワード変更 |
| POST | /users/:id/redraw | users#redraw | ロケール変更後の再描画 |

## 入出力項目

### プロフィール編集フォーム

| 項目名 | 項目ID | 入力タイプ | 必須 | 最大長 | 備考 |
|--------|--------|-----------|------|--------|------|
| 名 | first_name | text | - | 32 | |
| 姓 | last_name | text | - | 32 | |
| 役職 | title | text | - | 64 | |
| 会社 | company | text | - | 64 | |
| メール | email | text | ○ | 254 | バリデーションあり |
| 代替メール | alt_email | text | - | 254 | |
| 電話番号 | phone | text | - | 32 | |
| 携帯電話 | mobile | text | - | 32 | |
| AIM | aim | text | - | 32 | メッセンジャーID |
| Yahoo | yahoo | text | - | 32 | メッセンジャーID |
| Google | google | text | - | 32 | メッセンジャーID |
| コメント返信購読 | subscribe_to_comment_replies | checkbox | - | - | |
| 割当通知受信 | receive_assigned_notifications | checkbox | - | - | |

### アバターアップロードフォーム

| 項目名 | 項目ID | 入力タイプ | 必須 | 備考 |
|--------|--------|-----------|------|------|
| 画像ファイル | image | file | ○ | PNG/JPEG/GIF対応 |

### パスワード変更フォーム

| 項目名 | 項目ID | 入力タイプ | 必須 | 備考 |
|--------|--------|-----------|------|------|
| 現在のパスワード | current_password | password | ○ | |
| 新しいパスワード | password | password | ○ | |
| パスワード確認 | password_confirmation | password | ○ | |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|------------|---------|------|
| フルネーム | User#full_name | テキスト | 姓名結合 |
| ユーザー名 | User#username | テキスト | @usernameとして表示 |
| 役職・会社 | User#title, User#company | テキスト | 「{役職} at {会社}」形式 |
| メールアドレス | User#email | リンク | mailto:リンク |
| 代替メール | User#alt_email | リンク | mailto:リンク |
| 電話番号 | User#phone | リンク | tel:リンク |
| 携帯電話 | User#mobile | リンク | tel:リンク |
| アバター | Avatar#image | 画像 | Gravatarまたはアップロード画像 |
| 言語設定 | User#preference[:locale] | ドロップダウン | per_user_locale有効時のみ |

## イベント仕様

### 1-プロフィール表示

**トリガー**: 画面アクセス（GET /users/:id）

**処理フロー**:
1. UsersController#show アクションが呼び出される
2. load_and_authorize_resource により @user がロードされる
3. params[:id] が nil の場合、current_user を @user に設定
4. show.html.haml が描画される

### 2-プロフィール編集リンク押下

**トリガー**: 「Edit Profile」リンクのクリック

**処理フロー**:
1. Ajax で GET /users/:id/edit リクエストが送信される
2. edit.js.haml が応答し、編集フォームを表示

### 3-プロフィール保存

**トリガー**: 編集フォームの「Save Profile」ボタン押下

**処理フロー**:
1. Ajax で PUT /users/:id リクエストが送信される
2. UsersController#update で user_params を検証・更新
3. 成功時: flash[:notice] に成功メッセージを設定
4. update.js.haml が応答し、表示を更新

### 4-アバターアップロード

**トリガー**: アバターフォームの「Upload Picture」ボタン押下

**処理フロー**:
1. multipart/form-data で PUT /users/:id/upload_avatar にリクエスト
2. params[:gravatar] が存在する場合、アバターを削除しGravatarを使用
3. params[:avatar] が存在する場合、Avatar.create で新規作成
4. @user.avatar に紐付け
5. iframe を使用して非同期処理（responds_to_parent）

### 5-パスワード変更

**トリガー**: パスワード変更フォームの「Change Password」ボタン押下

**処理フロー**:
1. Ajax で PATCH /users/:id/change_password にリクエスト
2. 現在のパスワードを valid_password? で検証
3. 新しいパスワードが空白でないことを確認
4. @user.password, @user.password_confirmation を設定して保存
5. 成功/失敗メッセージを設定

### 6-ロケール変更

**トリガー**: 言語選択ドロップダウンの変更

**処理フロー**:
1. POST /users/:id/redraw リクエストが送信される
2. current_user.preference[:locale] を更新
3. JavaScript で画面をリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プロフィール保存 | users | UPDATE | ユーザー情報を更新 |
| アバターアップロード | avatars | INSERT/UPDATE | アバター画像を登録/更新 |
| パスワード変更 | users | UPDATE | encrypted_password を更新 |
| ロケール変更 | preferences | INSERT/UPDATE | ロケール設定を保存 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | username | フォーム入力値 | |
| UPDATE | email | フォーム入力値（strip処理あり） | |
| UPDATE | first_name | フォーム入力値 | |
| UPDATE | last_name | フォーム入力値 | |
| UPDATE | title | フォーム入力値 | |
| UPDATE | company | フォーム入力値 | |
| UPDATE | alt_email | フォーム入力値（strip処理あり） | |
| UPDATE | phone | フォーム入力値 | |
| UPDATE | mobile | フォーム入力値 | |
| UPDATE | aim | フォーム入力値 | |
| UPDATE | yahoo | フォーム入力値 | |
| UPDATE | google | フォーム入力値 | |
| UPDATE | subscribe_to_comment_replies | フォーム入力値 | |
| UPDATE | receive_assigned_notifications | フォーム入力値 | |
| UPDATE | encrypted_password | Deviseで暗号化 | パスワード変更時 |
| UPDATE | updated_at | 現在日時 | 自動更新 |

#### avatars

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | 現在のユーザーID | |
| INSERT | entity_type | 'User' | |
| INSERT | entity_id | @user.id | |
| INSERT | image_file_name | アップロードファイル名 | |
| INSERT | image_content_type | ファイルのMIMEタイプ | |
| INSERT | image_file_size | ファイルサイズ | |

#### preferences

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | user_id | 現在のユーザーID | |
| INSERT/UPDATE | name | 'locale' | |
| INSERT/UPDATE | value | 選択されたロケール値 | |

## メッセージ仕様

| 種別 | メッセージキー | 表示内容 | 表示条件 |
|------|--------------|---------|---------|
| 成功 | msg_user_updated | ユーザー情報が更新されました | プロフィール更新成功時 |
| 成功 | msg_password_changed | パスワードが変更されました | パスワード変更成功時 |
| 警告 | msg_password_not_changed | パスワードは変更されませんでした | 新パスワードが空白の場合 |
| エラー | msg_invalid_password | 現在のパスワードが正しくありません | 現在パスワード検証失敗時 |
| エラー | msg_bad_image_file | 画像ファイルが無効です | アバター画像検証失敗時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| ユーザーが見つからない | 404 Not Found を返却 |
| 権限なし | 403 Forbidden を返却（CanCanCanによる制御） |
| アバター画像サイズ超過 | エラーメッセージを表示 |
| 不正な画像形式 | エラーメッセージを表示 |
| パスワード確認不一致 | バリデーションエラーを表示 |

## 備考

- アバターは Active Storage を使用して管理される
- Gravatarとローカルアバターの切り替えが可能
- ロケール設定は Setting.per_user_locale が有効な場合のみ表示される
- hook(:show_user_bottom, self) により拡張ポイントが提供されている
- iframeを使用した非同期アバターアップロードが実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | Userモデルの属性（8-46行目のスキーマ情報）、アソシエーション（53-65行目） |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブル（433-475行目）、avatarsテーブル（125-134行目）、preferencesテーブル（360-367行目） |

**読解のコツ**: Userモデルにはhas_one :avatar（53行目）とhas_many :preferences（63行目）のアソシエーションがある点に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routes.rb | `config/routes.rb` | profile ルート（33行目）、users リソース（155-163行目） |
| 2-2 | users_controller.rb | `app/controllers/users_controller.rb` | showアクション（20-23行目）、各アクションの処理フロー |

**主要処理フロー**:
1. **9行目**: before_action :set_current_tab で現在のタブ設定
2. **11行目**: check_authorization で権限チェック
3. **13行目**: load_and_authorize_resource でリソースロードと認可
4. **20-23行目**: showアクションで params[:id] が nil なら current_user を使用

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/users/show.html.haml` | 画面構造、編集リンクの表示条件（2行目） |
| 3-2 | _user.html.haml | `app/views/users/_user.html.haml` | プロフィール表示部分、ロケール設定（1-34行目） |
| 3-3 | _profile.html.haml | `app/views/users/_profile.html.haml` | 編集フォームの構造（1-74行目） |
| 3-4 | _avatar.html.haml | `app/views/users/_avatar.html.haml` | アバターアップロードフォーム（1-20行目） |

**主要処理フロー**:
- **show.html.haml 2行目**: 自分または管理者の場合のみ編集リンクを表示
- **_user.html.haml 1行目**: per_user_locale設定により言語選択を表示
- **_profile.html.haml 62-67行目**: メール通知設定のチェックボックス

#### Step 4: JavaScript処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.js.haml | `app/views/users/edit.js.haml` | フォーム表示切替の処理 |

**主要処理フロー**:
- **1-2行目**: キャンセル時はフォームを閉じる
- **4-9行目**: 編集時はフォームを展開

### プログラム呼び出し階層図

```
リクエスト: GET /users/:id
    │
    ├─ routes.rb
    │      └─ resources :users (155-163行目)
    │
    ├─ UsersController
    │      ├─ before_action :set_current_tab
    │      ├─ check_authorization
    │      ├─ load_and_authorize_resource
    │      │      └─ CanCanCan::Ability
    │      │
    │      └─ show (20-23行目)
    │             └─ current_user if params[:id].nil?
    │
    └─ show.html.haml
           ├─ 編集リンク表示判定 (2行目)
           └─ render "user" (11行目)
                  └─ _user.html.haml
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト   ───▶ UsersController#show ───▶ show.html.haml
GET /users/:id        │                            │
                      ├─ @user = User.find(id)     ├─ プロフィール表示
                      │                            └─ 編集リンク（権限に応じて）
                      │
                      └─ Ability#can?(:manage, @user)
```

```
[編集フロー]

フォーム送信     ───▶ UsersController#update ───▶ users テーブル
PUT /users/:id        │                            │
                      ├─ user_params (128-149行目)  └─ UPDATE
                      │      └─ email.strip!
                      │
                      └─ flash[:notice] = t(:msg_user_updated)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/users/show.html.haml` | ビュー | プロフィール詳細画面 |
| _user.html.haml | `app/views/users/_user.html.haml` | パーシャル | プロフィール表示部分 |
| _profile.html.haml | `app/views/users/_profile.html.haml` | パーシャル | プロフィール編集フォーム |
| _avatar.html.haml | `app/views/users/_avatar.html.haml` | パーシャル | アバターアップロードフォーム |
| edit.js.haml | `app/views/users/edit.js.haml` | JavaScript | 編集フォーム表示切替 |
| users_controller.rb | `app/controllers/users_controller.rb` | コントローラ | ユーザー関連アクション |
| user.rb | `app/models/users/user.rb` | モデル | Userモデル定義 |
| avatar.rb | `app/models/fields/avatar.rb` | モデル | Avatarモデル定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
