# 画面設計書 35-ユーザー管理詳細画面

## 概要

本ドキュメントは、Fat Free CRMにおけるユーザー管理詳細画面（管理者用）の設計仕様を記載する。本画面は管理者が特定のユーザーの詳細情報を確認するための画面である。

### 本画面の処理概要

本画面は、管理者がシステム内の特定ユーザーの詳細情報を表示する画面である。ユーザーのフルネームを表示し、編集画面への遷移リンクとユーザー一覧画面への戻りリンクを提供する。シンプルな構成で、主に一覧画面からの詳細確認用途に使用される。

**業務上の目的・背景**：管理者がユーザー情報の確認を行う際の詳細表示画面として機能する。ユーザー管理一覧画面から個別のユーザー情報を確認し、必要に応じて編集画面へ遷移するためのハブとして位置付けられる。ユーザーの基本情報を素早く確認し、管理操作の判断を支援する。

**画面へのアクセス方法**：以下の方法でアクセス可能：
1. ユーザー管理一覧画面からユーザー名リンクをクリック
2. URL `/admin/users/:id` に直接アクセス

**主要な操作・処理内容**：
1. ユーザーのフルネーム表示
2. 編集画面への遷移
3. 一覧画面への戻り

**画面遷移**：
- 遷移元：ユーザー管理一覧画面
- 遷移先：ユーザー管理編集フォーム、ユーザー管理一覧画面

**権限による表示制御**：管理者（admin）ユーザーのみがアクセス可能。Admin::ApplicationControllerの認証・認可により制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | ユーザー管理一覧 | 主機能 | ユーザー詳細確認（管理者用） |
| 63 | ユーザーアカウント停止 | 補助機能 | ユーザーアカウントの停止 |
| 64 | ユーザーアカウント再有効化 | 補助機能 | 停止中アカウントの再有効化 |

## 画面種別

詳細（管理）

## URL/ルーティング

| HTTPメソッド | URL | コントローラ#アクション | 説明 |
|-------------|-----|----------------------|------|
| GET | /admin/users/:id | admin/users#show | ユーザー詳細表示 |

## 入出力項目

本画面は参照専用のため、入力項目はない。

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|------------|---------|------|
| フルネーム | User#full_name | テキスト（タイトル） | h() でエスケープ |

### 操作リンク

| リンク名 | 遷移先 | 備考 |
|---------|-------|------|
| Edit | /admin/users/:id/edit | 編集画面 |
| Back | /admin/users | 一覧画面 |

## イベント仕様

### 1-画面表示

**トリガー**: 画面アクセス（GET /admin/users/:id）

**処理フロー**:
1. Admin::UsersController#show アクションが呼び出される
2. load_resource により @user がロードされる
3. show.html.haml が描画される

**コントローラ処理（admin/users_controller.rb 23-26行目）**:
```ruby
def show
  respond_with(@user)
end
```

### 2-編集リンク押下

**トリガー**: 「Edit」リンクのクリック

**処理フロー**:
1. GET /admin/users/:id/edit へ遷移
2. 編集フォーム画面が表示される

### 3-戻るリンク押下

**トリガー**: 「Back」リンクのクリック

**処理フロー**:
1. GET /admin/users へ遷移
2. ユーザー管理一覧画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users | SELECT | ユーザー情報を取得 |

### テーブル別クエリ詳細

#### users

| 操作 | 条件 | 備考 |
|-----|------|------|
| SELECT | WHERE id = :id | パラメータIDで取得 |

## メッセージ仕様

| 種別 | メッセージキー | 表示内容 | 表示条件 |
|------|--------------|---------|---------|
| ラベル | edit | 編集 | 編集リンク |
| ラベル | back | 戻る | 戻りリンク |

## 例外処理

| 例外 | 対応 |
|------|------|
| ユーザーが見つからない | 404 Not Found を返却 |
| 未認証アクセス | ログイン画面へリダイレクト |
| 管理者以外のアクセス | 403 Forbidden を返却 |

## 備考

- 本画面は非常にシンプルな構成で、ユーザーのフルネームとナビゲーションリンクのみを表示
- より詳細なユーザー情報は一覧画面（_user.html.haml パーシャル）で表示されている
- 編集機能へのエントリーポイントとして機能する
- h() ヘルパーでXSS対策のエスケープ処理が行われている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | full_name メソッド（106-108行目） |

**読解のコツ**: `full_name` メソッドは first_name と last_name が両方空の場合は email を返し、そうでなければ姓名を結合して返す。

```ruby
def full_name
  first_name.blank? && last_name.blank? ? email : "#{first_name} #{last_name}".strip
end
```

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routes.rb | `config/routes.rb` | admin/users リソース（168行目） |
| 2-2 | admin/users_controller.rb | `app/controllers/admin/users_controller.rb` | show アクション（23-26行目） |

**主要処理フロー**:
1. **11行目**: `load_resource except: [:create]` で @user をロード
2. **23行目**: show アクション定義
3. **25行目**: `respond_with(@user)` でレスポンス

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/users/show.html.haml` | 全体構造（1-6行目） |

**主要処理フロー**:
- **1行目**: `.title= h(@user.full_name)` でタイトル表示（XSSエスケープ付き）
- **3-5行目**: ERB埋め込みで編集・戻りリンクを表示

### プログラム呼び出し階層図

```
リクエスト: GET /admin/users/:id
    │
    ├─ routes.rb
    │      └─ namespace :admin { resources :users }
    │
    ├─ Admin::UsersController
    │      ├─ before_action :setup_current_tab
    │      ├─ load_resource (CanCanCan)
    │      │      └─ User.find(params[:id]) => @user
    │      │
    │      └─ show (23-26行目)
    │             └─ respond_with(@user)
    │
    └─ show.html.haml
           ├─ h(@user.full_name) => タイトル表示
           ├─ link_to(t(:edit), edit_admin_user_path(@user))
           └─ link_to(t(:back), admin_users_path)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト   ───▶ Admin::UsersController    ───▶ show.html.haml
GET /admin/users/:id  │                            │
                      ├─ load_resource             ├─ ユーザーフルネーム
                      │      └─ User.find(:id)     │
                      │                            ├─ 編集リンク
                      └─ @user                     │
                                                   └─ 戻りリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/admin/users/show.html.haml` | ビュー | ユーザー管理詳細画面 |
| users_controller.rb | `app/controllers/admin/users_controller.rb` | コントローラ | 管理者用ユーザー操作 |
| user.rb | `app/models/users/user.rb` | モデル | Userモデル定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
