# 画面設計書 36-ユーザー管理新規作成フォーム

## 概要

本ドキュメントは、Fat Free CRMにおけるユーザー管理新規作成フォーム（管理者用）の設計仕様を記載する。本画面は管理者が新規ユーザーを作成するためのフォームを提供する。

### 本画面の処理概要

本画面は、管理者がシステム内に新規ユーザーを作成するためのフォームを提供する。ユーザー名、メールアドレス、パスワード、管理者権限、個人情報（氏名、役職、会社）、グループ所属などを入力し、ユーザーアカウントを作成する。Ajax通信でモーダル/インライン形式で表示される。

**業務上の目的・背景**：CRMシステムに新しいメンバーを追加する際に使用する。管理者が組織に参加する新しいユーザーのアカウントを作成し、必要な権限やグループへの所属を設定する。一般のユーザー登録（自己登録）とは異なり、管理者が直接アカウントを作成・管理することで、組織のセキュリティポリシーに準拠したユーザー管理を実現する。

**画面へのアクセス方法**：以下の方法でアクセス可能：
1. ユーザー管理一覧画面で「Create User」リンクをクリック
2. URL `/admin/users/new` に直接アクセス（Ajax形式）

**主要な操作・処理内容**：
1. ユーザー情報の入力（ユーザー名、メール、パスワード）
2. 管理者権限の設定
3. 個人情報の入力（氏名、役職、会社）
4. グループ所属の設定
5. ユーザー作成の実行

**画面遷移**：
- 遷移元：ユーザー管理一覧画面
- 遷移先：ユーザー管理一覧画面（作成成功後）

**権限による表示制御**：管理者（admin）ユーザーのみがアクセス可能。Admin::ApplicationControllerの認証・認可により制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | ユーザー作成 | 主機能 | 管理者によるユーザー作成 |

## 画面種別

登録（管理 / モーダル / Ajax）

## URL/ルーティング

| HTTPメソッド | URL | コントローラ#アクション | 説明 |
|-------------|-----|----------------------|------|
| GET | /admin/users/new | admin/users#new | 新規作成フォーム取得 |
| POST | /admin/users | admin/users#create | ユーザー作成実行 |

## 入出力項目

### アカウント情報セクション

| 項目名 | 項目ID | 入力タイプ | 必須 | 最大長 | 備考 |
|--------|--------|-----------|------|--------|------|
| ユーザー名 | username | text | ○ | 32 | 半角英数字、ハイフン、アンダースコアのみ |
| メールアドレス | email | text | ○ | 254 | メール形式バリデーション |
| パスワード | password | password | ○ | - | 新規作成時は必須 |
| パスワード確認 | password_confirmation | password | ○ | - | passwordと一致必須 |
| 管理者権限 | admin | checkbox | - | - | チェック時に管理者権限付与 |

### 個人情報セクション

| 項目名 | 項目ID | 入力タイプ | 必須 | 最大長 | 備考 |
|--------|--------|-----------|------|--------|------|
| 名 | first_name | text | - | 32 | |
| 姓 | last_name | text | - | 32 | |
| 役職 | title | text | - | 64 | |
| 会社 | company | text | - | 64 | |

### グループ所属セクション

| 項目名 | 項目ID | 入力タイプ | 必須 | 備考 |
|--------|--------|-----------|------|------|
| グループ | group_ids | select (multiple) | - | select2で複数選択 |

## 表示項目

フォーム入力項目のみ。

## イベント仕様

### 1-フォーム表示

**トリガー**: 「Create User」リンクのクリック

**処理フロー**:
1. Ajax で GET /admin/users/new リクエストが送信される
2. Admin::UsersController#new アクションが呼び出される
3. new.js.haml が応答し、_new.html.haml パーシャルを #create_user 領域に展開

### 2-ユーザー作成

**トリガー**: 「Create User」ボタン押下

**処理フロー**:
1. Ajax で POST /admin/users リクエストが送信される
2. Admin::UsersController#create アクションが呼び出される
3. User.new(user_params) で新規ユーザーオブジェクト作成
4. @user.suspend_if_needs_approval で承認設定確認
5. @user.save でデータベースに保存
6. create.js.haml が応答し、一覧を更新

**コントローラ処理（admin/users_controller.rb 46-52行目）**:
```ruby
def create
  @user = User.new(user_params)
  @user.suspend_if_needs_approval
  @user.save

  respond_with(@user)
end
```

### 3-キャンセル

**トリガー**: 「Cancel」リンクのクリック

**処理フロー**:
1. link_to_cancel により フォームを閉じる
2. 一覧画面の状態に戻る

### 4-フォームクローズ

**トリガー**: 閉じるリンクのクリック

**処理フロー**:
1. link_to_close により フォームを非表示に

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォーム表示 | groups | SELECT | グループ一覧を取得（select2用） |
| ユーザー作成 | users | INSERT | 新規ユーザーを登録 |
| ユーザー作成 | groups_users | INSERT | グループ所属を登録 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | username | フォーム入力値 | |
| INSERT | email | フォーム入力値（strip処理あり） | |
| INSERT | encrypted_password | Deviseで暗号化 | |
| INSERT | first_name | フォーム入力値 | |
| INSERT | last_name | フォーム入力値 | |
| INSERT | title | フォーム入力値 | |
| INSERT | company | フォーム入力値 | |
| INSERT | admin | フォーム入力値（true/false） | |
| INSERT | suspended_at | Time.now または nil | needs_approval設定による |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

#### groups_users（中間テーブル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | group_id | 選択されたグループID | |
| INSERT | user_id | 作成されたユーザーID | |

## メッセージ仕様

| 種別 | メッセージキー | 表示内容 | 表示条件 |
|------|--------------|---------|---------|
| ラベル | create_user | ユーザー作成 | フォームタイトル、送信ボタン |
| ラベル | username | ユーザー名 | 入力フィールドラベル |
| ラベル | email | メールアドレス | 入力フィールドラベル |
| ラベル | password | パスワード | 入力フィールドラベル |
| ラベル | password_confirmation | パスワード確認 | 入力フィールドラベル |
| ラベル | user_is_admin | 管理者権限を付与 | チェックボックスラベル |
| ラベル | personal_information | 個人情報 | セクションタイトル |
| ラベル | first_name | 名 | 入力フィールドラベル |
| ラベル | last_name | 姓 | 入力フィールドラベル |
| ラベル | job_title | 役職 | 入力フィールドラベル |
| ラベル | company | 会社 | 入力フィールドラベル |
| ラベル | group_memberships | グループ所属 | セクションタイトル |
| ラベル | groups | グループ | 入力フィールドラベル |
| エラー | missing_username | ユーザー名を入力してください | username空白時 |
| エラー | username_taken | このユーザー名は既に使用されています | username重複時 |
| エラー | missing_email | メールアドレスを入力してください | email空白時 |
| エラー | email_in_use | このメールアドレスは既に使用されています | email重複時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| バリデーションエラー | エラーメッセージをフォーム上部に表示 |
| ユーザー名重複 | バリデーションエラーとして表示 |
| メールアドレス重複 | バリデーションエラーとして表示 |
| パスワード不一致 | バリデーションエラーとして表示 |
| 未認証アクセス | ログイン画面へリダイレクト |
| 管理者以外のアクセス | 403 Forbidden を返却 |

## 備考

- フォームは Ajax（remote: true）で送信される
- one_submit_only ヘルパーで二重送信を防止
- autocomplete: 'off' でブラウザの自動入力を無効化
- select2 を使用してグループ選択をUIフレンドリーに
- suspend_if_needs_approval により、Setting.user_signup == :needs_approval の場合は suspended_at が設定される
- _profile.html.haml パーシャルを共有して入力フォームを構成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | バリデーション（87-98行目）、suspend_if_needs_approval（182-184行目） |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブル（433-475行目）、groups_usersテーブル（279-285行目） |

**読解のコツ**: `suspend_if_needs_approval` メソッド（182-184行目）は Setting.user_signup が :needs_approval かつ admin でない場合に suspended_at を設定する。

```ruby
def suspend_if_needs_approval
  self.suspended_at = Time.now if Setting.user_signup == :needs_approval && !admin
end
```

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routes.rb | `config/routes.rb` | admin/users リソース（168行目） |
| 2-2 | admin/users_controller.rb | `app/controllers/admin/users_controller.rb` | new, create アクション（31-33, 46-52行目） |

**主要処理フロー**:
1. **31行目**: new アクションでフォーム表示
2. **47行目**: `User.new(user_params)` で新規オブジェクト作成
3. **48行目**: `@user.suspend_if_needs_approval` で承認設定確認
4. **49行目**: `@user.save` で保存

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _new.html.haml | `app/views/admin/users/_new.html.haml` | フォーム構造（1-11行目） |
| 3-2 | _profile.html.haml | `app/views/admin/users/_profile.html.haml` | 共通入力フィールド（1-55行目） |

**主要処理フロー**:
- **_new.html.haml 2行目**: `form_for([:admin, @user], html: one_submit_only.merge({autocomplete: 'off'}), remote: true)` でAjaxフォーム生成
- **_new.html.haml 7行目**: `render "admin/users/profile", f: f` でプロファイル入力部分を描画
- **_profile.html.haml 6-19行目**: アカウント情報（username, email, password）
- **_profile.html.haml 21-26行目**: 管理者チェックボックス
- **_profile.html.haml 28-47行目**: 個人情報（氏名、役職、会社）
- **_profile.html.haml 48-55行目**: グループ所属（select2）

#### Step 4: user_params を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | admin/users_controller.rb | `app/controllers/admin/users_controller.rb` | user_params メソッド（104-129行目） |

**主要処理フロー**:
- **107行目**: password_confirmation が空白の場合 nil に設定
- **108-109行目**: email, alt_email の strip! 処理
- **111-128行目**: 許可するパラメータ一覧（admin, username, email, first_name, last_name, title, company, alt_email, phone, mobile, aim, yahoo, google, password, password_confirmation, group_ids）

### プログラム呼び出し階層図

```
リクエスト: POST /admin/users
    │
    ├─ routes.rb
    │      └─ namespace :admin { resources :users }
    │
    ├─ Admin::UsersController
    │      │
    │      └─ create (46-52行目)
    │             ├─ User.new(user_params)
    │             │      └─ user_params (104-129行目)
    │             │             ├─ :admin
    │             │             ├─ :username
    │             │             ├─ :email (strip!)
    │             │             ├─ :password
    │             │             ├─ :password_confirmation
    │             │             ├─ :first_name, :last_name
    │             │             ├─ :title, :company
    │             │             └─ group_ids: []
    │             │
    │             ├─ @user.suspend_if_needs_approval
    │             │      └─ Setting.user_signup == :needs_approval ?
    │             │
    │             └─ @user.save
    │                    ├─ validations
    │                    ├─ INSERT INTO users
    │                    └─ INSERT INTO groups_users
    │
    └─ create.js.haml
           └─ 一覧更新/エラー表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力     ───▶ Admin::UsersController    ───▶ users テーブル
POST /admin/users     │                            │
                      ├─ user_params               ├─ INSERT user
                      │      └─ email.strip!       │
                      │                            └─ INSERT groups_users
                      ├─ suspend_if_needs_approval
                      │      └─ Setting.user_signup
                      │
                      └─ User#save
                             └─ validations
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| _new.html.haml | `app/views/admin/users/_new.html.haml` | パーシャル | 新規作成フォーム |
| _profile.html.haml | `app/views/admin/users/_profile.html.haml` | パーシャル | プロファイル入力フィールド |
| new.js.haml | `app/views/admin/users/new.js.haml` | JavaScript | フォーム表示処理 |
| create.js.haml | `app/views/admin/users/create.js.haml` | JavaScript | 作成結果処理 |
| users_controller.rb | `app/controllers/admin/users_controller.rb` | コントローラ | 管理者用ユーザー操作 |
| user.rb | `app/models/users/user.rb` | モデル | Userモデル定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
