# 画面設計書 37-ユーザー管理編集フォーム

## 概要

本ドキュメントは、Fat Free CRMにおけるユーザー管理編集フォーム（管理者用）の設計仕様を記載する。本画面は管理者が既存ユーザーの情報を編集するためのフォームを提供する。

### 本画面の処理概要

本画面は、管理者がシステム内の既存ユーザー情報を編集するためのフォームを提供する。ユーザー名、メールアドレス、パスワード（変更時のみ）、管理者権限、個人情報（氏名、役職、会社）、グループ所属などを更新する。Ajax通信でモーダル/インライン形式で表示される。

**業務上の目的・背景**：CRMシステムに登録されているユーザーの情報を更新する際に使用する。ユーザーの役職変更、所属部署の変更、グループメンバーシップの変更、権限の昇格/降格などの管理操作を行う。また、パスワードのリセットや管理者権限の付与/剥奪など、セキュリティに関わる操作も含まれる。

**画面へのアクセス方法**：以下の方法でアクセス可能：
1. ユーザー管理一覧画面で「Edit」リンクをクリック
2. ユーザー管理詳細画面で「Edit」リンクをクリック
3. URL `/admin/users/:id/edit` に直接アクセス（Ajax形式）

**主要な操作・処理内容**：
1. ユーザー情報の編集（ユーザー名、メール、パスワード）
2. 管理者権限の変更
3. 個人情報の更新（氏名、役職、会社）
4. グループ所属の変更
5. ユーザー情報の保存

**画面遷移**：
- 遷移元：ユーザー管理一覧画面、ユーザー管理詳細画面
- 遷移先：ユーザー管理一覧画面（更新成功後）

**権限による表示制御**：
- 管理者（admin）ユーザーのみがアクセス可能
- 自分自身のアカウントを編集する場合、管理者チェックボックスは無効（disabled）になる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | ユーザー編集 | 主機能 | 管理者によるユーザー情報編集 |

## 画面種別

編集（管理 / モーダル / Ajax）

## URL/ルーティング

| HTTPメソッド | URL | コントローラ#アクション | 説明 |
|-------------|-----|----------------------|------|
| GET | /admin/users/:id/edit | admin/users#edit | 編集フォーム取得 |
| PUT/PATCH | /admin/users/:id | admin/users#update | ユーザー更新実行 |

## 入出力項目

### アカウント情報セクション

| 項目名 | 項目ID | 入力タイプ | 必須 | 最大長 | 備考 |
|--------|--------|-----------|------|--------|------|
| ユーザー名 | username | text | ○ | 32 | 半角英数字、ハイフン、アンダースコアのみ |
| メールアドレス | email | text | ○ | 254 | メール形式バリデーション |
| パスワード | password | password | - | - | 空白時は変更なし |
| パスワード確認 | password_confirmation | password | - | - | passwordと一致必須（入力時） |
| 管理者権限 | admin | checkbox | - | - | 自分自身の編集時は無効 |

### 個人情報セクション

| 項目名 | 項目ID | 入力タイプ | 必須 | 最大長 | 備考 |
|--------|--------|-----------|------|--------|------|
| 名 | first_name | text | - | 32 | |
| 姓 | last_name | text | - | 32 | |
| 役職 | title | text | - | 64 | |
| 会社 | company | text | - | 64 | |

### グループ所属セクション

| 項目名 | 項目ID | 入力タイプ | 必須 | 備考 |
|--------|--------|-----------|------|------|
| グループ | group_ids | select (multiple) | - | select2で複数選択 |

## 表示項目

フォーム入力項目のみ。現在の値がプリセットされる。

## イベント仕様

### 1-フォーム表示

**トリガー**: 「Edit」リンクのクリック

**処理フロー**:
1. Ajax で GET /admin/users/:id/edit リクエストが送信される
2. Admin::UsersController#edit アクションが呼び出される
3. detect_previous_id で前回編集中のユーザーIDを取得（連続編集対応）
4. edit.js.haml が応答し、_edit.html.haml パーシャルを展開

**コントローラ処理（admin/users_controller.rb 36-41行目）**:
```ruby
def edit
  @previous = User.find_by_id(detect_previous_id) || detect_previous_id if detect_previous_id

  respond_with(@user)
end
```

### 2-ユーザー更新

**トリガー**: 「Save User」ボタン押下

**処理フロー**:
1. Ajax で PUT/PATCH /admin/users/:id リクエストが送信される
2. Admin::UsersController#update アクションが呼び出される
3. @user.attributes = user_params で属性を設定
4. @user.save でデータベースに保存
5. update.js.haml が応答し、一覧を更新

**コントローラ処理（admin/users_controller.rb 56-63行目）**:
```ruby
def update
  @user = User.find(params[:id])
  @user.attributes = user_params
  @user.save

  respond_with(@user)
end
```

### 3-キャンセル

**トリガー**: 「Cancel」リンクのクリック

**処理フロー**:
1. link_to_cancel により フォームを閉じる
2. 一覧画面の状態に戻る

### 4-フォームクローズ

**トリガー**: 閉じるリンクのクリック

**処理フロー**:
1. link_to_close により フォームを非表示に

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォーム表示 | users, groups | SELECT | ユーザー情報、グループ一覧を取得 |
| ユーザー更新 | users | UPDATE | ユーザー情報を更新 |
| ユーザー更新 | groups_users | DELETE/INSERT | グループ所属を更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | username | フォーム入力値 | |
| UPDATE | email | フォーム入力値（strip処理あり） | |
| UPDATE | encrypted_password | Deviseで暗号化 | パスワード入力時のみ |
| UPDATE | first_name | フォーム入力値 | |
| UPDATE | last_name | フォーム入力値 | |
| UPDATE | title | フォーム入力値 | |
| UPDATE | company | フォーム入力値 | |
| UPDATE | admin | フォーム入力値（true/false） | 自分自身の場合は変更不可 |
| UPDATE | updated_at | 現在日時 | 自動更新 |

#### groups_users（中間テーブル）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE user_id = :id | 既存の所属を削除 |
| INSERT | group_id | 選択されたグループID | |
| INSERT | user_id | 編集対象ユーザーID | |

## メッセージ仕様

| 種別 | メッセージキー | 表示内容 | 表示条件 |
|------|--------------|---------|---------|
| ラベル | save_user | ユーザー保存 | 送信ボタン |
| ラベル | username | ユーザー名 | 入力フィールドラベル |
| ラベル | email | メールアドレス | 入力フィールドラベル |
| ラベル | password | パスワード | 入力フィールドラベル |
| ラベル | password_confirmation | パスワード確認 | 入力フィールドラベル |
| ラベル | user_is_admin | 管理者権限を付与 | チェックボックスラベル |
| ラベル | personal_information | 個人情報 | セクションタイトル |
| ラベル | group_memberships | グループ所属 | セクションタイトル |
| エラー | missing_username | ユーザー名を入力してください | username空白時 |
| エラー | username_taken | このユーザー名は既に使用されています | username重複時 |
| エラー | email_in_use | このメールアドレスは既に使用されています | email重複時 |

## 例外処理

| 例外 | 対応 |
|------|------|
| ユーザーが見つからない | 404 Not Found を返却 |
| バリデーションエラー | エラーメッセージをフォーム上部に表示 |
| ユーザー名重複 | バリデーションエラーとして表示 |
| メールアドレス重複 | バリデーションエラーとして表示 |
| パスワード不一致 | バリデーションエラーとして表示 |
| 未認証アクセス | ログイン画面へリダイレクト |
| 管理者以外のアクセス | 403 Forbidden を返却 |

## 備考

- フォームは Ajax（remote: true）で送信される
- one_submit_only ヘルパーで二重送信を防止
- autocomplete: 'off' でブラウザの自動入力を無効化
- select2 を使用してグループ選択をUIフレンドリーに
- パスワードフィールドが空白の場合、パスワードは変更されない（password_confirmation が空白の場合は nil に設定）
- 自分自身の admin チェックボックスは disabled になり、権限の自己剥奪を防止
- _profile.html.haml パーシャルを共有し、edit: true フラグで編集モードを判定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | バリデーション（87-98行目）、password_required?（164-166行目） |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブル（433-475行目）、groups_usersテーブル（279-285行目） |

**読解のコツ**: `password_required?` メソッド（164-166行目）は、新規作成時またはパスワード/確認が入力された場合のみ true を返す。これにより、編集時にパスワード空白でも更新可能。

```ruby
def password_required?
  !persisted? || !password.nil? || !password_confirmation.nil?
end
```

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routes.rb | `config/routes.rb` | admin/users リソース（168行目） |
| 2-2 | admin/users_controller.rb | `app/controllers/admin/users_controller.rb` | edit, update アクション（36-41, 56-63行目） |

**主要処理フロー**:
1. **36行目**: edit アクションでフォーム表示
2. **38行目**: `detect_previous_id` で連続編集対応
3. **57行目**: `User.find(params[:id])` でユーザー取得
4. **58行目**: `@user.attributes = user_params` で属性設定
5. **59行目**: `@user.save` で保存

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _edit.html.haml | `app/views/admin/users/_edit.html.haml` | フォーム構造（1-11行目） |
| 3-2 | _profile.html.haml | `app/views/admin/users/_profile.html.haml` | 共通入力フィールド、edit フラグ使用（1, 24行目） |

**主要処理フロー**:
- **_edit.html.haml 2行目**: `form_for([:admin, @user], html: one_submit_only.merge({autocomplete: 'off'}), remote: true)` でAjaxフォーム生成
- **_edit.html.haml 7行目**: `render "admin/users/profile", f: f, edit: true` でプロファイル入力部分を描画（edit: true）
- **_profile.html.haml 1行目**: `edit ||= false` でデフォルト値設定
- **_profile.html.haml 24行目**: `f.check_box(:admin, { disabled: edit && @user == current_user })` で自分自身の場合は無効化

#### Step 4: user_params を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | admin/users_controller.rb | `app/controllers/admin/users_controller.rb` | user_params メソッド（104-129行目） |

**主要処理フロー**:
- **107行目**: `password_confirmation` が空白の場合 nil に設定（パスワード変更しない場合の対応）
- **108-109行目**: email, alt_email の strip! 処理

### プログラム呼び出し階層図

```
リクエスト: PUT /admin/users/:id
    │
    ├─ routes.rb
    │      └─ namespace :admin { resources :users }
    │
    ├─ Admin::UsersController
    │      │
    │      └─ update (56-63行目)
    │             ├─ User.find(params[:id])
    │             │
    │             ├─ @user.attributes = user_params
    │             │      └─ user_params (104-129行目)
    │             │             ├─ password_confirmation が空白なら nil
    │             │             └─ email.strip!
    │             │
    │             └─ @user.save
    │                    ├─ validations
    │                    │      └─ password_required? (164-166行目)
    │                    ├─ UPDATE users
    │                    └─ DELETE/INSERT groups_users
    │
    └─ update.js.haml
           └─ 一覧更新/エラー表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力     ───▶ Admin::UsersController    ───▶ users テーブル
PUT /admin/users/:id  │                            │
                      ├─ User.find(id)             ├─ UPDATE user
                      │                            │
                      ├─ user_params               └─ UPDATE groups_users
                      │      ├─ password_confirmation → nil (空白時)
                      │      └─ email.strip!
                      │
                      └─ @user.save
                             └─ password_required?
                                    └─ !persisted? || !password.nil?
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| _edit.html.haml | `app/views/admin/users/_edit.html.haml` | パーシャル | 編集フォーム |
| _profile.html.haml | `app/views/admin/users/_profile.html.haml` | パーシャル | プロファイル入力フィールド |
| edit.js.haml | `app/views/admin/users/edit.js.haml` | JavaScript | フォーム表示処理 |
| update.js.haml | `app/views/admin/users/update.js.haml` | JavaScript | 更新結果処理 |
| users_controller.rb | `app/controllers/admin/users_controller.rb` | コントローラ | 管理者用ユーザー操作 |
| user.rb | `app/models/users/user.rb` | モデル | Userモデル定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
