# 画面設計書 39-グループ管理詳細画面

## 概要

本ドキュメントは、Fat Free CRMにおけるグループ管理詳細画面（管理者用）の設計仕様を記載する。本画面は管理者が特定のグループの詳細情報を確認するための画面である。

### 本画面の処理概要

本画面は、管理者がシステム内の特定グループの詳細情報を表示する画面である。グループ名とそのグループに所属するメンバー（ユーザー）の一覧を表示し、編集画面への遷移リンクとグループ一覧画面への戻りリンクを提供する。

**業務上の目的・背景**：管理者がグループ情報の確認を行う際の詳細表示画面として機能する。グループに所属するユーザーを一覧で確認でき、グループの構成を把握する際に利用される。必要に応じて編集画面へ遷移し、メンバーの追加・削除を行うためのハブとして位置付けられる。

**画面へのアクセス方法**：以下の方法でアクセス可能：
1. グループ管理一覧画面からグループ詳細へのリンクをクリック
2. URL `/admin/groups/:id` に直接アクセス

**主要な操作・処理内容**：
1. グループ名の表示
2. グループメンバー（所属ユーザー）の一覧表示
3. 編集画面への遷移
4. 一覧画面への戻り

**画面遷移**：
- 遷移元：グループ管理一覧画面
- 遷移先：グループ管理編集フォーム、グループ管理一覧画面

**権限による表示制御**：管理者（admin）ユーザーのみがアクセス可能。Admin::ApplicationControllerの認証・認可により制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | グループ管理一覧 | 主機能 | グループ詳細確認（管理者用） |

## 画面種別

詳細（管理）

## URL/ルーティング

| HTTPメソッド | URL | コントローラ#アクション | 説明 |
|-------------|-----|----------------------|------|
| GET | /admin/groups/:id | admin/groups#show | グループ詳細表示 |

## 入出力項目

本画面は参照専用のため、入力項目はない。

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|------------|---------|------|
| グループ名 | Group#name | テキスト（タイトル） | h() でエスケープ |
| メンバー | Group#users | ユーザー名リスト | 各ユーザー名を h() でエスケープ |

### 操作リンク

| リンク名 | 遷移先 | 備考 |
|---------|-------|------|
| Edit | /admin/groups/:id/edit | 編集画面 |
| Back | /admin/groups | 一覧画面 |

## イベント仕様

### 1-画面表示

**トリガー**: 画面アクセス（GET /admin/groups/:id）

**処理フロー**:
1. Admin::GroupsController#show アクションが呼び出される
2. load_resource により @group がロードされる
3. show.html.haml が描画される

**コントローラ処理（admin/groups_controller.rb 20-23行目）**:
```ruby
def show
  respond_with(@group)
end
```

### 2-編集リンク押下

**トリガー**: 「Edit」リンクのクリック

**処理フロー**:
1. GET /admin/groups/:id/edit へ遷移
2. 編集フォーム画面が表示される

### 3-戻るリンク押下

**トリガー**: 「Back」リンクのクリック

**処理フロー**:
1. GET /admin/groups へ遷移
2. グループ管理一覧画面が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | groups, users, groups_users | SELECT | グループ情報とメンバーを取得 |

### テーブル別クエリ詳細

#### groups

| 操作 | 条件 | 備考 |
|-----|------|------|
| SELECT | WHERE id = :id | パラメータIDで取得 |

#### users（groups経由）

| 操作 | 条件 | 備考 |
|-----|------|------|
| SELECT | INNER JOIN groups_users WHERE group_id = :id | メンバー取得 |

## メッセージ仕様

| 種別 | メッセージキー | 表示内容 | 表示条件 |
|------|--------------|---------|---------|
| ラベル | edit | 編集 | 編集リンク |
| ラベル | back | 戻る | 戻りリンク |

## 例外処理

| 例外 | 対応 |
|------|------|
| グループが見つからない | 404 Not Found を返却 |
| 未認証アクセス | ログイン画面へリダイレクト |
| 管理者以外のアクセス | 403 Forbidden を返却 |

## 備考

- 本画面はシンプルな構成で、グループ名とメンバー一覧を表示
- メンバーはユーザー名のみを表示（リンクなし）
- h() ヘルパーでXSS対策のエスケープ処理が行われている
- メンバーが存在しない場合は、メンバーセクションは空で表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/users/group.rb` | Groupモデルの構造、has_and_belongs_to_many :users（9行目） |
| 1-2 | schema.rb | `db/schema.rb` | groupsテーブル（273-277行目）、groups_usersテーブル（279-285行目） |

**読解のコツ**: Groupモデルは中間テーブル groups_users を通じてユーザーと多対多のアソシエーションを持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routes.rb | `config/routes.rb` | admin/groups リソース（166行目） |
| 2-2 | admin/groups_controller.rb | `app/controllers/admin/groups_controller.rb` | show アクション（20-23行目） |

**主要処理フロー**:
1. **12行目**: `load_resource` で @group をロード
2. **20行目**: show アクション定義
3. **22行目**: `respond_with(@group)` でレスポンス

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/groups/show.html.haml` | 全体構造（1-12行目） |

**主要処理フロー**:
- **1行目**: `.title= h(@group.name)` でタイトル表示（XSSエスケープ付き）
- **3-6行目**: `.members` セクションでメンバー一覧をループ表示
- **8-11行目**: 編集・戻りリンクを表示

### プログラム呼び出し階層図

```
リクエスト: GET /admin/groups/:id
    │
    ├─ routes.rb
    │      └─ namespace :admin { resources :groups }
    │
    ├─ Admin::GroupsController
    │      ├─ before_action :setup_current_tab
    │      ├─ load_resource (CanCanCan)
    │      │      └─ Group.find(params[:id]) => @group
    │      │
    │      └─ show (20-23行目)
    │             └─ respond_with(@group)
    │
    └─ show.html.haml
           ├─ h(@group.name) => タイトル表示
           ├─ @group.users.each => メンバーループ
           │      └─ h(user.name) => ユーザー名表示
           ├─ link_to(t(:edit), edit_admin_group_path(@group))
           └─ link_to(t(:back), admin_groups_path)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト   ───▶ Admin::GroupsController   ───▶ show.html.haml
GET /admin/groups/:id │                            │
                      ├─ load_resource             ├─ グループ名
                      │      └─ Group.find(:id)    │
                      │                            ├─ メンバー一覧
                      └─ @group                    │      └─ @group.users.each
                             │                     │
                             └─ users アソシエーション
                                    │              ├─ 編集リンク
                                    └─ groups_users│
                                          JOIN     └─ 戻りリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/admin/groups/show.html.haml` | ビュー | グループ管理詳細画面 |
| groups_controller.rb | `app/controllers/admin/groups_controller.rb` | コントローラ | 管理者用グループ操作 |
| group.rb | `app/models/users/group.rb` | モデル | Groupモデル定義 |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
