# 画面設計書 4-パスワードリセット画面

## 概要

本ドキュメントは、Fat Free CRMのパスワードリセット画面の設計仕様を記述したものです。

### 本画面の処理概要

パスワードリセットメールに記載されたリンクからアクセスし、新しいパスワードを設定するための画面です。

**業務上の目的・背景**：本画面は、パスワードリセット申請後に送信されるメールのリンクからアクセスし、新しいパスワードを安全に設定するための機能を提供します。リセットトークンによる認証を行うことで、正規のユーザーのみがパスワードを変更できるようセキュリティを確保しています。

**画面へのアクセス方法**：パスワードリセットメールに記載されたリンク（`/users/password/edit?reset_password_token=xxx`）をクリックしてアクセスします。直接URLにアクセスする場合は、有効なリセットトークンが必要です。

**主要な操作・処理内容**：
1. 新しいパスワードを入力フィールドに入力する
2. パスワード確認を入力フィールドに入力する
3. 「Update Password and Login」ボタンをクリックしてパスワードを更新する
4. 更新成功時、自動的にログインしてダッシュボードにリダイレクトされる

**画面遷移**：
- この画面に遷移してくる画面: パスワードリセットメールのリンク
- この画面から遷移できる画面: ホーム画面（ダッシュボード）- 更新成功時、ログイン画面 - トークン無効時

**権限による表示制御**：
- 有効なリセットトークンを持つユーザーのみがアクセス可能
- トークンが無効または期限切れの場合はエラー表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | パスワードリセット | 主機能 | 新しいパスワード入力、パスワード変更 |

## 画面種別

編集（パスワードリセット）

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/users/password/edit?reset_password_token=xxx` | passwords#edit |
| PUT | `/users/password` | passwords#update |

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| リセットトークン | reset_password_token | 入力（hidden） | String | 必須 | - | パスワードリセット用トークン |
| 新しいパスワード | password | 入力 | String | 必須 | - | 新しいパスワード |
| パスワード確認 | password_confirmation | 入力 | String | 必須 | - | パスワードの確認入力 |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| タイトル「Reset Password」 | 常時 | 画面タイトル |
| 案内テキスト | 常時 | パスワード入力の説明 |
| エラーメッセージ | バリデーションエラー時 | 入力エラーの詳細 |

## イベント仕様

### 1-Update Password and Loginボタン押下

**トリガー**: 「Update Password and Login」ボタンのクリック

**処理フロー**:
1. フォームデータ（reset_password_token, password, password_confirmation）がPUTリクエストとして送信される
2. `PasswordsController#update`（Devise::PasswordsController継承）が呼び出される
3. リセットトークンを検証
   - トークンの有効性確認
   - トークンの有効期限確認
4. パスワードのバリデーション
   - 必須チェック
   - 確認との一致チェック
5. バリデーション成功時:
   - パスワードを更新（ハッシュ化）
   - `reset_password_token`、`reset_password_sent_at` をクリア
   - 自動的にログイン
   - ダッシュボードにリダイレクト
6. バリデーション失敗時:
   - エラーメッセージを表示
   - パスワードリセット画面を再表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Update Password and Loginボタン押下（成功時） | users | UPDATE | パスワードとリセットトークンの更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | encrypted_password | bcryptでハッシュ化された新パスワード | |
| UPDATE | reset_password_token | NULL | トークンをクリア |
| UPDATE | reset_password_sent_at | NULL | 送信日時をクリア |
| UPDATE | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| confirm_password_intro | 案内 | Please type your new password and then confirm it. | 常時表示 |
| msg_password_updated | 成功 | Password was successfully updated. | パスワード更新成功時 |
| msg_enter_new_password | 案内 | Please enter your new password. | パスワード入力促進時 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| リセットトークンが無効 | エラーメッセージ表示 | パスワードリセット申請画面 |
| リセットトークンが期限切れ | エラーメッセージ表示 | パスワードリセット申請画面 |
| パスワードが未入力 | バリデーションエラー表示 | パスワードリセット画面（再表示） |
| パスワード確認が不一致 | バリデーションエラー表示 | パスワードリセット画面（再表示） |

## 備考

- Deviseの`recoverable`モジュールを使用
- リセットトークンはURLパラメータとして渡され、hiddenフィールドに設定される
- パスワード更新成功時は自動的にログインする
- スタンドアロンレイアウトを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パスワードリセットに関わるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | Userモデルの構造、Deviseモジュール（`recoverable`）の設定を確認 |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブルの`reset_password_token`、`reset_password_sent_at`、`encrypted_password`カラムを確認 |

**読解のコツ**: Userモデルの49-50行目で`recoverable`が設定されていることを確認。これによりパスワードリセット機能が有効になります。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | passwords_controller.rb | `app/controllers/passwords_controller.rb` | PasswordsControllerがDevise::PasswordsControllerを継承していることを確認 |
| 2-2 | routes.rb | `config/routes.rb` | `devise_for :users`によるルーティング設定を確認 |

**主要処理フロー**:
1. **8行目**: `PasswordsController < Devise::PasswordsController` - Devise標準コントローラーを継承
2. Devise::PasswordsController#edit、#updateが実際の処理を行う

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/devise/passwords/edit.html.haml` | パスワードリセットフォームの構造を確認 |

**主要処理フロー**:
- **2行目**: `simple_form_for(resource, ..., html: { method: :put })` - PUTメソッドでフォーム送信
- **3行目**: タイトル「Reset Password」
- **5行目**: エラーメッセージ表示
- **7行目**: 案内テキスト
- **9行目**: リセットトークン（hiddenフィールド）
- **12-13行目**: 新しいパスワード入力フィールド
- **14-15行目**: パスワード確認入力フィールド
- **18行目**: Update Password and Loginボタン

### プログラム呼び出し階層図

```
ブラウザ (PUT /users/password)
    │
    ├─ routes.rb (devise_for :users)
    │      └─ passwords: 'passwords'
    │
    └─ PasswordsController#update (継承: Devise::PasswordsController)
           │
           ├─ トークン検証
           │      └─ find_by(reset_password_token: ...)
           │
           ├─ パスワードバリデーション
           │
           ├─ User.save
           │      ├─ encrypted_password 更新
           │      └─ reset_password_token, reset_password_sent_at クリア
           │
           ├─ 自動ログイン (sign_in)
           │
           └─ リダイレクト (after_sign_in_path_for)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

reset_password_token ───▶  トークン検証
                             │
password          ───▶  バリデーション
password_confirmation        │
                             ▼
                       パスワード更新
                             │
                   ┌─────────┴─────────┐
                   ▼                   ▼
             [成功]                [失敗]
                │                     │
                ▼                     ▼
        usersテーブル更新        エラーメッセージ
        自動ログイン                │
                │                     ▼
                ▼                 パスワードリセット画面
        ダッシュボード画面         （再表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| passwords_controller.rb | `app/controllers/passwords_controller.rb` | コントローラー | パスワードリセット処理の制御 |
| edit.html.haml | `app/views/devise/passwords/edit.html.haml` | テンプレート | パスワード入力フォームの表示 |
| user.rb | `app/models/users/user.rb` | モデル | ユーザーモデル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| fat_free_crm.en-US.yml | `config/locales/fat_free_crm.en-US.yml` | 設定 | 国際化メッセージ定義 |
