# 画面設計書 44-カスタムフィールド詳細画面

## 概要

本ドキュメントは、Fat Free CRMの管理画面におけるカスタムフィールド詳細画面の設計書です。管理者が個々のカスタムフィールドの詳細情報を確認し、編集操作を行うための画面を定義します。

### 本画面の処理概要

本画面は、カスタムフィールドの詳細情報（ラベル、フィールド名、テーブル名、フィールドタイプ、作成日時、更新日時など）を表示する画面です。フィールドの設定内容を確認し、必要に応じて編集画面へ遷移することができます。

**業務上の目的・背景**：カスタムフィールドの設定状況を詳細に確認する必要がある場合に使用します。フィールドの技術的な情報（内部名称やテーブル名）を確認することで、カスタム開発やトラブルシューティングに役立てることができます。

**画面へのアクセス方法**：カスタムフィールド管理画面（No.43）からフィールドをクリック、または `/admin/fields/:id` に直接アクセスします。

**主要な操作・処理内容**：
1. フィールドの詳細情報表示（ラベル、名前、テーブル、タイプ）
2. 作成日時・更新日時の確認
3. 編集画面へのリンク

**画面遷移**：カスタムフィールド管理画面（No.43）から遷移します。編集リンクをクリックするとインライン編集フォームが表示されます。

**権限による表示制御**：管理者（admin権限を持つユーザー）のみがアクセス可能です。一般ユーザーがアクセスしようとした場合は、管理画面トップへリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 73 | カスタムフィールド管理 | 主機能 | カスタムフィールド詳細確認 |

## 画面種別

詳細（管理画面）

## URL/ルーティング

- **URL**: `/admin/fields/:id`
- **HTTPメソッド**: GET
- **ルーティング定義**: `config/routes.rb` 内の `namespace :admin do resources :fields end`
- **コントローラ**: `Admin::FieldsController#show`

## 入出力項目

本画面は詳細表示のため、直接の入力項目はありません。

## 表示項目

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| フィールドラベル（タイトル） | 見出し | @field.field_label | 画面タイトルとして表示 |
| Label | テキスト | @field.field_label | フィールドの表示ラベル |
| Name | テキスト | @field.field_name | フィールドの内部名称 |
| Table | テキスト | @field.table_name.pluralize | 所属テーブル名（複数形） |
| Type | テキスト | @field.field_type | フィールドタイプ |
| Created at | 日時 | @field.created_at.to_s | 作成日時 |
| Updated at | 日時 | @field.updated_at.to_s | 更新日時 |
| 編集リンク | link | edit_admin_field_path(@field) | インライン編集フォームを開く |

## イベント仕様

### 1-編集リンク押下（Edit）

- **処理フロー**:
  1. `link_to_inline` によりAjaxリクエストで `GET /admin/fields/:id/edit` を呼び出し
  2. `Admin::FieldsController#edit` が実行される
  3. 編集フォームが `#edit_field` 領域にインラインで表示される

### 2-フック拡張ポイント

- **処理フロー**:
  1. `hook(:show_field_bottom, self)` が呼び出される
  2. プラグインにより追加コンテンツを挿入可能

## データベース更新仕様

### 操作別データベース影響一覧

本画面は詳細表示のみのため、直接のデータベース更新は発生しません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | fields | SELECT | フィールド情報を取得 |

### テーブル別更新項目詳細

#### fields

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE id = :id | 詳細表示用データ取得 |

## メッセージ仕様

本画面には特別なメッセージ表示はありません。

## 例外処理

| 例外条件 | 処理内容 | 表示・動作 |
|----------|----------|-----------|
| フィールドが見つからない | RecordNotFound例外 | 404エラーページを表示 |
| 権限不足（非管理者） | before_actionでリダイレクト | 管理画面トップへリダイレクト |

## 備考

- 本画面はシンプルな詳細表示画面で、主に技術者やシステム管理者がフィールドの設定内容を確認するために使用されます。
- `hook(:show_field_bottom, self)` によりプラグインで拡張可能な設計になっています。
- `field_label`、`field_name`、`table_name`、`field_type` はFieldモデルのメソッドまたは属性として定義されています。
- テーブル名は `pluralize` で複数形に変換して表示されます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィールドモデルの属性を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | field.rb | `app/models/fields/field.rb` | Fieldモデル、属性、メソッド |
| 1-2 | schema.rb | `db/schema.rb` | fieldsテーブル（246-271行目）の構造 |

**読解のコツ**: `field_label`、`field_name` などの属性アクセサがどのように定義されているかを確認してください。

#### Step 2: エントリーポイントを理解する

コントローラのshowアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fields_controller.rb | `app/controllers/admin/fields_controller.rb` | showアクションの実装 |

**主要処理フロー**:
1. **20-23行目**: `show` アクション - `load_resource` により `@field` が自動ロードされる
2. **22行目**: `respond_with(@field)` でビューをレンダリング

#### Step 3: ビューテンプレートを理解する

詳細画面の構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/admin/fields/show.html.haml` | 詳細画面テンプレート |

**主要処理フロー**:
- **5行目**: `link_to_inline` で編集リンクを生成
- **6行目**: フィールドラベルをタイトルとして表示
- **10-40行目**: `%tt` タグ内でフィールド属性を表示
- **41行目**: `hook(:show_field_bottom, self)` でプラグイン拡張ポイント

#### Step 4: ルーティングを理解する

URLとコントローラの対応を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | routes.rb | `config/routes.rb` | admin名前空間内のfieldsリソース定義（190-198行目） |

### プログラム呼び出し階層図

```
ブラウザ（/admin/fields/:id アクセス）
    │
    └─ GET /admin/fields/:id
           │
           └─ Admin::FieldsController#show
                  │
                  ├─ load_resource (CanCanCan)
                  │      └─ Field.find(params[:id])
                  │
                  └─ respond_with(@field)
                         │
                         └─ show.html.haml レンダリング
                                │
                                ├─ @field.field_label
                                ├─ @field.field_name
                                ├─ @field.table_name
                                ├─ @field.field_type
                                ├─ @field.created_at
                                ├─ @field.updated_at
                                │
                                └─ hook(:show_field_bottom, self)
                                       └─ プラグイン拡張ポイント

編集リンククリック：
    │
    └─ GET /admin/fields/:id/edit (Ajax)
           │
           └─ Admin::FieldsController#edit
                  │
                  └─ edit.js.erb / _form.html.haml レンダリング
                         │
                         └─ #edit_field 領域に展開
```

### データフロー図

```
[入力]               [処理]                           [出力]

URL アクセス
(/admin/fields/:id) ───▶ FieldsController#show ───▶ 詳細画面表示
                              │
                              └─ Field.find(:id)
                                     │
                                     └─ fields テーブル (SELECT)
                                            │
                                            ├─ label → field_label
                                            ├─ name → field_name
                                            ├─ (計算) → table_name
                                            ├─ as → field_type
                                            ├─ created_at
                                            └─ updated_at

編集リンク ───▶ FieldsController#edit (Ajax)
クリック              │
                     └─ 編集フォーム展開
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| field.rb | `app/models/fields/field.rb` | モデル | フィールドエンティティ、属性定義 |
| fields_controller.rb | `app/controllers/admin/fields_controller.rb` | コントローラ | showアクション処理 |
| show.html.haml | `app/views/admin/fields/show.html.haml` | ビュー | 詳細画面テンプレート |
| routes.rb | `config/routes.rb` | 設定 | URLルーティング定義 |
| schema.rb | `db/schema.rb` | 設定 | データベーススキーマ |
