# 画面設計書 45-調査ツール管理画面

## 概要

本ドキュメントは、Fat Free CRMの管理画面における調査ツール（リサーチツール）管理画面の設計書です。管理者がCRMで使用する外部リサーチツール（検索エンジン、ビジネス情報サイトなど）へのリンクを管理するための画面を定義します。

### 本画面の処理概要

本画面は、CRMの各エンティティ画面から外部の調査・リサーチサービスにアクセスするためのリンク（リサーチツール）を一元管理する画面です。リサーチツールはURLテンプレートを使用して動的にリンクを生成し、ユーザーが取引先や連絡先の追加情報を外部サービスで検索することを容易にします。

**業務上の目的・背景**：営業担当者が見込み客や取引先について追加情報を調査する際、Googleや LinkedIn、会社情報サイトなどを利用することがあります。リサーチツール機能により、これらの外部サービスへのアクセスをCRM画面から直接行えるようにし、業務効率を向上させます。

**画面へのアクセス方法**：管理画面のナビゲーションから「Research Tools」タブを選択、または `/admin/research_tools` に直接アクセスします。

**主要な操作・処理内容**：
1. 登録済みリサーチツールの一覧表示
2. 新規リサーチツールの作成（名前、URLテンプレート）
3. 既存リサーチツールの編集
4. リサーチツールの削除
5. リサーチツールの有効化/無効化

**画面遷移**：管理画面トップ（No.34）から遷移します。編集操作は専用の編集画面（No.46）で行います。新規作成はインラインフォームで行われます。

**権限による表示制御**：管理者（admin権限を持つユーザー）のみがアクセス可能です。一般ユーザーがアクセスしようとした場合は、管理画面トップへリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 調査ツール管理 | 主機能 | リサーチツールの一覧表示、作成、編集、削除 |

## 画面種別

一覧（管理画面）

## URL/ルーティング

- **URL**: `/admin/research_tools`
- **HTTPメソッド**: GET（一覧表示）
- **ルーティング定義**: `config/routes.rb` 内の `namespace :admin do resources :research_tools, except: [:show] end`
- **コントローラ**: `Admin::ResearchToolsController#index`

## 入出力項目

新規作成時のフォーム項目：

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|----------|------|--------|----------|------|
| 名前 | research_tool[name] | string | Yes | 255 | テキスト | ツールの表示名（例：Google Scholar） |
| URLテンプレート | research_tool[url_template] | string | Yes | 255 | URL | {query}プレースホルダーを含む |
| 有効 | research_tool[enabled] | boolean | No | - | チェックボックス | デフォルトfalse |

## 表示項目

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| リサーチツール一覧 | リスト形式 | @research_tools = ResearchTool.all | 全ツールを表示 |
| ツール名 | テキスト | research_tool.name | ツールの表示名 |
| URLテンプレート | テキスト | research_tool.url_template | プレースホルダー付きURL |
| 有効状態 | アイコン/テキスト | research_tool.enabled | 有効/無効の表示 |
| 編集リンク | link | edit_admin_research_tool_path | 編集画面へ遷移 |
| 削除リンク | link | admin_research_tool_path | 削除実行 |
| 新規作成リンク | link | new_admin_research_tool_path | インラインフォームを開く |

## イベント仕様

### 1-新規作成リンク押下（Create Research Tool）

- **処理フロー**:
  1. `link_to_inline` によりAjaxリクエストで `GET /admin/research_tools/new` を呼び出し
  2. `Admin::ResearchToolsController#new` が実行される
  3. 新規作成フォームが `#create_research_tool` 領域にインラインで表示される

### 2-フォーム送信（作成）

- **処理フロー**:
  1. フォーム送信で `POST /admin/research_tools` を呼び出し
  2. `Admin::ResearchToolsController#create` が実行される
  3. `@research_tool.update(research_tool_params)` でリサーチツールを作成
  4. 成功時: 一覧に新しいツールが追加される
  5. 失敗時: エラーメッセージがフォーム上に表示される

### 3-編集リンク押下

- **処理フロー**:
  1. リンククリックで `GET /admin/research_tools/:id/edit` へ遷移
  2. 編集画面（No.46）が表示される

### 4-削除リンク押下（Delete）

- **処理フロー**:
  1. Ajaxリクエストで `DELETE /admin/research_tools/:id` を呼び出し
  2. `Admin::ResearchToolsController#destroy` が実行される
  3. リサーチツールが削除され、一覧から除去される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | research_tools | INSERT | 新しいリサーチツールレコードを作成 |
| 編集 | research_tools | UPDATE | リサーチツール情報を更新 |
| 削除 | research_tools | DELETE | リサーチツールレコードを削除 |

### テーブル別更新項目詳細

#### research_tools

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | url_template | フォーム入力値 | 必須、{query}プレースホルダーを含む |
| INSERT | enabled | フォーム入力値またはfalse | デフォルトfalse |
| INSERT | created_at | 現在時刻 | 自動設定 |
| INSERT | updated_at | 現在時刻 | 自動設定 |
| UPDATE | name, url_template, enabled | フォーム入力値 | - |
| UPDATE | updated_at | 現在時刻 | 自動設定 |
| DELETE | - | WHERE id = :id | - |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 | 表示位置 |
|---------------|------|---------------|----------|
| 空表示 | リサーチツールが存在しない | "shared/empty"パーシャル | 一覧領域 |
| エラー | 名前が空 | バリデーションエラー | フォーム上 |
| エラー | URLテンプレートが空 | バリデーションエラー | フォーム上 |

## 例外処理

| 例外条件 | 処理内容 | 表示・動作 |
|----------|----------|-----------|
| リサーチツールが見つからない | RecordNotFound例外 | 404エラーページを表示 |
| 権限不足（非管理者） | before_actionでリダイレクト | 管理画面トップへリダイレクト |
| バリデーションエラー | エラーメッセージ表示 | フォーム上部にエラー内容を表示 |

## 備考

- リサーチツールのURLテンプレートには `{query}` プレースホルダーを含めることができ、実際の使用時に検索対象の名前等で置換されます。
- 例：`https://www.google.com/search?q={query}` → 取引先名で検索
- `enabled` フラグが `false` のツールはCRM画面には表示されません（管理画面では表示されます）。
- リサーチツール機能はCRMの詳細画面（取引先、連絡先など）からアクセスできるリンクとして提供されます。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リサーチツールモデルの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | research_tool.rb | `app/models/research_tool.rb` | ResearchToolモデル（シンプルなActiveRecord） |
| 1-2 | schema.rb | `db/schema.rb` | research_toolsテーブル（369-375行目）の構造 |

**読解のコツ**: ResearchToolモデルは非常にシンプルで、特別なロジックは含まれていません。テーブル構造（name, url_template, enabled）を確認してください。

#### Step 2: エントリーポイントを理解する

コントローラのアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | research_tools_controller.rb | `app/controllers/admin/research_tools_controller.rb` | 各CRUDアクションの実装 |

**主要処理フロー**:
1. **8-11行目**: `index` アクション - `ResearchTool.all`で全ツールを取得
2. **13-15行目**: `new` アクション - 新規オブジェクト生成
3. **17-19行目**: `edit` アクション - 編集対象をロード
4. **21-24行目**: `create` アクション - ツールを作成、一覧へリダイレクト
5. **26-29行目**: `update` アクション - ツールを更新
6. **31-34行目**: `destroy` アクション - ツールを削除

#### Step 3: ビューテンプレートを理解する

一覧画面の構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/research_tools/index.html.haml` | 一覧画面メインテンプレート |
| 3-2 | _form.html.haml | `app/views/admin/research_tools/_form.html.haml` | 作成/編集フォーム |

**主要処理フロー**:
- **2行目（index）**: `link_to_inline` で新規作成リンクを生成
- **9-13行目（index）**: リサーチツール一覧をパーシャルでレンダリング
- **1行目（_form）**: `form_for` でリソースフルフォームを生成
- **7行目（_form）**: 名前入力フィールド（required）
- **11行目（_form）**: URLテンプレート入力フィールド（required）

#### Step 4: ルーティングを理解する

URLとコントローラの対応を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | routes.rb | `config/routes.rb` | admin名前空間内のresearch_toolsリソース定義（188行目） |

### プログラム呼び出し階層図

```
ブラウザ（/admin/research_tools アクセス）
    │
    └─ GET /admin/research_tools
           │
           └─ Admin::ResearchToolsController#index
                  │
                  ├─ ResearchTool.all
                  │      └─ research_tools テーブル (SELECT)
                  │
                  └─ index.html.haml レンダリング
                         │
                         ├─ link_to_inline (新規作成)
                         │
                         └─ @research_tools.each
                                └─ _research_tool.html.haml

新規作成フロー：
    │
    ├─ GET /admin/research_tools/new (Ajax)
    │      │
    │      └─ ResearchToolsController#new
    │             └─ _form.html.haml レンダリング
    │
    └─ POST /admin/research_tools
           │
           └─ ResearchToolsController#create
                  │
                  ├─ @research_tool.update(research_tool_params)
                  │
                  └─ redirect_to admin_research_tools_path
```

### データフロー図

```
[入力]               [処理]                           [出力]

URL アクセス
(/admin/research_tools) ───▶ ResearchToolsController#index ───▶ 一覧画面表示
                                   │
                                   └─ ResearchTool.all
                                          │
                                          └─ research_tools テーブル (SELECT)

新規作成 ───▶ ResearchToolsController#create
フォーム入力       │
 ├─ name          └─ research_tool_params
 ├─ url_template         │
 └─ enabled              └─▶ research_tools テーブル (INSERT)
                                   │
                                   └─▶ 一覧画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| research_tool.rb | `app/models/research_tool.rb` | モデル | リサーチツールエンティティ |
| research_tools_controller.rb | `app/controllers/admin/research_tools_controller.rb` | コントローラ | CRUDアクション処理 |
| index.html.haml | `app/views/admin/research_tools/index.html.haml` | ビュー | 一覧画面メインテンプレート |
| _research_tool.html.haml | `app/views/admin/research_tools/_research_tool.html.haml` | ビュー | ツール行パーシャル |
| _form.html.haml | `app/views/admin/research_tools/_form.html.haml` | ビュー | 作成/編集フォーム |
| routes.rb | `config/routes.rb` | 設定 | URLルーティング定義 |
| schema.rb | `db/schema.rb` | 設定 | データベーススキーマ |
