# 画面設計書 46-調査ツール編集画面

## 概要

本ドキュメントは、Fat Free CRMの管理画面における調査ツール（リサーチツール）編集画面の設計書です。管理者が既存のリサーチツールの設定を変更するための画面を定義します。

### 本画面の処理概要

本画面は、登録済みのリサーチツール（外部調査サービスへのリンク）の情報を編集するための画面です。ツール名、URLテンプレート、有効/無効の状態を変更することができます。

**業務上の目的・背景**：リサーチツールの設定を変更する必要がある場合（URLの変更、ツール名の修正、一時的な無効化など）に使用します。URLテンプレートのプレースホルダー構文を修正したり、サービスURLの変更に対応したりする際に必要となります。

**画面へのアクセス方法**：調査ツール管理画面（No.45）から編集したいツールのリンクをクリック、または `/admin/research_tools/:id/edit` に直接アクセスします。

**主要な操作・処理内容**：
1. 既存のリサーチツール情報の表示
2. ツール名の編集
3. URLテンプレートの編集
4. 有効/無効状態の変更
5. 保存による更新実行

**画面遷移**：調査ツール管理画面（No.45）から遷移します。保存成功後は一覧画面（No.45）に戻ります。

**権限による表示制御**：管理者（admin権限を持つユーザー）のみがアクセス可能です。一般ユーザーがアクセスしようとした場合は、管理画面トップへリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 調査ツール編集 | 主機能 | リサーチツール情報の更新 |

## 画面種別

編集

## URL/ルーティング

- **URL**: `/admin/research_tools/:id/edit`
- **HTTPメソッド**: GET（フォーム表示）、PUT/PATCH（更新実行）
- **ルーティング定義**: `config/routes.rb` 内の `namespace :admin do resources :research_tools, except: [:show] end`
- **コントローラ**: `Admin::ResearchToolsController#edit`, `Admin::ResearchToolsController#update`

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|----------|------|--------|----------|------|
| 名前 | research_tool[name] | string | Yes | 255 | テキスト | ツールの表示名 |
| URLテンプレート | research_tool[url_template] | string | Yes | 255 | URL | {query}プレースホルダーを含む |
| 有効 | research_tool[enabled] | boolean | No | - | チェックボックス | 有効/無効の切り替え |

## 表示項目

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| 名前入力欄 | text_field | @research_tool.name | 現在の名前を初期表示 |
| URLテンプレート入力欄 | text_field | @research_tool.url_template | 現在のURLを初期表示 |
| 有効チェックボックス | check_box | @research_tool.enabled | 現在の状態を初期表示 |
| 送信ボタン | submit | - | 更新実行 |

## イベント仕様

### 1-フォーム表示

- **処理フロー**:
  1. `GET /admin/research_tools/:id/edit` を呼び出し
  2. `Admin::ResearchToolsController#edit` が実行される
  3. `load_resource` により `@research_tool` が自動ロードされる
  4. 編集フォームがレンダリングされる

### 2-フォーム送信（更新）

- **処理フロー**:
  1. フォーム送信で `PUT/PATCH /admin/research_tools/:id` を呼び出し
  2. `Admin::ResearchToolsController#update` が実行される
  3. `@research_tool.update(research_tool_params)` でリサーチツールを更新
  4. 成功時: 一覧画面（`/admin/research_tools`）へリダイレクト
  5. 失敗時: エラーメッセージが表示され、フォームが再表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | research_tools | UPDATE | リサーチツール情報を更新 |

### テーブル別更新項目詳細

#### research_tools

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | url_template | フォーム入力値 | 必須 |
| UPDATE | enabled | フォーム入力値 | true/false |
| UPDATE | updated_at | 現在時刻 | ActiveRecordにより自動設定 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 | 表示位置 |
|---------------|------|---------------|----------|
| エラー | 名前が空 | バリデーションエラー | フォーム上 |
| エラー | URLテンプレートが空 | バリデーションエラー | フォーム上 |
| 成功 | 更新成功時 | （リダイレクトのため明示的メッセージなし） | - |

## 例外処理

| 例外条件 | 処理内容 | 表示・動作 |
|----------|----------|-----------|
| リサーチツールが見つからない | RecordNotFound例外 | 404エラーページを表示 |
| 権限不足（非管理者） | before_actionでリダイレクト | 管理画面トップへリダイレクト |
| バリデーションエラー | エラーメッセージ表示 | フォーム上部にエラー内容を表示、入力値は保持 |

## 備考

- 本画面は `_form.html.haml` パーシャルをレンダリングするだけのシンプルな構成です。
- 新規作成フォームと編集フォームで同じパーシャルを共有しています。
- 更新成功後は `respond_with` により一覧画面へリダイレクトされます（`location` オプション指定）。
- URLテンプレートの `{query}` プレースホルダーは入力チェックされませんが、使用時に正しく置換されることが前提です。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リサーチツールモデルの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | research_tool.rb | `app/models/research_tool.rb` | ResearchToolモデル |
| 1-2 | schema.rb | `db/schema.rb` | research_toolsテーブル（369-375行目）の構造 |

#### Step 2: エントリーポイントを理解する

コントローラのedit/updateアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | research_tools_controller.rb | `app/controllers/admin/research_tools_controller.rb` | edit/updateアクションの実装 |

**主要処理フロー**:
1. **17-19行目**: `edit` アクション - `load_resource` により `@research_tool` が自動ロード
2. **26-29行目**: `update` アクション - `research_tool_params` を使用してツールを更新
3. **28行目**: `location` オプションで一覧画面へリダイレクト

#### Step 3: ビューテンプレートを理解する

編集画面の構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/admin/research_tools/edit.html.haml` | 編集画面テンプレート（パーシャルをレンダリング） |
| 3-2 | _form.html.haml | `app/views/admin/research_tools/_form.html.haml` | フォームパーシャル |

**主要処理フロー**:
- **1行目（edit）**: `render 'form'` でフォームパーシャルをレンダリング
- **1行目（_form）**: `form_for([:admin, @research_tool])` でリソースフルフォームを生成
- **7行目（_form）**: 名前入力フィールド
- **11行目（_form）**: URLテンプレート入力フィールド

#### Step 4: ルーティングを理解する

URLとコントローラの対応を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | routes.rb | `config/routes.rb` | admin名前空間内のresearch_toolsリソース定義（188行目） |

### プログラム呼び出し階層図

```
ブラウザ（Edit リンク クリック）
    │
    ├─ GET /admin/research_tools/:id/edit
    │      │
    │      └─ Admin::ResearchToolsController#edit
    │             │
    │             ├─ load_resource (CanCanCan)
    │             │      └─ ResearchTool.find(params[:id])
    │             │
    │             └─ respond_with(@research_tool)
    │                    └─ edit.html.haml レンダリング
    │                           └─ _form.html.haml レンダリング
    │
    └─ PUT /admin/research_tools/:id
           │
           └─ Admin::ResearchToolsController#update
                  │
                  ├─ @research_tool.update(research_tool_params)
                  │      │
                  │      └─ research_tools テーブル (UPDATE)
                  │
                  └─ respond_with(@research_tool, location: ...)
                         └─ admin_research_tools_path へリダイレクト
```

### データフロー図

```
[入力]               [処理]                           [出力]

URL アクセス
(/admin/research_tools/:id/edit) ───▶ ResearchToolsController#edit ───▶ 編集フォーム表示
                                             │
                                             └─ ResearchTool.find(:id)
                                                    │
                                                    └─ research_tools テーブル (SELECT)

フォーム入力
 ├─ name
 ├─ url_template ───▶ ResearchToolsController#update
 └─ enabled                │
                           ├─ research_tool_params
                           │      └─ Strong Parameters
                           │
                           └─ @research_tool.update
                                  │
                                  └─▶ research_tools テーブル (UPDATE)
                                         │
                                         └─▶ 一覧画面へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| research_tool.rb | `app/models/research_tool.rb` | モデル | リサーチツールエンティティ |
| research_tools_controller.rb | `app/controllers/admin/research_tools_controller.rb` | コントローラ | edit/updateアクション処理 |
| edit.html.haml | `app/views/admin/research_tools/edit.html.haml` | ビュー | 編集画面テンプレート |
| _form.html.haml | `app/views/admin/research_tools/_form.html.haml` | ビュー | フォームパーシャル |
| routes.rb | `config/routes.rb` | 設定 | URLルーティング定義 |
| schema.rb | `db/schema.rb` | 設定 | データベーススキーマ |
