# 画面設計書 47-設定画面

## 概要

本ドキュメントは、Fat Free CRMの管理画面におけるシステム設定画面の設計書です。管理者がCRMシステム全体の動作に関わる各種設定を管理するための画面を定義します。

### 本画面の処理概要

本画面は、CRMシステム全体の設定を一元管理する管理画面です。アプリケーション基本設定、ユーザー登録設定、メール設定、バリデーション設定、カスタマイズ設定、AIプロンプト設定など、多岐にわたる設定項目をセクション別に整理して提供します。

**業務上の目的・背景**：CRMシステムの動作を組織のニーズに合わせて調整するために必要です。ホスト名やベースURL、デフォルトのアクセス権限、SMTP設定、各種ステータス・カテゴリの選択肢など、システム全体に影響する設定を管理者が一括で管理できます。

**画面へのアクセス方法**：管理画面のナビゲーションから「Settings」タブを選択、または `/admin/settings` に直接アクセスします。

**主要な操作・処理内容**：
1. アプリケーション設定（ホスト、ベースURL、ロケール、デフォルトアクセス権限）
2. ユーザー登録設定（登録許可/不許可/承認必要）
3. メール設定（SMTP、ドロップボックス、コメント返信）
4. バリデーション設定（必須項目、一意性制約）
5. カスタマイズ設定（ステータス、カテゴリ、ステージの選択肢）
6. AIプロンプト設定（ビジネス情報）
7. 設定の保存

**画面遷移**：管理画面トップ（No.34）から遷移します。設定保存後は同一画面にリダイレクトされ、成功メッセージが表示されます。

**権限による表示制御**：管理者（admin権限を持つユーザー）のみがアクセス可能です。一般ユーザーがアクセスしようとした場合は、管理画面トップへリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 78 | システム設定 | 主機能 | システム全体の設定表示 |
| 79 | システム設定更新 | 補助機能 | 設定の更新（ホスト、ロケール、アクセス設定等） |

## 画面種別

設定（フォーム）

## URL/ルーティング

- **URL**: `/admin/settings`
- **HTTPメソッド**: GET（表示）、PUT（更新）
- **ルーティング定義**: `config/routes.rb` 内の `namespace :admin do resources :settings, only: [:index] do collection do put :update end end end`
- **コントローラ**: `Admin::SettingsController#index`, `Admin::SettingsController#update`

## 入出力項目

### アプリケーション設定セクション

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| ホスト | settings[host] | string | No | テキスト | サーバーホスト名 |
| ベースURL | settings[base_url] | string | No | テキスト | アプリケーションの基本URL |
| デフォルト言語 | settings[locale] | string | No | 選択 | 利用可能なロケールから選択 |
| デフォルトアクセス権限 | settings[default_access] | string | No | 選択 | Public/Private/Shared |
| ユーザーごとのロケール許可 | settings[per_user_locale] | boolean | No | チェックボックス | - |
| 住所分割入力 | settings[compound_address] | boolean | No | チェックボックス | - |
| タスクカレンダーに時刻表示 | settings[task_calendar_with_time] | boolean | No | チェックボックス | - |
| ダッシュボードにコメント表示 | settings[comments_visible_on_dashboard] | boolean | No | チェックボックス | - |
| 国際電話番号フォーマット強制 | settings[enforce_international_phone_format] | boolean | No | チェックボックス | - |

### ユーザー登録設定セクション

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| ユーザー登録 | settings[user_signup] | string | No | 選択 | allowed/not_allowed/needs_approval |

### メール設定セクション（SMTP）

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| SMTPアドレス | settings[smtp][address] | string | No | テキスト | - |
| SMTPポート | settings[smtp][port] | string | No | テキスト | - |
| SMTPユーザー名 | settings[smtp][user_name] | string | No | テキスト | - |
| SMTPパスワード | settings[smtp][password] | string | No | パスワード | - |
| 送信元アドレス | settings[smtp][from] | string | No | テキスト | - |
| 認証方式 | settings[smtp][authentication] | string | No | テキスト | - |
| STARTTLS自動有効化 | settings[smtp][enable_starttls_auto] | boolean | No | チェックボックス | - |

### バリデーション設定セクション

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| 名（ファーストネーム）必須 | settings[require_first_names] | boolean | No | チェックボックス | - |
| 姓（ラストネーム）必須 | settings[require_last_names] | boolean | No | チェックボックス | - |
| 取引先名の一意性必須 | settings[require_unique_account_names] | boolean | No | チェックボックス | - |

### カスタマイズ設定セクション

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| 取引先カテゴリ | settings[account_category] | text | No | テキストエリア | 改行区切り |
| キャンペーンステータス | settings[campaign_status] | text | No | テキストエリア | 改行区切り |
| リードステータス | settings[lead_status] | text | No | テキストエリア | 改行区切り |
| リードソース | settings[lead_source] | text | No | テキストエリア | 改行区切り |
| 商談ステージ | settings[opportunity_stage] | text | No | テキストエリア | 改行区切り |
| タスクカテゴリ | settings[task_category] | text | No | テキストエリア | 改行区切り |
| タスクバケット | settings[task_bucket] | text | No | テキストエリア | 改行区切り |
| タスク完了状態 | settings[task_completed] | text | No | テキストエリア | 改行区切り |
| 優先国リスト | settings[priority_countries] | text | No | テキストエリア | 改行区切り |
| デフォルト商談ステージ | settings[opportunity_default_stage] | string | No | 選択 | - |
| バックグラウンド情報表示対象 | settings[background_info] | array | No | 複数選択 | - |

## 表示項目

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| 画面タイトル | 見出し | t(:admin_tab_settings) | - |
| アプリケーション設定 | フィールドセット | _application パーシャル | - |
| ユーザー登録設定 | フィールドセット | _user_signup パーシャル | - |
| メール設定 | フィールドセット | _email パーシャル | タブUIで切り替え |
| バリデーション設定 | フィールドセット | _validations パーシャル | - |
| カスタマイズ設定 | フィールドセット | _customization パーシャル | - |
| AIプロンプト設定 | フィールドセット | _ai_prompts パーシャル | - |
| 更新ボタン | submit | f.submit t(:update) | "btn btn-primary" |

## イベント仕様

### 1-設定更新（Updateボタン押下）

- **処理フロー**:
  1. フォーム送信で `PUT /admin/settings` を呼び出し
  2. `Admin::SettingsController#update` が実行される
  3. `settings_params` で許可されたパラメータを取得
  4. 各設定値を適切な型に変換（ブール値、配列、シンボル）
  5. `Setting[key] = value` で各設定を保存
  6. 成功時: 同一画面にリダイレクトし、フラッシュメッセージを表示

### 2-メール設定タブ切り替え

- **処理フロー**:
  1. SMTP/Dropbox/Comment Replies タブをクリック
  2. JavaScriptでタブコンテンツを切り替え
  3. 対応するフォームセクションが表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 更新ボタン押下 | settings | INSERT/UPDATE | 各設定値を保存 |

### テーブル別更新項目詳細

#### settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | 設定キー（host, locale等） | 存在チェックあり |
| INSERT/UPDATE | value | 設定値（serialize） | 型変換処理あり |
| INSERT/UPDATE | updated_at | 現在時刻 | 自動設定 |

**型変換処理**:
- ブール値: `'1'` を `true` に変換
- 配列: 改行区切りテキストを配列に変換
- シンボル: 文字列をシンボルに変換

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 | 表示位置 |
|---------------|------|---------------|----------|
| 成功 | 更新成功時 | t('fat_free_crm.settings_updated') | フラッシュ領域 |

## 例外処理

| 例外条件 | 処理内容 | 表示・動作 |
|----------|----------|-----------|
| 権限不足（非管理者） | before_actionでリダイレクト | 管理画面トップへリダイレクト |

## 備考

- 設定値はSettingモデルを通じてデータベースに保存されます。
- 設定の優先順位は：データベース > config/settings.yml > config/settings.default.yml です。
- 配列型の設定（ステータス、カテゴリ等）はテキストエリアで改行区切りで入力し、サーバー側で配列に変換されます。
- メール設定はタブUIで3つのセクション（SMTP、Dropbox、Comment Replies）に分かれています。
- ネストされた設定（smtp, email_dropbox, email_comment_replies）は `fields_for` で対応しています。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定の保存メカニズムを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | setting.rb | `app/models/setting.rb` | Settingモデル、キャッシュ機構、YAML読み込み |
| 1-2 | schema.rb | `db/schema.rb` | settingsテーブル（386-392行目）の構造 |

**読解のコツ**: `Setting[name]` と `Setting[name] = value` のアクセサメソッド（56-79行目）を理解することで、設定の読み書きメカニズムが分かります。

#### Step 2: エントリーポイントを理解する

コントローラのアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | settings_controller.rb | `app/controllers/admin/settings_controller.rb` | index/updateアクションの実装、型変換処理 |

**主要処理フロー**:
1. **14-15行目**: `index` アクション - 空（ビューで Setting.xxx を直接参照）
2. **19-48行目**: `update` アクション - パラメータ取得、型変換、各設定の保存
3. **26-28行目**: ブール値への変換処理
4. **35-37行目**: 配列への変換処理（改行区切りテキスト）
5. **43-45行目**: 各設定をSettingモデルに保存

#### Step 3: ビューテンプレートを理解する

設定画面の構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/admin/settings/index.html.haml` | メインテンプレート、各パーシャルの呼び出し |
| 3-2 | _application.html.haml | `app/views/admin/settings/_application.html.haml` | アプリケーション設定セクション |
| 3-3 | _email.html.haml | `app/views/admin/settings/_email.html.haml` | メール設定セクション（タブUI） |
| 3-4 | _validations.html.haml | `app/views/admin/settings/_validations.html.haml` | バリデーション設定セクション |
| 3-5 | _customization.html.haml | `app/views/admin/settings/_customization.html.haml` | カスタマイズ設定セクション |

**主要処理フロー**:
- **3行目（index）**: `form_for "settings"` でフォーム生成
- **4-9行目（index）**: 各パーシャルをレンダリング
- **9行目（_application）**: `Setting.host` で現在値を取得

#### Step 4: ルーティングを理解する

URLとコントローラの対応を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | routes.rb | `config/routes.rb` | admin名前空間内のsettingsリソース定義（209-213行目） |

### プログラム呼び出し階層図

```
ブラウザ（/admin/settings アクセス）
    │
    └─ GET /admin/settings
           │
           └─ Admin::SettingsController#index
                  │
                  └─ index.html.haml レンダリング
                         │
                         ├─ _application.html.haml
                         │      └─ Setting.host, Setting.locale, ...
                         │
                         ├─ _user_signup.html.haml
                         │      └─ Setting.user_signup
                         │
                         ├─ _email.html.haml
                         │      └─ Setting.smtp, Setting.email_dropbox, ...
                         │
                         ├─ _validations.html.haml
                         │      └─ Setting.require_first_names, ...
                         │
                         └─ _customization.html.haml
                                └─ Setting.account_category, ...

設定更新フロー：
    │
    └─ PUT /admin/settings
           │
           └─ Admin::SettingsController#update
                  │
                  ├─ settings_params (Strong Parameters)
                  │
                  ├─ 型変換処理
                  │      ├─ ブール値変換
                  │      ├─ 配列変換（改行区切り）
                  │      └─ シンボル変換
                  │
                  └─ settings.each { Setting[key] = value }
                         │
                         └─ settings テーブル (INSERT/UPDATE)
                                │
                                └─ redirect_to admin_settings_path
```

### データフロー図

```
[入力]               [処理]                           [出力]

URL アクセス
(/admin/settings) ───▶ SettingsController#index ───▶ 設定画面表示
                             │
                             └─ Setting[key] で各設定を取得
                                    │
                                    ├─ @@cache（メモリキャッシュ）
                                    ├─ settings テーブル（DB）
                                    └─ @@yaml_settings（YAML）

フォーム入力 ───▶ SettingsController#update
                       │
                       ├─ settings_params
                       │      └─ Strong Parameters
                       │
                       ├─ 型変換
                       │      ├─ '1' → true
                       │      ├─ "line1\nline2" → ["line1", "line2"]
                       │      └─ "allowed" → :allowed
                       │
                       └─ Setting[key] = value
                              │
                              └─▶ settings テーブル (INSERT/UPDATE)
                                     │
                                     └─▶ 同一画面へリダイレクト
                                            └─ フラッシュメッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| setting.rb | `app/models/setting.rb` | モデル | 設定エンティティ、キャッシュ、アクセサ |
| settings_controller.rb | `app/controllers/admin/settings_controller.rb` | コントローラ | index/updateアクション、型変換処理 |
| index.html.haml | `app/views/admin/settings/index.html.haml` | ビュー | 設定画面メインテンプレート |
| _application.html.haml | `app/views/admin/settings/_application.html.haml` | ビュー | アプリケーション設定パーシャル |
| _user_signup.html.haml | `app/views/admin/settings/_user_signup.html.haml` | ビュー | ユーザー登録設定パーシャル |
| _email.html.haml | `app/views/admin/settings/_email.html.haml` | ビュー | メール設定パーシャル |
| _validations.html.haml | `app/views/admin/settings/_validations.html.haml` | ビュー | バリデーション設定パーシャル |
| _customization.html.haml | `app/views/admin/settings/_customization.html.haml` | ビュー | カスタマイズ設定パーシャル |
| _ai_prompts.html.haml | `app/views/admin/settings/_ai_prompts.html.haml` | ビュー | AIプロンプト設定パーシャル |
| routes.rb | `config/routes.rb` | 設定 | URLルーティング定義 |
| schema.rb | `db/schema.rb` | 設定 | データベーススキーマ |
| settings.default.yml | `config/settings.default.yml` | 設定 | デフォルト設定値 |
