# 画面設計書 48-プラグイン管理画面

## 概要

本ドキュメントは、Fat Free CRMの管理画面におけるプラグイン管理画面の設計書です。管理者がCRMシステムにインストールされているプラグインの一覧を確認するための画面を定義します。

### 本画面の処理概要

本画面は、Fat Free CRMにインストールされているプラグインの一覧を表示する管理画面です。現時点では機能が「未実装」（Not Implemented）の状態であり、プラグイン一覧の表示のみが予定されています。

**業務上の目的・背景**：Fat Free CRMはプラグインアーキテクチャを採用しており、機能拡張をプラグインとして追加できます。管理者がシステムにインストールされているプラグインを把握し、その状態を確認するために本画面が必要です。将来的にはプラグインの有効化/無効化、設定変更などの機能が追加される可能性があります。

**画面へのアクセス方法**：管理画面のナビゲーションから「Plugins」タブを選択、または `/admin/plugins` に直接アクセスします。

**主要な操作・処理内容**：
1. インストール済みプラグインの一覧表示（現在は未実装メッセージを表示）

**画面遷移**：管理画面トップ（No.34）から遷移します。

**権限による表示制御**：管理者（admin権限を持つユーザー）のみがアクセス可能です。一般ユーザーがアクセスしようとした場合は、管理画面トップへリダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | プラグイン一覧 | 主機能 | インストール済みプラグイン一覧表示 |

## 画面種別

一覧（管理画面）

## URL/ルーティング

- **URL**: `/admin/plugins`
- **HTTPメソッド**: GET
- **ルーティング定義**: `config/routes.rb` 内の `namespace :admin do resources :plugins, only: :index end`
- **コントローラ**: `Admin::PluginsController#index`

## 入出力項目

本画面は一覧表示のみのため、入力項目はありません。

## 表示項目

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| 画面タイトル | 見出し | "Plugins" | 固定文字列 |
| 未実装メッセージ | テキスト | t(:not_implemented) | "Not implemented" |

**将来的な表示項目（実装予定）**:

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| プラグイン一覧 | リスト | @plugins = FatFreeCRM::Plugin.list | 全プラグインを表示 |
| プラグイン名 | テキスト | plugin.name | プラグインの名前 |
| バージョン | テキスト | plugin.version | プラグインのバージョン |
| 説明 | テキスト | plugin.description | プラグインの説明 |

## イベント仕様

### 1-画面表示

- **処理フロー**:
  1. `GET /admin/plugins` を呼び出し
  2. `Admin::PluginsController#index` が実行される
  3. `FatFreeCRM::Plugin.list` でプラグイン一覧を取得
  4. ビューがレンダリングされる（現在は未実装メッセージを表示）

## データベース更新仕様

本画面は表示のみのため、データベース更新は発生しません。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | 表示のみ |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 | 表示位置 |
|---------------|------|---------------|----------|
| 情報 | 常時 | "Not implemented" | 画面中央 |

## 例外処理

| 例外条件 | 処理内容 | 表示・動作 |
|----------|----------|-----------|
| 権限不足（非管理者） | before_actionでリダイレクト | 管理画面トップへリダイレクト |

## 備考

- 本画面は現在「未実装」状態であり、プラグイン一覧の表示機能は将来のバージョンで実装される予定です。
- `FatFreeCRM::Plugin.list` メソッドは存在しますが、画面側での表示処理が未実装です。
- Fat Free CRMのプラグインシステムは `hook` メソッドを使用してビューやコントローラを拡張します。
- プラグインはRails Engineとして実装されることが一般的です。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

コントローラのアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | plugins_controller.rb | `app/controllers/admin/plugins_controller.rb` | indexアクションの実装 |

**主要処理フロー**:
1. **14-17行目**: `index` アクション - `FatFreeCRM::Plugin.list`でプラグイン一覧を取得
2. **16行目**: `respond_with(@plugins)` でビューをレンダリング

#### Step 2: ビューテンプレートを理解する

画面の構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/admin/plugins/index.html.haml` | 一覧画面テンプレート |

**主要処理フロー**:
- **1行目**: `.title Plugins` でタイトル表示
- **3行目**: `#{t :not_implemented}` で未実装メッセージを表示

#### Step 3: ルーティングを理解する

URLとコントローラの対応を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | routes.rb | `config/routes.rb` | admin名前空間内のpluginsリソース定義（214行目） |

### プログラム呼び出し階層図

```
ブラウザ（/admin/plugins アクセス）
    │
    └─ GET /admin/plugins
           │
           └─ Admin::PluginsController#index
                  │
                  ├─ FatFreeCRM::Plugin.list
                  │      └─ プラグイン一覧を取得
                  │
                  └─ respond_with(@plugins)
                         │
                         └─ index.html.haml レンダリング
                                │
                                └─ "Not implemented" 表示
```

### データフロー図

```
[入力]               [処理]                           [出力]

URL アクセス
(/admin/plugins) ───▶ PluginsController#index ───▶ プラグイン一覧画面表示
                             │
                             └─ FatFreeCRM::Plugin.list
                                    │
                                    └─ @plugins（プラグイン配列）
                                           │
                                           └─ "Not implemented" メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| plugins_controller.rb | `app/controllers/admin/plugins_controller.rb` | コントローラ | indexアクション処理 |
| index.html.haml | `app/views/admin/plugins/index.html.haml` | ビュー | 一覧画面テンプレート |
| routes.rb | `config/routes.rb` | 設定 | URLルーティング定義 |
| plugin.rb | `lib/fat_free_crm/plugin.rb` | ライブラリ | プラグインシステムの実装（推定） |
