# 画面設計書 49-メインレイアウト

## 概要

本ドキュメントは、Fat Free CRMのアプリケーション全体で使用されるメインレイアウトの設計書です。全ての一般ユーザー向け画面で共通して使用されるHTML構造、ヘッダー、ナビゲーション、サイドバー、フッターの配置を定義します。

### 本画面の処理概要

本レイアウトは、Fat Free CRMの全てのユーザー向け画面で使用される共通テンプレートです。HTML5のドキュメント構造を提供し、CSS、JavaScript、メタ情報の読み込み、ヘッダー・ナビゲーション・サイドバー・フッターなどの共通UI要素を配置します。レスポンシブデザインとLeaflet地図ライブラリにも対応しています。

**業務上の目的・背景**：一貫性のあるユーザーインターフェースを提供し、CRMの各機能へのアクセスを容易にするために必要です。全画面で共通のヘッダー、ナビゲーション、サイドバーを提供することで、ユーザーはどの画面からでも他の機能に簡単にアクセスできます。

**画面へのアクセス方法**：本レイアウトは直接アクセスするものではなく、他のビューからyield経由で利用されます。

**主要な構成要素**：
1. HTMLヘッド部（メタ情報、CSS、JavaScript読み込み）
2. ヘッダー部（ウェルカムメッセージ、ユーザーメニュー、ロゴ）
3. ナビゲーションタブ（各CRMエンティティへのリンク）
4. サイドバー（コンテキストメニュー、検索リスト、最近のアイテム）
5. メインコンテンツ領域（各画面のコンテンツ）
6. フッター部（著作権情報、Aboutリンク）

**画面遷移**：本レイアウト自体は画面遷移のコンテナとして機能します。ヘッダーとナビゲーションからCRMの各機能画面に遷移できます。

**権限による表示制御**：ログイン状態に応じてヘッダーの表示が変化します。管理者権限を持つユーザーには管理画面へのリンクが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 共通レイアウト | 主機能 | 全画面共通のUI構造を提供 |

## 画面種別

レイアウト（共通テンプレート）

## URL/ルーティング

本レイアウトは特定のURLに紐づかず、コントローラが指定するレイアウトとして使用されます。

- **レイアウトファイル**: `app/views/layouts/application.html.haml`
- **使用コントローラ**: `ApplicationController` を継承する全コントローラ

## 構成要素

### HTMLヘッド部

| 項目名 | 設定内容 | 備考 |
|--------|----------|------|
| doctype | HTML5 | `!!!5` |
| lang属性 | I18n.locale | ユーザーのロケール設定 |
| charset | UTF-8 | - |
| viewport | width=device-width, initial-scale=1.0 | レスポンシブ対応 |
| title | "Fat Free CRM" | 固定タイトル |
| stylesheet | application.css, print.css | - |
| javascript | application.js | - |
| Leaflet | CDN (v1.7.1) | 地図機能用 |
| CSRF token | csrf_meta_tag | セキュリティ用 |

### ヘッダー部

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| ウェルカムメッセージ | テキスト | current_user.name | "Welcome, [ユーザー名]!" |
| Quick Findリンク | リンク | "#" | ジャンプボックス表示用 |
| Profileリンク | リンク | profile_path | プロフィール画面へ |
| Adminリンク | リンク | admin_path | 管理画面へ（管理者のみ） |
| Logoutリンク | リンク | destroy_user_session_path | ログアウト |
| ロゴ | リンク | root_path | "Fat Free CRM" |

### ナビゲーションタブ

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| タブリスト | ul > li | tabs ヘルパー | Bootstrap navbar |
| タブアイコン | Font Awesome | tab[:icon] | 各タブのアイコン |
| タブテキスト | テキスト | t(tab[:text]) | ローカライズされたラベル |
| アクティブ状態 | CSSクラス | tab[:active] | 現在のページをハイライト |

### サイドバー

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| コンテキストサイドバー | パーシャル | sidebar_#{action} | アクション固有のサイドバー |
| リストメニュー | パーシャル | lists/lists | 保存された検索リスト |
| 最近のアイテム | パーシャル | shared/recently | 最近閲覧したアイテム |

### フッター部

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| バージョン情報 | テキスト | FatFreeCRM::VERSION::STRING | アプリケーションバージョン |
| 著作権情報 | テキスト | - | "2008-[現在年]" |
| Aboutリンク | リンク | "#" | Aboutダイアログを表示 |

## イベント仕様

### 1-Quick Findリンク押下

- **処理フロー**:
  1. JavaScriptでジャンプボックスUIを表示
  2. ユーザーがエンティティを検索・選択
  3. 選択したエンティティの詳細画面に遷移

### 2-タブクリック

- **処理フロー**:
  1. 対応するCRMエンティティの一覧画面に遷移
  2. ナビゲーションタブのアクティブ状態が更新される

### 3-Aboutリンク押下

- **処理フロー**:
  1. JavaScriptでjQuery UIダイアログを表示
  2. Aboutダイアログにバージョン情報等を表示

### 4-ログアウト押下

- **処理フロー**:
  1. `DELETE /users/sign_out` を呼び出し（Devise）
  2. セッションが破棄される
  3. ログイン画面にリダイレクト

## データベース更新仕様

本レイアウトは表示専用のため、直接のデータベース更新は発生しません。

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 | 表示位置 |
|---------------|------|---------------|----------|
| フラッシュ | コントローラで設定 | 各種メッセージ | show_flash ヘルパー |

## 例外処理

本レイアウトは共通テンプレートのため、特定の例外処理は含まれません。各コントローラで例外処理が行われます。

## 備考

- 本レイアウトはHAML形式で記述されています。
- `tabless_layout?` ヘルパーにより、ログイン画面などタブなしレイアウトとタブありレイアウトを切り替えます。
- `hook` メソッドによりプラグインからCSSやJavaScriptを追加できます。
- Leaflet地図ライブラリはCDNから読み込まれます（バージョン1.7.1）。
- ロケール設定に応じてjQuery UI Datepickerの言語ファイルが動的に読み込まれます。
- `crm.base_url` と `crm.language` のJavaScript変数がグローバルに設定されます。

---

## コードリーディングガイド

本レイアウトを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: レイアウト全体構造を理解する

メインレイアウトファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application.html.haml | `app/views/layouts/application.html.haml` | HTML構造、CSS/JS読み込み、レイアウト切り替え |

**主要処理フロー**:
- **1-6行目**: HTML5ドキュメント開始、head部
- **8-9行目**: スタイルシート読み込み（application, print）
- **14-15行目**: Leaflet CDN読み込み
- **17行目**: JavaScript読み込み
- **19-21行目**: ロケール別Datepicker読み込み
- **39行目**: ヘッダーパーシャルレンダリング
- **40-43行目**: タブレス/タブありレイアウト切り替え
- **46-50行目**: フッターJavaScript設定

#### Step 2: ヘッダー部を理解する

ヘッダーパーシャルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | _header.html.haml | `app/views/layouts/_header.html.haml` | ユーザーメニュー、ロゴ |

**主要処理フロー**:
- **3-13行目**: ログイン中ユーザーのメニュー表示
- **9行目**: Quick Findリンク
- **10行目**: Profileリンク
- **11-12行目**: Adminリンク（管理者のみ）
- **13行目**: Logoutリンク
- **19-20行目**: ロゴリンク

#### Step 3: タブ付きレイアウトを理解する

タブ付きレイアウトパーシャルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _tabbed.html.haml | `app/views/layouts/_tabbed.html.haml` | ナビゲーション、サイドバー、メイン領域 |

**主要処理フロー**:
- **1-11行目**: Bootstrap navbar（タブリスト）
- **6-10行目**: 各タブのレンダリング
- **12行目**: フラッシュメッセージ表示
- **15-16行目**: サイドバーレンダリング
- **17-18行目**: メインコンテンツ領域（yield）

#### Step 4: サイドバーを理解する

サイドバーパーシャルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | _sidebar.html.haml | `app/views/layouts/_sidebar.html.haml` | コンテキストサイドバー、リスト、最近のアイテム |

**主要処理フロー**:
- **3-4行目**: コントローラ/アクション固有のサイドバー決定
- **8行目**: コンテキストサイドバーレンダリング
- **11行目**: リストメニューレンダリング
- **12行目**: 最近のアイテムレンダリング

#### Step 5: フッターを理解する

フッターパーシャルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | _footer.html.haml | `app/views/layouts/_footer.html.haml` | バージョン情報、Aboutリンク |

### プログラム呼び出し階層図

```
application.html.haml
    │
    ├─ <head>
    │      ├─ stylesheet_link_tag :application, :print
    │      ├─ Leaflet CDN
    │      ├─ javascript_include_tag :application
    │      ├─ csrf_meta_tag
    │      └─ hook(:stylesheet_includes), hook(:javascript_includes)
    │
    └─ <body>
           │
           ├─ _header.html.haml
           │      ├─ #welcome
           │      │      ├─ current_user.name
           │      │      ├─ Quick Find / Profile / Admin / Logout
           │      │      └─ _jumpbox.html.haml
           │      └─ h3 > "Fat Free CRM"
           │
           ├─ [tabless_layout?]
           │      ├─ true → _tabless.html.haml
           │      └─ false → _tabbed.html.haml
           │                       │
           │                       ├─ .navbar（タブリスト）
           │                       │      └─ tabs ヘルパー
           │                       │
           │                       ├─ show_flash
           │                       │
           │                       ├─ #sidebar
           │                       │      └─ _sidebar.html.haml
           │                       │             ├─ sidebar_#{action}
           │                       │             ├─ lists/lists
           │                       │             └─ shared/recently
           │                       │
           │                       └─ #main
           │                              └─ yield
           │
           └─ _footer.html.haml
                  ├─ FatFreeCRM::VERSION::STRING
                  ├─ About link
                  └─ _about.html.haml
```

### データフロー図

```
[入力]               [処理]                           [出力]

コントローラ
アクション ───▶ ApplicationController ───▶ レイアウト適用
                      │
                      ├─ layout 'application'
                      │
                      └─ render action_view
                             │
                             └─ application.html.haml
                                    │
                                    ├─ current_user
                                    │      └─ ヘッダー表示
                                    │
                                    ├─ tabs ヘルパー
                                    │      └─ ナビゲーション生成
                                    │
                                    └─ yield
                                           └─ アクションビュー挿入
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| application.html.haml | `app/views/layouts/application.html.haml` | レイアウト | メインレイアウトテンプレート |
| _header.html.haml | `app/views/layouts/_header.html.haml` | パーシャル | ヘッダー部（ユーザーメニュー、ロゴ） |
| _tabbed.html.haml | `app/views/layouts/_tabbed.html.haml` | パーシャル | タブ付きレイアウト |
| _tabless.html.haml | `app/views/layouts/_tabless.html.haml` | パーシャル | タブなしレイアウト |
| _sidebar.html.haml | `app/views/layouts/_sidebar.html.haml` | パーシャル | サイドバー |
| _footer.html.haml | `app/views/layouts/_footer.html.haml` | パーシャル | フッター |
| _jumpbox.html.haml | `app/views/layouts/_jumpbox.html.haml` | パーシャル | Quick Find UI |
| _about.html.haml | `app/views/layouts/_about.html.haml` | パーシャル | Aboutダイアログ |
| application_helper.rb | `app/helpers/application_helper.rb` | ヘルパー | tabs, tabless_layout? 等 |
| application.css | `app/assets/stylesheets/application.css` | スタイル | メインスタイルシート |
| application.js | `app/assets/javascripts/application.js` | JavaScript | メインJavaScript |
