# 画面設計書 5-メール確認画面

## 概要

本ドキュメントは、Fat Free CRMのメール確認画面の設計仕様を記述したものです。

### 本画面の処理概要

ユーザー登録時に送信される確認メールを再送信するための画面です。確認メールが届かなかった場合や、確認メールの有効期限が切れた場合に使用します。

**業務上の目的・背景**：本画面は、ユーザー登録後のメール確認プロセスにおいて、確認メールが正しく届かなかった場合の救済手段を提供します。メールの遅延、迷惑メールフォルダへの振り分け、有効期限切れなど、様々な理由で確認が完了できないユーザーに対して、確認メールを再送信する機能を提供することで、ユーザーのアカウント登録完了を支援します。

**画面へのアクセス方法**：直接URL `/users/confirmation/new` にアクセスします。通常、確認メール内のリンクが期限切れの場合に案内されます。

**主要な操作・処理内容**：
1. 登録済みメールアドレスを入力フィールドに入力する
2. 「Resend confirmation instructions」ボタンをクリックして確認メールの再送信を要求する
3. メールアドレスが登録されており、未確認の場合、確認メールが再送信される
4. ログイン画面にリダイレクトされ、送信完了メッセージが表示される

**画面遷移**：
- この画面に遷移してくる画面: 確認メールの期限切れエラー画面、ログイン画面
- この画面から遷移できる画面: ログイン画面（確認メール再送信後）

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- 認証済みユーザーがアクセスした場合は、ダッシュボードにリダイレクトされる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | メール確認 | 主機能 | メール確認再送信 |

## 画面種別

申請（メール確認再送信）

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/users/confirmation/new` | confirmations#new |
| POST | `/users/confirmation` | confirmations#create |

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| メールアドレス | email | 入力 | String | 必須 | 254 | 登録済みのメールアドレス |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| タイトル「Resend confirmation instructions」 | 常時 | 画面タイトル |
| エラーメッセージ | メールアドレスが見つからない場合 | エラーの詳細 |

## イベント仕様

### 1-Resend confirmation instructionsボタン押下

**トリガー**: 「Resend confirmation instructions」ボタンのクリック

**処理フロー**:
1. フォームデータ（email）がPOSTリクエストとして送信される
2. `ConfirmationsController#create`（Devise::ConfirmationsController継承）が呼び出される
3. メールアドレスでユーザーを検索
4. ユーザーが見つかり、未確認の場合:
   - `confirmation_token` を再生成
   - `confirmation_sent_at` に現在日時を設定
   - usersテーブルを更新
   - 確認メールを再送信
5. ユーザーが見つからない、または既に確認済みの場合:
   - エラーメッセージを設定
6. ログイン画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Resend confirmation instructionsボタン押下（対象ユーザー存在時） | users | UPDATE | 確認トークン等の更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | confirmation_token | 新しく生成されたランダムトークン | ハッシュ化して保存 |
| UPDATE | confirmation_sent_at | 現在日時 | トークン送信日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| devise.confirmations.new.resend_confirmation_instructions | タイトル | Resend confirmation instructions | 常時表示 |
| devise.confirmations.send_instructions | 成功 | (Deviseデフォルトメッセージ) | 確認メール再送信成功時 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| メールアドレスが未入力 | バリデーションエラー表示 | メール確認画面（再表示） |
| メールアドレスが登録されていない | エラーメッセージ表示 | メール確認画面（再表示） |
| 既にメール確認済み | エラーメッセージ表示 | メール確認画面（再表示） |
| メール送信に失敗 | エラーメッセージ表示 | メール確認画面（再表示） |

## 備考

- Deviseの`confirmable`モジュールを使用
- 確認トークンには有効期限がある（Deviseの設定による）
- 既に確認済みのユーザーには再送信されない
- スタンドアロンレイアウトを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メール確認に関わるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/users/user.rb` | Userモデルの構造、Deviseモジュール（`confirmable`）の設定を確認 |
| 1-2 | schema.rb | `db/schema.rb` | usersテーブルの`confirmation_token`、`confirmed_at`、`confirmation_sent_at`カラムを確認 |

**読解のコツ**: Userモデルの49行目で`confirmable`が設定されていることを確認。これによりメール確認機能が有効になります。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | confirmations_controller.rb | `app/controllers/confirmations_controller.rb` | ConfirmationsControllerがDevise::ConfirmationsControllerを継承していることを確認 |
| 2-2 | routes.rb | `config/routes.rb` | `devise_for :users`によるルーティング設定を確認 |

**主要処理フロー**:
1. **7行目**: `ConfirmationsController < Devise::ConfirmationsController` - Devise標準コントローラーを継承
2. Devise::ConfirmationsController#createが実際の処理を行う

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/confirmations/new.html.haml` | メール確認再送信フォームの構造を確認 |

**主要処理フロー**:
- **2行目**: `simple_form_for(resource, ..., html: { method: :post })` - POSTメソッドでフォーム送信
- **3行目**: タイトル「Resend confirmation instructions」
- **5-6行目**: メールアドレス入力フィールド
- **9行目**: Resend confirmation instructionsボタン

### プログラム呼び出し階層図

```
ブラウザ (POST /users/confirmation)
    │
    ├─ routes.rb (devise_for :users)
    │      └─ confirmations: 'confirmations'
    │
    └─ ConfirmationsController#create (継承: Devise::ConfirmationsController)
           │
           ├─ User.find_by(email: params[:email])
           │
           ├─ 確認済みかチェック
           │
           ├─ User#send_confirmation_instructions
           │      ├─ generate_confirmation_token
           │      ├─ save (confirmation_token, confirmation_sent_at)
           │      └─ send_email
           │
           └─ リダイレクト (after_resending_confirmation_instructions_path_for)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

email             ───▶  User.find_by(email: ...)
                             │
                   ┌─────────┴─────────┐
                   ▼                   ▼
             [未確認ユーザー]      [存在しない/確認済み]
                │                     │
                ▼                     │
        トークン生成                   │
        usersテーブル更新              │
        確認メール送信                 │
                │                     │
                └─────────┬───────────┘
                          ▼
                    ログイン画面
                    （メッセージ表示）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| confirmations_controller.rb | `app/controllers/confirmations_controller.rb` | コントローラー | メール確認処理の制御 |
| new.html.haml | `app/views/devise/confirmations/new.html.haml` | テンプレート | 再送信フォームの表示 |
| user.rb | `app/models/users/user.rb` | モデル | ユーザーモデル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
