# 画面設計書 50-管理画面レイアウト

## 概要

本ドキュメントは、Fat Free CRMの管理画面専用レイアウトの設計書です。管理者向け機能（ユーザー管理、グループ管理、タグ管理、設定など）で使用される共通テンプレートを定義します。

### 本画面の処理概要

本レイアウトは、Fat Free CRMの管理画面（Admin名前空間）で使用される共通テンプレートです。メインレイアウトと類似した構造を持ちますが、管理画面固有のヘッダー（「CRM Admin Page」タイトル、「Back to CRM」リンク）を提供します。管理者のみがアクセスする画面に適用され、通常のCRM画面とは視覚的に区別されます。

**業務上の目的・背景**：管理画面は一般ユーザー向けのCRM画面とは異なる目的（システム設定、ユーザー管理など）で使用されるため、専用のレイアウトを提供することで、管理者が現在管理画面にいることを明確に認識でき、誤操作を防ぐことができます。

**画面へのアクセス方法**：本レイアウトは直接アクセスするものではなく、Admin名前空間のコントローラから自動的に適用されます。

**主要な構成要素**：
1. HTMLヘッド部（メタ情報、CSS、JavaScript読み込み）
2. 管理画面専用ヘッダー部（「CRM Admin Page」タイトル、管理者メニュー）
3. ナビゲーションタブ（管理機能へのリンク）
4. メインコンテンツ領域
5. フッター部

**画面遷移**：ヘッダーの「Back to CRM」リンクから通常のCRM画面に戻ることができます。

**権限による表示制御**：本レイアウトは管理者権限を持つユーザーのみがアクセスする画面で使用されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 管理画面共通レイアウト | 主機能 | 管理画面共通のUI構造を提供 |

## 画面種別

レイアウト（管理画面共通テンプレート）

## URL/ルーティング

本レイアウトは特定のURLに紐づかず、Admin名前空間のコントローラが使用するレイアウトとして適用されます。

- **レイアウトファイル**: `app/views/layouts/admin/application.html.haml`
- **使用コントローラ**: `Admin::ApplicationController` を継承する全コントローラ

## 構成要素

### HTMLヘッド部

| 項目名 | 設定内容 | 備考 |
|--------|----------|------|
| doctype | XHTML | `!!!` |
| xml:lang属性 | I18n.locale | ユーザーのロケール設定 |
| charset | UTF-8 | - |
| title | t(:crm_admin_page) | "CRM Admin Page" |
| stylesheet | application.css, print.css | - |
| javascript | application.js | - |
| CSRF token | csrf_meta_tag | セキュリティ用 |

### ヘッダー部（管理画面専用）

| 項目名 | 表示形式 | データソース | 備考 |
|--------|----------|--------------|------|
| ウェルカムメッセージ | テキスト | current_user.name | "Welcome, [ユーザー名]!" |
| Quick Findリンク | リンク | "#" | ジャンプボックス表示用 |
| Profileリンク | リンク | profile_path | プロフィール画面へ |
| Back to CRMリンク | リンク | root_path | 通常のCRM画面に戻る |
| Logoutリンク | リンク | destroy_user_session_path | ログアウト |
| タイトル | リンク | admin_path | "CRM Admin Page" |

### ナビゲーションタブ

管理画面用のタブリスト（Users, Groups, Tags, Custom Fields, Settings, Plugins等）が表示されます。

### フッター部

メインレイアウトと同様のフッターが表示されます。

## イベント仕様

### 1-Back to CRMリンク押下

- **処理フロー**:
  1. root_path（ダッシュボード）に遷移
  2. 通常のメインレイアウトが適用される

### 2-タブクリック

- **処理フロー**:
  1. 対応する管理機能画面に遷移
  2. ナビゲーションタブのアクティブ状態が更新される

### 3-ログアウト押下

- **処理フロー**:
  1. `DELETE /users/sign_out` を呼び出し（Devise）
  2. セッションが破棄される
  3. ログイン画面にリダイレクト

## データベース更新仕様

本レイアウトは表示専用のため、直接のデータベース更新は発生しません。

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 | 表示位置 |
|---------------|------|---------------|----------|
| フラッシュ | コントローラで設定 | 各種メッセージ | show_flash ヘルパー |

## 例外処理

本レイアウトは共通テンプレートのため、特定の例外処理は含まれません。Admin::ApplicationControllerで管理者権限のチェックが行われます。

## 備考

- 本レイアウトはメインレイアウトとほぼ同じ構造ですが、管理画面専用のヘッダーを持ちます。
- bodyタグに `admin` クラスが付与され、管理画面専用のスタイルが適用されます。
- メインレイアウトと異なり、Leaflet地図ライブラリは読み込まれません（管理画面で地図機能は使用されないため）。
- `hook` メソッドによりプラグインからJavaScriptを追加できます。
- ヘッダーのタイトルは「Fat Free CRM」ではなく「CRM Admin Page」です。

---

## コードリーディングガイド

本レイアウトを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: レイアウト全体構造を理解する

管理画面レイアウトファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | application.html.haml | `app/views/layouts/admin/application.html.haml` | HTML構造、CSS/JS読み込み、管理画面固有の設定 |

**主要処理フロー**:
- **1-2行目**: XHTMLドキュメント開始（メインレイアウトと異なりHTML5ではない）
- **5行目**: タイトル `t(:crm_admin_page)`
- **7-8行目**: スタイルシート読み込み
- **11行目**: JavaScript読み込み
- **12行目**: フックポイント
- **17行目**: bodyタグに `admin` クラス
- **18行目**: 管理画面専用ヘッダーパーシャル
- **19行目**: タブ付きレイアウト（共通）
- **20行目**: フッター
- **21-24行目**: フッターJavaScript設定

#### Step 2: 管理画面ヘッダーを理解する

管理画面専用ヘッダーパーシャルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | _header.html.haml | `app/views/layouts/admin/_header.html.haml` | 管理画面専用ユーザーメニュー |

**主要処理フロー**:
- **4-5行目**: ウェルカムメッセージ（current_user.name）
- **8行目**: Quick Findリンク
- **9行目**: Profileリンク
- **10行目**: Back to CRMリンク（root_path）- 管理画面特有
- **11行目**: Logoutリンク
- **14行目**: タイトル「CRM Admin Page」へのリンク

### プログラム呼び出し階層図

```
admin/application.html.haml
    │
    ├─ <head>
    │      ├─ stylesheet_link_tag :application, :print
    │      ├─ javascript_include_tag :application
    │      ├─ hook(:javascript_includes)
    │      └─ csrf_meta_tag
    │
    └─ <body class="admin">
           │
           ├─ admin/_header.html.haml
           │      ├─ #welcome
           │      │      ├─ current_user.name
           │      │      ├─ Quick Find / Profile
           │      │      ├─ Back to CRM (root_path)
           │      │      └─ Logout
           │      └─ h3 > "CRM Admin Page"
           │
           ├─ _tabbed.html.haml（共通）
           │      ├─ .navbar（管理画面タブ）
           │      ├─ show_flash
           │      ├─ #sidebar
           │      └─ #main > yield
           │
           └─ _footer.html.haml（共通）

メインレイアウトとの差異：
┌────────────────────┬──────────────────┬──────────────────┐
│ 項目               │ メインレイアウト │ 管理画面レイアウト │
├────────────────────┼──────────────────┼──────────────────┤
│ doctype            │ HTML5            │ XHTML            │
│ bodyクラス         │ なし             │ admin            │
│ タイトル           │ Fat Free CRM     │ CRM Admin Page   │
│ Adminリンク        │ あり             │ なし             │
│ Back to CRMリンク  │ なし             │ あり             │
│ Leaflet            │ あり             │ なし             │
│ タブレス切り替え   │ あり             │ なし             │
└────────────────────┴──────────────────┴──────────────────┘
```

### データフロー図

```
[入力]               [処理]                           [出力]

Admin::XxxController
アクション ───▶ Admin::ApplicationController ───▶ 管理画面レイアウト適用
                      │
                      ├─ layout 'admin/application'
                      │
                      └─ render action_view
                             │
                             └─ admin/application.html.haml
                                    │
                                    ├─ current_user
                                    │      └─ 管理者ヘッダー表示
                                    │
                                    ├─ admin_tabs ヘルパー
                                    │      └─ 管理画面ナビゲーション
                                    │
                                    └─ yield
                                           └─ 管理画面ビュー挿入
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| application.html.haml | `app/views/layouts/admin/application.html.haml` | レイアウト | 管理画面メインレイアウトテンプレート |
| _header.html.haml | `app/views/layouts/admin/_header.html.haml` | パーシャル | 管理画面ヘッダー部 |
| _tabbed.html.haml | `app/views/layouts/_tabbed.html.haml` | パーシャル | タブ付きレイアウト（共通） |
| _footer.html.haml | `app/views/layouts/_footer.html.haml` | パーシャル | フッター（共通） |
| _jumpbox.html.haml | `app/views/layouts/_jumpbox.html.haml` | パーシャル | Quick Find UI（共通） |
| application_controller.rb | `app/controllers/admin/application_controller.rb` | コントローラ | 管理画面基底コントローラ、認可処理 |
| application_helper.rb | `app/helpers/application_helper.rb` | ヘルパー | 共通ヘルパー |
| application.css | `app/assets/stylesheets/application.css` | スタイル | メインスタイルシート |
| application.js | `app/assets/javascripts/application.js` | JavaScript | メインJavaScript |
