# 画面設計書 51-500エラー画面

## 概要

本ドキュメントは、Fat Free CRMにおける500エラー画面（サーバーエラー発生時のエラー画面）の画面設計書である。

### 本画面の処理概要

500エラー画面は、アプリケーション内で予期しないサーバーエラー（Internal Server Error）が発生した際にユーザーに表示されるエラー通知画面である。ユーザーに対してシステムで問題が発生したことを明確に伝え、適切な対応を促す役割を持つ。

**業務上の目的・背景**：Webアプリケーションにおいて、データベース接続エラー、プログラムのバグ、メモリ不足など、サーバー側で予期しない問題が発生することは避けられない。このような状況で、技術的なエラーメッセージをそのままユーザーに表示することは、セキュリティ上の問題があり、またユーザーエクスペリエンスを著しく損なう。500エラー画面は、こうしたサーバーエラーをユーザーフレンドリーな形式でラップし、システムの信頼性を維持しながらユーザーに状況を伝えることを目的としている。

**画面へのアクセス方法**：この画面は、ユーザーが直接アクセスするものではない。アプリケーション内で処理できない例外（Exception）が発生した際に、Railsフレームワークによって自動的にレンダリングされる。本番環境では`public/500.html`が、開発環境ではデバッグ情報を含む画面が表示される。また、一部の例外処理では`app/views/layouts/500.html.haml`テンプレートが使用される場合がある。

**主要な操作・処理内容**：
1. エラーメッセージの表示：発生した例外の概要をユーザーに通知
2. ホームへの誘導：「Fat Free CRM」リンクによりトップページへの導線を提供
3. システム管理者への通知（暗黙的）：エラー発生をログに記録し、運用チームへの通知基盤を構築

**画面遷移**：
- この画面からの遷移先：ホーム画面（ダッシュボード）へのリンクのみ
- この画面に遷移してくる画面：アプリケーション内のすべての画面（サーバーエラー発生時）

**権限による表示制御**：この画面は認証状態に関係なく表示される。サーバーエラー発生時は、認証処理自体が失敗している可能性があるため、認証チェックを行わない静的ページとして設計されている。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 例外処理 | 主機能 | サーバーエラー発生時のユーザー通知 |
| - | ホーム遷移 | 補助機能 | トップページへのナビゲーション提供 |

## 画面種別

エラー通知画面（静的ページ）

## URL/ルーティング

この画面は通常のルーティングを持たない。Railsの例外処理機構により以下の方法で表示される：

- 本番環境：`config.consider_all_requests_local = false` の設定により、例外発生時に`public/500.html`が表示される
- 開発環境：`config.consider_all_requests_local = true` の設定により、デバッグ情報を含む詳細エラー画面が表示される
- カスタム例外処理：`app/views/layouts/500.html.haml`テンプレートは、特定の例外ハンドリングコードから呼び出される場合がある

## 入出力項目

この画面には入力項目はない。

## 表示項目

### 静的HTML版（public/500.html）

| No | 項目名 | 項目種別 | 表示内容 |
|----|--------|----------|----------|
| 1 | タイトル | ページタイトル | "We're sorry, but something went wrong (500)" |
| 2 | エラーメッセージ（見出し） | h1 | "We're sorry, but something went wrong." |
| 3 | 補足メッセージ | p | "We've been notified about this issue and we'll take a look at it shortly." |

### HAMLテンプレート版（app/views/layouts/500.html.haml）

| No | 項目名 | 項目種別 | 表示内容 |
|----|--------|----------|----------|
| 1 | タイトル | ページタイトル | "Fat Free CRM Exception" |
| 2 | ヘッダーロゴ | リンク | "Fat Free CRM" → ホーム画面へのリンク（/） |
| 3 | エラーメッセージ | p.flash_exception | 変数`exception`の内容 |

## イベント仕様

### 1-ホームリンククリック

**トリガー**: ヘッダーの「Fat Free CRM」リンクをクリック

**処理内容**:
1. アプリケーションのルートURL（/）へ遷移
2. 認証状態に応じてダッシュボードまたはログイン画面が表示される

**遷移先**: ホーム画面（ダッシュボード）またはログイン画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | なし | - | データベースアクセスなし |

この画面は静的なエラー表示ページであり、データベースへのアクセスは行わない。

## メッセージ仕様

| No | メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|----|-------------|---------------|---------------|----------|
| 1 | - | エラー | "We're sorry, but something went wrong." | 常時（静的HTML版） |
| 2 | - | 通知 | "We've been notified about this issue and we'll take a look at it shortly." | 常時（静的HTML版） |
| 3 | - | エラー | `exception`変数の内容 | HAML版使用時 |

## 例外処理

この画面自体が例外処理の結果として表示される画面であるため、この画面内での例外処理は最小限に設計されている。

| 例外パターン | 対応方法 |
|-------------|----------|
| 500エラー画面自体のレンダリングエラー | 静的HTML版（public/500.html）が最終フォールバックとして使用される |
| スタイルシート・JavaScriptの読み込みエラー | 静的HTML版には最小限のインラインCSSが含まれており、外部アセットに依存しない |

## 備考

### 2種類のエラー画面について

Fat Free CRMには、500エラーを表示するための2つの異なるテンプレートが存在する：

1. **public/500.html**
   - 完全な静的HTMLファイル
   - インラインCSSを含み、外部リソースに依存しない
   - Railsアプリケーションが完全に停止している場合でもWebサーバーが直接配信可能
   - 本番環境での標準的なエラー表示に使用

2. **app/views/layouts/500.html.haml**
   - HAMLテンプレートによる動的生成
   - `exception`変数を介してエラー詳細を表示可能
   - CSSとJavaScriptを外部ファイルから読み込む
   - アプリケーションコードからの明示的なレンダリングに使用

### スタイル設定

エラーメッセージの表示には`.flash_exception`クラスが使用され、以下のスタイルが適用される（`app/assets/stylesheets/rails.scss`参照）：

- 背景色: #ddff99（薄い黄緑）
- ボーダー: 5px limegreen solid
- フォントサイズ: 1.1em
- マージン: 50px auto
- パディング: 50px
- 幅: 450px
- ボックスシャドウ: 影付き表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

500エラー画面は静的ページであり、複雑なデータ構造は持たない。HAMLテンプレート版では`exception`変数のみが使用される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | 500.html | `public/500.html` | 静的エラーページの基本構造を理解する |
| 1-2 | 500.html.haml | `app/views/layouts/500.html.haml` | HAMLテンプレートの構造と`exception`変数の使用方法を理解する |

**読解のコツ**: HAMLテンプレートでは`= exception`という記法でRubyの変数を出力している。`content_for(:tabless)`ブロックは、レイアウト内でタブなしコンテンツを定義するためのRailsヘルパー。

#### Step 2: エントリーポイントを理解する

エラー画面の表示は、Railsの例外処理機構によってトリガーされる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | application_controller.rb | `app/controllers/application_controller.rb` | 例外ハンドリングの定義を確認（rescue_from） |
| 2-2 | production.rb | `config/environments/production.rb` | 本番環境でのエラー表示設定を確認 |
| 2-3 | development.rb | `config/environments/development.rb` | 開発環境でのエラー表示設定を確認 |

**主要処理フロー**:
1. **29-30行目（application_controller.rb）**: `rescue_from`による例外ハンドリング定義
2. **64-71行目（application_controller.rb）**: `ArgumentError`の特別処理（Rails 6以前のセッション互換性）
3. **22行目（production.rb）**: `consider_all_requests_local = false`により静的エラーページを使用

#### Step 3: スタイル定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rails.scss | `app/assets/stylesheets/rails.scss` | `.flash_exception`クラスのスタイル定義を確認 |

**主要処理フロー**:
- **50-58行目（rails.scss）**: `.flash_exception`のスタイル定義（背景色、ボーダー、マージン、ボックスシャドウ）

### プログラム呼び出し階層図

```
[サーバーエラー発生]
    │
    ├─ 本番環境（consider_all_requests_local = false）
    │      │
    │      └─ Webサーバー → public/500.html を直接配信
    │
    ├─ 開発環境（consider_all_requests_local = true）
    │      │
    │      └─ Rails → デバッグ情報を含む詳細エラー画面
    │
    └─ カスタム例外処理（rescue_from）
           │
           ├─ respond_to_not_found → リダイレクト処理
           │
           ├─ respond_to_access_denied → 権限エラー処理
           │
           └─ 未ハンドル例外 → 500.html.haml（exception変数付き）
```

### データフロー図

```
[入力]               [処理]                         [出力]

例外発生 ──────────▶ Railsミドルウェア ──────────▶ 500エラー画面
                    └─ ActionDispatch::            └─ public/500.html
                       ShowExceptions                 または
                                                      500.html.haml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| 500.html | `public/500.html` | 静的HTML | 本番環境用の静的エラーページ |
| 500.html.haml | `app/views/layouts/500.html.haml` | テンプレート | 動的エラーページテンプレート |
| application_controller.rb | `app/controllers/application_controller.rb` | コントローラー | 例外ハンドリングの基底定義 |
| rails.scss | `app/assets/stylesheets/rails.scss` | スタイルシート | flash_exceptionスタイル定義 |
| production.rb | `config/environments/production.rb` | 設定 | 本番環境のエラー表示設定 |
| development.rb | `config/environments/development.rb` | 設定 | 開発環境のエラー表示設定 |
