# 画面設計書 6-ホーム画面（ダッシュボード）

## 概要

本ドキュメントは、Fat Free CRMのホーム画面（ダッシュボード）の設計仕様を記述したものです。

### 本画面の処理概要

ログイン後に表示されるメイン画面で、ユーザーのタスク、商談、取引先、および最近のアクティビティを一覧表示します。CRM業務の起点となる中心的な画面です。

**業務上の目的・背景**：本画面は、営業担当者やCRMユーザーが日々の業務を効率的に行うためのハブとして機能します。自分に割り当てられたタスク、進行中の商談、担当取引先を一目で把握でき、チーム全体のアクティビティもリアルタイムで確認できます。これにより、優先度の高い業務の特定、進捗状況の把握、チームコラボレーションの促進を実現します。

**画面へのアクセス方法**：ログイン成功後に自動的にリダイレクトされます。また、ヘッダーの「Dashboard」タブをクリックするか、URL `/` または `/activities` にアクセスします。

**主要な操作・処理内容**：
1. 自分のタスク一覧を確認する（最大10件表示）
2. 自分の商談一覧を確認する（最大10件表示）
3. 自分の取引先一覧を確認する（最大10件表示）
4. 最近のアクティビティを確認する
5. アクティビティフィルターでフィルタリング条件を変更する
6. 各タブから詳細画面に遷移する

**画面遷移**：
- この画面に遷移してくる画面: ログイン画面（認証成功後）、各詳細画面から戻る場合、ヘッダーのDashboardタブ
- この画面から遷移できる画面: 取引先一覧/詳細、キャンペーン一覧/詳細、リード一覧/詳細、連絡先一覧/詳細、商談一覧/詳細、タスク一覧/詳細、ユーザープロフィール、管理画面

**権限による表示制御**：
- 認証済みユーザーのみがアクセス可能
- 各セクションには自分に割り当てられた、または自分が作成したアイテムのみ表示
- 管理者リンクは管理者ユーザーのみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ダッシュボード表示 | 主機能 | アクティビティ、タスク、商談、取引先の一覧表示 |
| 2 | アクティビティフィルタリング | 補助機能 | アセット種別・イベント種別・ユーザー・期間でフィルタリング |
| 3 | タイムライン表示切替 | 補助機能 | コメント・メールのタイムライン展開/折りたたみ切替 |
| 34 | タスク一覧表示 | 補助機能 | 自分のタスクをダッシュボードに表示 |
| 28 | 商談一覧表示 | 補助機能 | 自分の商談をダッシュボードに表示 |
| 4 | 取引先一覧表示 | 補助機能 | 自分の取引先をダッシュボードに表示 |
| 36 | タスク作成 | API連携 | ダッシュボードからのクイックタスク作成 |

## 画面種別

ダッシュボード（一覧）

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/` | home#index |
| GET | `/activities` | home#index |
| GET | `/home/options` | home#options (AJAX) |
| POST | `/home/redraw` | home#redraw (AJAX) |
| GET/PUT/POST | `/home/timeline` | home#timeline (AJAX) |
| GET/PUT/POST | `/home/timezone` | home#timezone (AJAX) |
| GET | `/home/toggle` | home#toggle (AJAX) |

## 入出力項目

本画面は主に表示画面のため、入力項目は限定的です。

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| アセット種別フィルター | asset | 入力（オプション選択） | String | - | all/accounts/campaigns/leads/contacts/opportunities |
| イベント種別フィルター | event | 入力（オプション選択） | String | - | all_events/create/update/destroy |
| ユーザーフィルター | user | 入力（オプション選択） | String | - | all_users/特定ユーザー |
| 期間フィルター | duration | 入力（オプション選択） | String | - | one_hour/one_day/two_days/one_week/two_weeks/one_month |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| My Tasks セクション | 常時 | 自分のタスク一覧（最大10件） |
| My Opportunities セクション | 常時 | 自分の商談一覧（最大10件） |
| My Accounts セクション | 常時 | 自分の取引先一覧（最大10件） |
| Recent Activity セクション | 常時 | 最近のアクティビティ一覧 |
| Options リンク | 常時 | アクティビティフィルター設定 |
| 「no tasks/opportunities/accounts」メッセージ | 該当データが0件の場合 | 空状態のメッセージ |
| 隠しアイテム数メッセージ | 10件を超える場合 | 「Not showing X hidden items」 |

## イベント仕様

### 1-Optionsリンク押下

**トリガー**: 「Options」リンクのクリック

**処理フロー**:
1. AJAXリクエストで `/home/options` が呼び出される
2. `HomeController#options` が実行される
3. 現在のフィルター設定（asset, event, user, duration）を取得
4. オプション設定フォームをモーダル表示

### 2-フィルター変更

**トリガー**: オプション設定フォームでの値変更

**処理フロー**:
1. AJAXリクエストで `/home/redraw` がPOSTされる
2. `HomeController#redraw` が実行される
3. ユーザーのプリファレンスを更新
4. フィルター条件に基づいてアクティビティを再取得
5. Recent Activityセクションを再描画

### 3-タイムライン展開/折りたたみ

**トリガー**: タイムラインアイテムのクリック

**処理フロー**:
1. AJAXリクエストで `/home/timeline` が呼び出される
2. `HomeController#timeline` が実行される
3. コメント/メールの状態（Expanded/Collapsed）を更新
4. 表示状態を切り替え

### 4-タスク/商談/取引先クリック

**トリガー**: 各アイテムのクリック

**処理フロー**:
1. 該当する詳細画面に遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フィルター変更 | preferences | INSERT/UPDATE | ユーザープリファレンスの保存 |
| タイムライン展開/折りたたみ | comments/emails | UPDATE | state カラムの更新 |

### テーブル別更新項目詳細

#### preferences

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | activity_asset / activity_event / activity_user / activity_duration | プリファレンス名 |
| INSERT/UPDATE | value | 選択された値 | シリアライズして保存 |

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state | Expanded / Collapsed | 表示状態 |

#### emails

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | state | Expanded / Collapsed | 表示状態 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| my_tasks | タイトル | My Tasks | タスクセクションタイトル |
| my_opportunities | タイトル | My Opportunities | 商談セクションタイトル |
| my_accounts | タイトル | My Accounts | 取引先セクションタイトル |
| recent_activity | タイトル | Recent Activity | アクティビティセクションタイトル |
| no_task_records | 案内 | You have no tasks. | タスクが0件の場合 |
| no_opportunity_records | 案内 | You have no opportunities. | 商談が0件の場合 |
| no_account_records | 案内 | You have no accounts | 取引先が0件の場合 |
| no_activity_records | 案内 | No activity records found. | アクティビティが0件の場合 |
| not_showing_hidden_entities | 案内 | Not showing %{count} hidden %{entity}. | 10件を超える場合 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| 未認証アクセス | ログイン画面にリダイレクト | ログイン画面 |
| データ取得エラー | エラーメッセージ表示 | ダッシュボード画面 |

## 備考

- タスク、商談、取引先は各最大10件まで表示（`limit(10)`）
- アクティビティは最大500件まで取得
- フィルター設定はユーザーごとにプリファレンスに保存される
- タブ付きレイアウト（`_tabbed.html.haml`）を使用
- Excelエクスポート機能あり（`.xls`形式）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ダッシュボードで表示されるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | task.rb | `app/models/entities/task.rb` | Taskモデルの構造、`visible_on_dashboard`スコープを確認 |
| 1-2 | opportunity.rb | `app/models/entities/opportunity.rb` | Opportunityモデルの構造、`visible_on_dashboard`スコープを確認 |
| 1-3 | account.rb | `app/models/entities/account.rb` | Accountモデルの構造、`visible_on_dashboard`スコープを確認 |
| 1-4 | version.rb | `app/models/polymorphic/version.rb` | Versionモデル（アクティビティ）の構造を確認 |

**読解のコツ**: 各モデルの`visible_on_dashboard`スコープを確認し、どのような条件でダッシュボードに表示されるかを理解します。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | home_controller.rb | `app/controllers/home_controller.rb` | indexアクション（13-21行目）、options/redrawアクション、get_activitiesメソッドを確認 |
| 2-2 | routes.rb | `config/routes.rb` | ダッシュボード関連のルーティングを確認（11行目、31-39行目） |

**主要処理フロー**:
1. **13-21行目**: `index` - ダッシュボードのメイン処理
2. **15行目**: `@my_tasks` - タスク取得
3. **16行目**: `@my_opportunities` - 商談取得
4. **17行目**: `@my_accounts` - 取引先取得
5. **14行目**: `@activities` - アクティビティ取得
6. **25-32行目**: `options` - フィルター設定画面
7. **36-46行目**: `redraw` - フィルター適用後の再描画

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/home/index.html.haml` | ダッシュボードのメイン構造を確認 |
| 3-2 | _task.html.haml | `app/views/home/_task.html.haml` | タスクパーシャルの構造を確認 |
| 3-3 | _opportunity.html.haml | `app/views/home/_opportunity.html.haml` | 商談パーシャルの構造を確認 |
| 3-4 | _account.html.haml | `app/views/home/_account.html.haml` | 取引先パーシャルの構造を確認 |
| 3-5 | _activity.html.haml | `app/views/home/_activity.html.haml` | アクティビティパーシャルの構造を確認 |

**主要処理フロー**:
- **5-11行目**: My Tasksセクション
- **13-19行目**: My Opportunitiesセクション
- **21-29行目**: My Accountsセクション
- **31-33行目**: Optionsリンク
- **35-36行目**: Recent Activityタイトル
- **39-43行目**: アクティビティ一覧

### プログラム呼び出し階層図

```
ブラウザ (GET /)
    │
    ├─ routes.rb (root to: 'home#index')
    │
    └─ HomeController#index
           │
           ├─ get_activities
           │      └─ Version.latest.visible_to(current_user)
           │
           ├─ Task.visible_on_dashboard(current_user)
           │
           ├─ Opportunity.visible_on_dashboard(current_user)
           │
           └─ Account.visible_on_dashboard(current_user)
                   │
                   ▼
           index.html.haml
                   │
                   ├─ _task.html.haml (collection)
                   ├─ _opportunity.html.haml (collection)
                   ├─ _account.html.haml (collection)
                   └─ _activity.html.haml (collection)
```

### データフロー図

```
[データソース]                [処理]                    [出力]

tasks テーブル       ───▶  Task.visible_on_dashboard
                              │
opportunities テーブル ───▶  Opportunity.visible_on_dashboard
                              │
accounts テーブル     ───▶  Account.visible_on_dashboard
                              │
versions テーブル    ───▶  Version.latest.visible_to
                              │
preferences テーブル  ───▶  フィルター設定読み込み
                              │
                              ▼
                        HomeController#index
                              │
                              ▼
                        index.html.haml
                              │
                              ▼
                        [ダッシュボード画面]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| home_controller.rb | `app/controllers/home_controller.rb` | コントローラー | ダッシュボード処理の制御 |
| index.html.haml | `app/views/home/index.html.haml` | テンプレート | ダッシュボードの表示 |
| _task.html.haml | `app/views/home/_task.html.haml` | テンプレート | タスクアイテムの表示 |
| _opportunity.html.haml | `app/views/home/_opportunity.html.haml` | テンプレート | 商談アイテムの表示 |
| _account.html.haml | `app/views/home/_account.html.haml` | テンプレート | 取引先アイテムの表示 |
| _activity.html.haml | `app/views/home/_activity.html.haml` | テンプレート | アクティビティアイテムの表示 |
| _options.html.haml | `app/views/home/_options.html.haml` | テンプレート | フィルターオプションの表示 |
| task.rb | `app/models/entities/task.rb` | モデル | タスクモデル |
| opportunity.rb | `app/models/entities/opportunity.rb` | モデル | 商談モデル |
| account.rb | `app/models/entities/account.rb` | モデル | 取引先モデル |
| version.rb | `app/models/polymorphic/version.rb` | モデル | アクティビティ（バージョン）モデル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| fat_free_crm.en-US.yml | `config/locales/fat_free_crm.en-US.yml` | 設定 | 国際化メッセージ定義 |
