# 画面設計書 7-取引先一覧画面

## 概要

本ドキュメントは、Fat Free CRMの取引先一覧画面の設計仕様を記述したものです。

### 本画面の処理概要

取引先（Account）の一覧をフィルタリング・検索・表示する画面です。カテゴリ別のフィルタリング、テキスト検索、高度な検索（Ransack）機能を提供し、CSV/Excelエクスポートも可能です。

**業務上の目的・背景**：本画面は、営業担当者が担当する取引先（顧客・パートナー企業など）を効率的に管理するための中心的な機能を提供します。カテゴリ別（顧客、パートナー、競合他社など）のフィルタリングにより、目的に応じた取引先リストを素早く抽出できます。また、高度な検索機能により、複雑な条件での検索も可能です。

**画面へのアクセス方法**：ヘッダーの「Accounts」タブをクリックするか、URL `/accounts` にアクセスします。

**主要な操作・処理内容**：
1. 取引先一覧を表示する
2. カテゴリ（顧客、パートナー、競合他社など）でフィルタリングする
3. テキスト検索で取引先を検索する
4. 高度な検索（Advanced Search）で詳細条件を指定する
5. 新規取引先を作成する
6. 取引先詳細画面に遷移する
7. CSV/Excelファイルにエクスポートする
8. 表示件数やソート順を変更する

**画面遷移**：
- この画面に遷移してくる画面: ダッシュボード、取引先詳細画面、ヘッダーのAccountsタブ
- この画面から遷移できる画面: 取引先詳細画面、取引先新規作成フォーム

**権限による表示制御**：
- 認証済みユーザーのみがアクセス可能
- 自分が作成した、または自分に割り当てられた、または共有された取引先のみ表示
- 権限に応じて編集・削除ボタンの表示制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 取引先一覧表示 | 主機能 | 取引先の一覧表示、カテゴリフィルタリング、CSV/XLSエクスポート |
| 81 | 高度な検索 | 補助機能 | Ransackによる詳細検索 |
| 82 | オートコンプリート | API連携 | 取引先名の入力補完 |
| 8 | 取引先削除 | 補助機能 | 取引先の削除処理 |

## 画面種別

一覧

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/accounts` | accounts#index |
| POST | `/accounts/filter` | accounts#filter (AJAX) |
| GET | `/accounts/advanced_search` | accounts#advanced_search (AJAX) |
| GET/POST | `/accounts/auto_complete` | accounts#auto_complete (AJAX) |
| GET | `/accounts/options` | accounts#options (AJAX) |
| GET | `/accounts/redraw` | accounts#redraw (AJAX) |

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| 検索クエリ | query | 入力 | String | - | テキスト検索用クエリ |
| カテゴリフィルター | category | 入力（チェックボックス） | Array | - | affiliate/competitor/customer/partner/reseller/vendor/other |
| ページ番号 | page | 入力 | Integer | - | ページネーション用 |
| 表示件数 | per_page | 入力 | Integer | - | 1ページあたりの表示件数 |
| ソート順 | sort_by | 入力 | String | - | name/rating/created_at/updated_at |
| 高度な検索条件 | q | 入力（オブジェクト） | Object | - | Ransack検索パラメータ |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| 取引先一覧 | 常時 | 取引先のリスト |
| 取引先名 | 常時 | 取引先の名前（リンク） |
| カテゴリ | 常時 | 取引先のカテゴリ |
| 電話番号 | 常時 | 取引先の電話番号 |
| ウェブサイト | 常時 | 取引先のウェブサイトURL |
| 評価（Rating） | 常時 | 取引先の評価（星表示） |
| パイプライン | 常時 | 関連商談の金額合計 |
| 作成日/更新日 | 常時 | 取引先の作成日または更新日 |
| サイドバー（カテゴリフィルター） | 常時 | カテゴリ別の件数とチェックボックス |
| ページネーション | 常時 | ページ切り替え |
| 検索結果件数 | 検索実行時 | 検索結果の件数 |
| 新規作成ボタン | 常時 | 取引先新規作成フォームを開く |
| エクスポートリンク | 常時 | CSV/Excelエクスポート |

## イベント仕様

### 1-新規作成ボタン押下

**トリガー**: 「Create Account」ボタンのクリック

**処理フロー**:
1. AJAXリクエストで `/accounts/new` が呼び出される
2. `AccountsController#new` が実行される
3. 新規取引先フォームがモーダル/インラインで表示される

### 2-カテゴリフィルター変更

**トリガー**: サイドバーのカテゴリチェックボックスの変更

**処理フロー**:
1. AJAXリクエストで `/accounts/filter` がPOSTされる
2. `AccountsController#filter` が実行される
3. セッションにフィルター条件を保存
4. フィルター条件に基づいて取引先一覧を再取得
5. 一覧を再描画

### 3-テキスト検索

**トリガー**: 検索フィールドへの入力とEnterキー

**処理フロー**:
1. 検索クエリをパラメータとして `/accounts` にGETリクエスト
2. `AccountsController#index` が実行される
3. `text_search`スコープで取引先を検索
4. 検索結果を表示

### 4-高度な検索

**トリガー**: 「Advanced Search」リンクのクリック

**処理フロー**:
1. AJAXリクエストで `/accounts/advanced_search` が呼び出される
2. Ransack検索フォームが表示される
3. 条件入力後、検索実行
4. 検索結果を表示

### 5-取引先名クリック

**トリガー**: 取引先名リンクのクリック

**処理フロー**:
1. `/accounts/:id` に遷移
2. 取引先詳細画面を表示

### 6-エクスポート

**トリガー**: CSV/Excelエクスポートリンクのクリック

**処理フロー**:
1. `/accounts.csv` または `/accounts.xls` にGETリクエスト
2. 現在のフィルター条件で全件取得
3. CSV/Excelファイルを生成してダウンロード

### 7-削除

**トリガー**: 削除ボタンのクリック

**処理フロー**:
1. 確認ダイアログを表示
2. 確認後、DELETEリクエストで `/accounts/:id` を呼び出す
3. `AccountsController#destroy` が実行される
4. 取引先を論理削除（deleted_atを設定）
5. 一覧を再描画

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | accounts | UPDATE | deleted_atの設定（論理削除） |
| フィルター変更 | sessions | UPDATE | セッションデータの更新 |

### テーブル別更新項目詳細

#### accounts（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| tab_accounts | タイトル | Accounts | タブタイトル |
| total_accounts | 情報 | Total Accounts | 合計件数表示 |
| create_account | ボタン | Create Account | 新規作成ボタン |
| search_assets | プレースホルダー | Search %{value} | 検索フィールド |
| could_not_find | 案内 | Couldn't find any %{value}. Feel free to | 検索結果0件時 |
| msg_asset_deleted | 成功 | %{value} has been deleted. | 削除成功時 |
| confirm_delete | 確認 | Are you sure you want to delete this %{value}? | 削除確認時 |
| to_xls | リンク | Export to Excel | Excelエクスポート |
| to_csv | リンク | Export to comma-delimited file format | CSVエクスポート |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| 未認証アクセス | ログイン画面にリダイレクト | ログイン画面 |
| 権限不足 | アクセス拒否メッセージ表示 | 前の画面 |
| データ取得エラー | エラーメッセージ表示 | 取引先一覧画面 |

## 備考

- デフォルトのソート順は「作成日時降順」
- 1ページあたりのデフォルト表示件数は20件
- カテゴリは設定（Setting.account_category）から取得
- タグ検索は `#タグ名` 形式で入力
- 論理削除を採用（deleted_atがNULLでないレコードは表示されない）
- タブ付きレイアウト（`_tabbed.html.haml`）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、取引先に関わるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | account.rb | `app/models/entities/account.rb` | Accountモデルの構造、スコープ（state, text_search, by_name）、関連を確認 |
| 1-2 | schema.rb | `db/schema.rb` | accountsテーブルの構造（32-55行目）を確認 |

**読解のコツ**: Accountモデルの49-63行目でスコープ定義が確認できます。`scope :state`（49-51行目）でカテゴリフィルタリング、`scope :text_search`（55行目）でテキスト検索が実装されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | accounts_controller.rb | `app/controllers/entities/accounts_controller.rb` | indexアクション（13-19行目）、filterアクション（116-122行目）を確認 |
| 2-2 | entities_controller.rb | `app/controllers/entities_controller.rb` | 基底クラスの共通処理、get_list_of_recordsメソッド（138-178行目）を確認 |
| 2-3 | routes.rb | `config/routes.rb` | 取引先関連のルーティング（44-62行目）を確認 |

**主要処理フロー**:
1. **13-19行目**: `index` - 取引先一覧のメイン処理
2. **14行目**: `get_accounts` - 取引先の取得（`get_list_of_records`のエイリアス）
3. **116-122行目**: `filter` - カテゴリフィルター適用
4. **103-112行目**: `redraw` - 表示設定変更後の再描画

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/accounts/index.html.haml` | 取引先一覧のメイン構造を確認 |
| 3-2 | _account.html.haml | `app/views/accounts/_account.html.haml` | 取引先アイテムの表示を確認 |
| 3-3 | _search.html.haml | `app/views/accounts/_search.html.haml` | 検索フォームの構造を確認 |

**主要処理フロー**:
- **1行目**: スタイルの読み込み
- **3行目**: タイトルバーのレンダリング
- **5行目**: 新規作成フォーム領域
- **7行目**: 検索フォームのレンダリング
- **9行目**: オプション領域
- **11-15行目**: 取引先一覧の表示
- **17行目**: ページネーション
- **18行目**: エクスポートリンク

### プログラム呼び出し階層図

```
ブラウザ (GET /accounts)
    │
    ├─ routes.rb (resources :accounts)
    │
    └─ AccountsController#index
           │
           ├─ EntitiesController (継承)
           │      └─ get_list_of_records
           │             ├─ ransack_search.result
           │             ├─ scope :state (フィルター)
           │             ├─ scope :text_search (検索)
           │             └─ paginate
           │
           ├─ get_data_for_sidebar
           │      └─ カテゴリ別件数集計
           │
           └─ respond_with
                   │
                   ├─ format.html → index.html.haml
                   ├─ format.xls → index.xls.erb
                   └─ format.csv → CSV出力
```

### データフロー図

```
[入力]                    [処理]                    [出力]

query (検索)      ───▶  text_search スコープ
                            │
category (フィルター) ───▶  state スコープ
                            │
q (Ransack)       ───▶  ransack_search.result
                            │
page/per_page     ───▶  paginate
                            │
                            ▼
                    get_list_of_records
                            │
                            ▼
                    AccountsController#index
                            │
                   ┌────────┼────────┐
                   ▼        ▼        ▼
             [HTML]    [XLS]    [CSV]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| accounts_controller.rb | `app/controllers/entities/accounts_controller.rb` | コントローラー | 取引先一覧処理の制御 |
| entities_controller.rb | `app/controllers/entities_controller.rb` | コントローラー | 共通処理の基底クラス |
| index.html.haml | `app/views/accounts/index.html.haml` | テンプレート | 取引先一覧の表示 |
| _account.html.haml | `app/views/accounts/_account.html.haml` | テンプレート | 取引先アイテムの表示 |
| _search.html.haml | `app/views/accounts/_search.html.haml` | テンプレート | 検索フォーム |
| account.rb | `app/models/entities/account.rb` | モデル | 取引先モデル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| fat_free_crm.en-US.yml | `config/locales/fat_free_crm.en-US.yml` | 設定 | 国際化メッセージ定義 |
