# 画面設計書 8-取引先詳細画面

## 概要

本ドキュメントは、Fat Free CRMの取引先詳細画面の設計仕様を記述したものです。

### 本画面の処理概要

取引先（Account）の詳細情報、関連する連絡先、商談、タスク、コメント、タイムラインを表示する画面です。取引先の編集、削除、購読/購読解除、商談作成なども可能です。

**業務上の目的・背景**：本画面は、特定の取引先に関するすべての情報を一元的に確認できるハブとして機能します。営業担当者は、取引先の基本情報だけでなく、関連する連絡先一覧、進行中の商談、割り当てられたタスク、過去のやり取り（コメント・メール）をタイムライン形式で把握できます。これにより、顧客との関係性を深く理解し、適切なアクションを取ることができます。

**画面へのアクセス方法**：取引先一覧画面から取引先名をクリック、またはURL `/accounts/:id` にアクセスします。

**主要な操作・処理内容**：
1. 取引先の詳細情報を確認する
2. 取引先情報を編集する
3. 取引先を削除する
4. 取引先の変更通知を購読/購読解除する
5. 関連する連絡先を確認・追加・削除する
6. 関連する商談を確認・追加・削除する
7. 関連するタスクを確認・追加する
8. コメントを追加する
9. タイムライン（コメント・メール）を確認する
10. 変更履歴を確認する

**画面遷移**：
- この画面に遷移してくる画面: 取引先一覧画面、ダッシュボード、連絡先詳細画面、商談詳細画面
- この画面から遷移できる画面: 取引先編集フォーム、連絡先詳細画面、商談詳細画面、商談新規作成フォーム、取引先一覧画面（削除後）

**権限による表示制御**：
- 認証済みユーザーのみがアクセス可能
- 閲覧権限のある取引先のみ表示
- 編集・削除ボタンは権限に応じて表示制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 取引先詳細表示 | 主機能 | 取引先詳細情報、関連商談、タイムライン表示 |
| 42 | コメント一覧表示 | 補助機能 | 取引先に紐付くコメント表示 |
| 43 | コメント作成 | 補助機能 | 取引先へのコメント追加 |
| 86 | 購読/購読解除 | 補助機能 | 取引先の変更通知購読/解除 |
| 8 | 取引先削除 | 遷移先機能 | 詳細画面からの取引先削除 |
| 85 | バージョン履歴 | 補助機能 | 取引先の変更履歴追跡 |
| 30 | 商談作成 | 遷移先機能 | 取引先画面からの商談作成 |

## 画面種別

詳細

## URL/ルーティング

| メソッド | URL | アクション |
|----------|-----|----------|
| GET | `/accounts/:id` | accounts#show |
| GET | `/accounts/:id/edit` | accounts#edit (AJAX) |
| PUT/PATCH | `/accounts/:id` | accounts#update (AJAX) |
| DELETE | `/accounts/:id` | accounts#destroy |
| PUT | `/accounts/:id/attach` | accounts#attach (AJAX) |
| POST | `/accounts/:id/discard` | accounts#discard (AJAX) |
| POST | `/accounts/:id/subscribe` | accounts#subscribe (AJAX) |
| POST | `/accounts/:id/unsubscribe` | accounts#unsubscribe (AJAX) |
| GET | `/accounts/:id/contacts` | accounts#contacts (AJAX) |
| GET | `/accounts/:id/opportunities` | accounts#opportunities (AJAX) |

## 入出力項目

本画面は主に表示画面のため、入力項目は限定的です。

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 説明 |
|--------|--------|----------|---------|------|------|
| コメント本文 | comment[comment] | 入力 | Text | - | 新規コメント入力 |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|---------|------|
| 取引先名 | 常時 | 取引先の名前 |
| カテゴリ | 常時 | 取引先のカテゴリ |
| 担当者 | 常時 | 割り当てられたユーザー |
| 評価（Rating） | 常時 | 取引先の評価（星表示） |
| 連絡先情報 | 常時 | 電話、FAX、メール、ウェブサイト |
| 住所（請求先・配送先） | 常時 | 住所情報 |
| 背景情報 | Setting.background_info含む場合 | 取引先の背景情報 |
| タグ | 常時 | 付与されたタグ |
| 関連連絡先一覧 | 常時 | 関連する連絡先のリスト |
| 関連商談一覧 | 常時 | 関連する商談のリスト |
| 関連タスク一覧 | 常時 | 関連するタスクのリスト |
| タイムライン | 常時 | コメント・メールの時系列リスト |
| 変更履歴 | 常時 | バージョン履歴 |
| 編集ボタン | 編集権限あり | 取引先編集フォームを開く |
| 削除ボタン | 削除権限あり | 取引先を削除する |
| 購読/購読解除ボタン | 常時 | 変更通知の購読状態を切り替え |

## イベント仕様

### 1-編集ボタン押下

**トリガー**: 「Edit」ボタンのクリック

**処理フロー**:
1. AJAXリクエストで `/accounts/:id/edit` が呼び出される
2. `AccountsController#edit` が実行される
3. 編集フォームがインラインで表示される

### 2-削除ボタン押下

**トリガー**: 「Delete」ボタンのクリック

**処理フロー**:
1. 確認ダイアログを表示
2. 確認後、DELETEリクエストで `/accounts/:id` を呼び出す
3. `AccountsController#destroy` が実行される
4. 取引先を論理削除
5. 取引先一覧画面にリダイレクト

### 3-コメント追加

**トリガー**: コメントフォームの送信

**処理フロー**:
1. AJAXリクエストで `/comments` がPOSTされる
2. `CommentsController#create` が実行される
3. コメントをデータベースに保存
4. タイムラインを再描画

### 4-購読/購読解除

**トリガー**: 「Subscribe」/「Unsubscribe」ボタンのクリック

**処理フロー**:
1. AJAXリクエストで `/accounts/:id/subscribe` または `/accounts/:id/unsubscribe` がPOSTされる
2. `AccountsController#subscribe` または `AccountsController#unsubscribe` が実行される
3. `subscribed_users` を更新
4. ボタンの表示を切り替え

### 5-連絡先/商談の紐付け（Attach）

**トリガー**: 連絡先/商談選択後の「Attach」操作

**処理フロー**:
1. AJAXリクエストで `/accounts/:id/attach` がPUTされる
2. `AccountsController#attach` が実行される
3. 中間テーブル（account_contacts/account_opportunities）にレコード追加
4. 関連リストを再描画

### 6-連絡先/商談の紐付け解除（Discard）

**トリガー**: 連絡先/商談の「Discard」操作

**処理フロー**:
1. AJAXリクエストで `/accounts/:id/discard` がPOSTされる
2. `AccountsController#discard` が実行される
3. 中間テーブルからレコード削除
4. 関連リストを再描画

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | accounts | UPDATE | deleted_atの設定（論理削除） |
| コメント追加 | comments | INSERT | コメントレコードの作成 |
| 購読/購読解除 | accounts | UPDATE | subscribed_usersの更新 |
| 連絡先紐付け | account_contacts | INSERT | 中間テーブルへのレコード追加 |
| 連絡先紐付け解除 | account_contacts | DELETE | 中間テーブルからのレコード削除 |
| 商談紐付け | account_opportunities | INSERT | 中間テーブルへのレコード追加 |
| 商談紐付け解除 | account_opportunities | DELETE | 中間テーブルからのレコード削除 |

### テーブル別更新項目詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | current_user.id | コメント作成者 |
| INSERT | commentable_type | 'Account' | ポリモーフィック関連 |
| INSERT | commentable_id | 取引先ID | 関連取引先 |
| INSERT | comment | 入力値 | コメント本文 |
| INSERT | state | 'Expanded' | 初期表示状態 |

#### accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | subscribed_users | ユーザーIDの配列 | シリアライズして保存 |
| UPDATE | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|---------|
| account_summary | タイトル | Account Summary | サマリーセクション |
| msg_asset_deleted | 成功 | %{value} has been deleted. | 削除成功時 |
| msg_asset_not_available | エラー | This %{value} is no longer available. | 取引先が見つからない場合 |
| add_note | ボタン | Add Comment | コメント追加ボタン |
| subscribe_via_email | リンク | Subscribe via email | 購読リンク |
| disable_email_subscriptions | リンク | Disable email subscription | 購読解除リンク |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| 未認証アクセス | ログイン画面にリダイレクト | ログイン画面 |
| 取引先が存在しない | エラーメッセージ表示 | 取引先一覧画面 |
| 権限不足 | アクセス拒否メッセージ表示 | 前の画面 |

## 備考

- タイムラインはコメントとメールを作成日時降順でマージして表示
- PaperTrailによる変更履歴追跡が有効
- カスタムフィールドがある場合、フィールドグループ単位で表示
- タブ付きレイアウト（`_tabbed.html.haml`）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、取引先詳細に関わるデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | account.rb | `app/models/entities/account.rb` | Accountモデルの関連（contacts, opportunities, tasks, comments, emails）を確認 |
| 1-2 | schema.rb | `db/schema.rb` | accountsテーブル、中間テーブル（account_contacts, account_opportunities）の構造を確認 |

**読解のコツ**: Accountモデルの33-42行目で関連定義が確認できます。`has_many :account_contacts`、`has_many :contacts, through: :account_contacts`で連絡先との多対多関連が実装されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | accounts_controller.rb | `app/controllers/entities/accounts_controller.rb` | showアクション（25-30行目）を確認 |
| 2-2 | entities_controller.rb | `app/controllers/entities_controller.rb` | attach/discard/subscribe/unsubscribeアクション、timelineメソッドを確認 |
| 2-3 | routes.rb | `config/routes.rb` | 取引先詳細関連のルーティングを確認 |

**主要処理フロー**:
1. **25-30行目**: `show` - 取引先詳細のメイン処理
2. **26行目**: `@stage` - 商談ステージ設定の取得
3. **27行目**: `@comment` - 新規コメント用オブジェクト
4. **28行目**: `@timeline` - タイムラインデータの取得

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/accounts/show.html.haml` | 取引先詳細のメイン構造を確認 |
| 3-2 | _sidebar_show.html.haml | `app/views/accounts/_sidebar_show.html.haml` | サイドバー（詳細情報）の表示を確認 |
| 3-3 | _title_bar.html.haml | `app/views/accounts/_title_bar.html.haml` | タイトルバーの表示を確認 |

**主要処理フロー**:
- **9行目**: タイトルバーのレンダリング
- **10行目**: サイドバー（詳細情報）のレンダリング
- **14行目**: コメントフォームのレンダリング
- **15行目**: タイムラインのレンダリング
- **19行目**: タスク一覧のレンダリング
- **21行目**: 連絡先一覧のレンダリング
- **23行目**: 商談一覧のレンダリング
- **25行目**: バージョン履歴のレンダリング

### プログラム呼び出し階層図

```
ブラウザ (GET /accounts/:id)
    │
    ├─ routes.rb (resources :accounts)
    │
    └─ AccountsController#show
           │
           ├─ load_and_authorize_resource
           │      └─ @account = Account.find(params[:id])
           │
           ├─ Setting.unroll(:opportunity_stage)
           │
           ├─ Comment.new
           │
           ├─ timeline(@account)
           │      └─ (comments + emails).sort
           │
           └─ respond_with(@account)
                   │
                   └─ show.html.haml
                          │
                          ├─ _title_bar.html.haml
                          ├─ _sidebar_show.html.haml
                          ├─ comments/_new.html.haml
                          ├─ shared/_timeline.html.haml
                          ├─ tasks/_tasks.html.haml
                          ├─ contacts/_contacts.html.haml
                          ├─ opportunities/_opportunities.html.haml
                          └─ versions/_versions.html.haml
```

### データフロー図

```
[データソース]                [処理]                    [出力]

accounts テーブル     ───▶  Account.find(:id)
                              │
account_contacts    ───▶  @account.contacts
                              │
account_opportunities ───▶  @account.opportunities
                              │
tasks テーブル        ───▶  @account.tasks
                              │
comments テーブル     ───▶  @account.comments
                              │
emails テーブル       ───▶  @account.emails
                              │
                              ▼
                    AccountsController#show
                              │
                              ▼
                        show.html.haml
                              │
                              ▼
                        [取引先詳細画面]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| accounts_controller.rb | `app/controllers/entities/accounts_controller.rb` | コントローラー | 取引先詳細処理の制御 |
| entities_controller.rb | `app/controllers/entities_controller.rb` | コントローラー | 共通処理（attach/discard等） |
| show.html.haml | `app/views/accounts/show.html.haml` | テンプレート | 取引先詳細の表示 |
| _sidebar_show.html.haml | `app/views/accounts/_sidebar_show.html.haml` | テンプレート | サイドバー（詳細情報）の表示 |
| _title_bar.html.haml | `app/views/accounts/_title_bar.html.haml` | テンプレート | タイトルバーの表示 |
| account.rb | `app/models/entities/account.rb` | モデル | 取引先モデル |
| comment.rb | `app/models/polymorphic/comment.rb` | モデル | コメントモデル |
| routes.rb | `config/routes.rb` | 設定 | ルーティング定義 |
| fat_free_crm.en-US.yml | `config/locales/fat_free_crm.en-US.yml` | 設定 | 国際化メッセージ定義 |
