---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-ログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **セッションタイムアウト設定**：具体的な設定値の根拠なし
  2. **初回ログイン時のウェルカムメッセージ**：表示ロジックの実装箇所未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/devise/sessions/new.html.haml`
- E-02: `app/controllers/sessions_controller.rb`
- E-03: `app/models/users/user.rb`
- E-04: `config/routes.rb`
- E-05: `config/locales/fat_free_crm.en-US.yml`
- E-06: `db/schema.rb`
- E-07: `app/views/layouts/application.html.haml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/users/sign_in`である | E-04 (17-20行目) | ○ |
| C-02 | `/login`から`/users/sign_in`にリダイレクトされる | E-04 (14行目) | ○ |
| C-03 | メールアドレスまたはユーザー名でログイン可能 | E-03 (206-211行目) | ○ |
| C-04 | Remember Me機能が存在する | E-01 (27行目), E-03 (49-50行目) | ○ |
| C-05 | 新規登録リンクの表示条件は`User.can_signup?` | E-01 (15-18行目), E-03 (200-202行目) | ○ |
| C-06 | パスワードリセットリンクが存在する | E-01 (31行目) | ○ |
| C-07 | 認証成功時にダッシュボードにリダイレクトされる | E-04 (11行目) | ○ |
| C-08 | ユーザー検索は大文字小文字を区別しない | E-03 (209行目) | ○ |
| C-09 | `active_for_authentication?`でアクティブ状態を確認 | E-03 (120-122行目) | ○ |
| C-10 | 停止アカウントはログイン不可 | E-03 (121行目) | ○ |
| C-11 | 未承認アカウントはログイン不可 | E-03 (117-118行目, 121行目) | ○ |
| C-12 | usersテーブルに`sign_in_count`カラムが存在 | E-06, E-03 (31行目) | ○ |
| C-13 | usersテーブルに`current_sign_in_at`カラムが存在 | E-06, E-03 (27行目) | ○ |
| C-14 | usersテーブルに`last_sign_in_at`カラムが存在 | E-06, E-03 (27行目) | ○ |
| C-15 | Deviseの`database_authenticatable`を使用 | E-03 (49行目) | ○ |
| C-16 | Deviseの`rememberable`を使用 | E-03 (50行目) | ○ |
| C-17 | Deviseの`trackable`を使用 | E-03 (50行目) | ○ |
| C-18 | SessionsControllerがDevise::SessionsControllerを継承 | E-02 (8行目) | ○ |
| C-19 | ログアウト後に`new_user_session_path`にリダイレクト | E-02 (12-14行目) | ○ |
| C-20 | エラーメッセージ`msg_invalig_login`が定義されている | E-05 (217行目) | ○ |
| C-21 | エラーメッセージ`msg_account_suspended`が定義されている | E-05 (194行目) | ○ |
| C-22 | エラーメッセージ`msg_account_not_approved`が定義されている | E-05 (201行目) | ○ |
| C-23 | `login`ラベルが定義されている | E-05 (317行目) | ○ |
| C-24 | `remember_me`ラベルが定義されている | E-05 (319行目) | ○ |
| C-25 | `forgot_password`ラベルが定義されている | E-05 (316行目) | ○ |
| C-26 | simple_form_forを使用してフォームを生成 | E-01 (14行目) | ○ |
| C-27 | セッションタイムアウトはRailsデフォルト | **根拠なし** | △ |
| C-28 | 初回ログイン時にウェルカムメッセージ表示 | E-05 (228行目) 定義あり、実装箇所未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- セッションタイムアウトの具体的な設定値
  - 候補：`config/initializers/devise.rb` / `config/initializers/session_store.rb` / Rails設定
- 初回ログイン時のウェルカムメッセージ表示ロジック
  - 候補：Devise::SessionsController / ApplicationController / Flashメッセージ処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング情報（コードから明確に確認可能）
- 0: 低リスク - 入出力項目（テンプレートから確認可能）
- 0: 低リスク - データベース更新項目（Deviseの標準動作）
- 1: 中リスク - セッションタイムアウト設定（デフォルト値の確認が必要）
- 1: 中リスク - メッセージ表示条件（実装との整合性要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] `/users/sign_in`でログイン画面が表示されることを確認
- [ ] `/login`から`/users/sign_in`へのリダイレクトを確認
- [ ] メールアドレスとユーザー名の両方でログイン可能であることを確認
- [ ] Remember Me機能の動作を確認
- [ ] 新規登録リンクの表示条件を確認（Setting.user_signup設定）
- [ ] 停止・未承認アカウントのログイン拒否を確認
- [ ] エラーメッセージの表示を確認
