---
generated_at: 2026-01-13 11:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：10-取引先編集フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **カスタムフィールドの編集ロジック**：edit_custom_field_groupの詳細動作確認が必要
  2. **compound_address設定**：住所入力形式の切り替えロジックの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/accounts/_edit.html.haml`
- E-02: `app/views/accounts/_top_section.html.haml`
- E-03: `app/views/accounts/_contact_info.html.haml`
- E-04: `app/controllers/entities/accounts_controller.rb`
- E-05: `app/controllers/entities_controller.rb`
- E-06: `app/models/entities/account.rb`
- E-07: `config/routes.rb`
- E-08: `config/locales/fat_free_crm.en-US.yml`
- E-09: `db/schema.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLが`/accounts/:id/edit`である | E-07 (44行目) | ○ |
| C-02 | editアクションが存在する | E-04 (47-51行目) | ○ |
| C-03 | updateアクションが存在する | E-04 (70-76行目) | ○ |
| C-04 | フォームがremote: trueでAJAX送信 | E-01 (2行目) | ○ |
| C-05 | hidden_fieldでuser_idを保持 | E-01 (4行目) | ○ |
| C-06 | link_to_closeが存在する | E-01 (3行目) | ○ |
| C-07 | 取引先名が必須 | E-06 (76行目: validates_presence_of :name) | ○ |
| C-08 | カテゴリバリデーションが存在する | E-06 (77-79行目) | ○ |
| C-09 | 評価が0-5の範囲 | E-06 (80行目) | ○ |
| C-10 | simple_form_forでフォーム生成 | E-01 (2行目) | ○ |
| C-11 | top_sectionパーシャルがedit: trueで呼ばれる | E-01 (8行目) | ○ |
| C-12 | contact_infoパーシャルがedit: trueで呼ばれる | E-01 (10行目) | ○ |
| C-13 | permissionsパーシャルが呼ばれる | E-01 (12行目) | ○ |
| C-14 | edit_custom_field_groupパーシャルが呼ばれる | E-01 (9行目) | ○ |
| C-15 | addressesのnested_attributesが定義 | E-06 (46行目) | ○ |
| C-16 | アクセス権限を先に設定する | E-04 (73行目) | ○ |
| C-17 | サイドバーデータを更新する | E-04 (74行目: get_data_for_sidebar) | ○ |
| C-18 | detect_previous_idで前レコード検出 | E-04 (48行目) | ○ |
| C-19 | accountsテーブルにnameカラムが存在 | E-09 (35行目) | ○ |
| C-20 | accountsテーブルにcategoryカラムが存在 | E-09 (47行目) | ○ |
| C-21 | accountsテーブルにratingカラムが存在 | E-09 (46行目) | ○ |
| C-22 | accountsテーブルにphoneカラムが存在 | E-09 (39行目) | ○ |
| C-23 | accountsテーブルにwebsiteカラムが存在 | E-09 (37行目) | ○ |
| C-24 | addressesテーブルがポリモーフィック | E-09 (76-77行目: addressable_type, addressable_id) | ○ |
| C-25 | versionsテーブルが存在 | E-09 (356-367行目) | ○ |
| C-26 | one_submit_onlyで二重送信防止 | E-01 (2行目) | ○ |
| C-27 | メッセージ`save_account`が定義されている | E-08 (336行目) | ○ |
| C-28 | メッセージ`missing_account_name`が定義されている | E-08 (354行目) | ○ |
| C-29 | メッセージ`share_account`が定義されている | E-08 (352行目) | ○ |
| C-30 | Setting.compound_addressによる表示分岐 | E-01 (16-19行目) | ○ |
| C-31 | カスタムフィールドの編集用パーシャル | E-01 (9行目) - 詳細ロジック未確認 | △ |
| C-32 | PaperTrailによるバージョン履歴記録 | E-06 (68行目) - 更新時の動作未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- edit_custom_field_groupパーシャルの詳細動作
  - 候補：`app/views/fields/_edit_custom_field_group.html.haml`
- PaperTrailの更新時バージョン記録の詳細
  - 候補：`app/models/concerns/` / PaperTrail gem設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - URL/ルーティング情報（コードから明確に確認可能）
- 0: 低リスク - バリデーション定義（モデルから確認可能）
- 0: 低リスク - フォーム構造（テンプレートから確認可能）
- 0: 低リスク - データベース構造（スキーマから確認可能）
- 0: 低リスク - アクセス権限の先行設定（コントローラーから確認可能）
- 1: 中リスク - カスタムフィールド編集（実装詳細の確認が必要）
- 1: 中リスク - バージョン履歴記録（PaperTrailの動作確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 取引先詳細画面から編集フォームが開くことを確認
- [ ] 既存データがフォームにプリセットされていることを確認
- [ ] 取引先名を空にして保存ボタンを押すとエラーが表示されることを確認
- [ ] 各フィールドを変更して保存できることを確認
- [ ] カテゴリ変更が正しく保存されることを確認
- [ ] 評価変更が正しく保存されることを確認
- [ ] タグ変更が正しく保存されることを確認
- [ ] 住所（請求先・配送先）の変更が正しく保存されることを確認
- [ ] アクセス権限変更が正しく動作することを確認
- [ ] キャンセルリンクでフォームが閉じることを確認
- [ ] 閉じるリンクでフォームが閉じることを確認
- [ ] 編集後にバージョン履歴が記録されることを確認
