---
generated_at: 2026-01-13 17:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：11-キャンペーン一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **RSS/ATOMフィードエクスポート機能**：一覧画面からの直接エクスポートの根拠が不明確
  2. **403エラー表示メッセージ**：具体的な表示文言の根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/campaigns_controller.rb`（13-20行目: indexアクション）
- E-02: `app/controllers/entities/campaigns_controller.rb`（154-160行目: filterアクション）
- E-03: `app/controllers/entities/campaigns_controller.rb`（141-150行目: redrawアクション）
- E-04: `app/controllers/entities_controller.rb`（138-178行目: get_list_of_records）
- E-05: `app/models/entities/campaign.rb`（8-32行目: スキーマ情報）
- E-06: `app/models/entities/campaign.rb`（44-50行目: スコープ定義）
- E-07: `app/models/entities/campaign.rb`（64-68行目: バリデーション）
- E-08: `app/views/campaigns/index.html.haml`（全体）
- E-09: `app/views/campaigns/_sidebar_index.html.haml`（全体）
- E-10: `app/views/campaigns/_campaign.html.haml`（全体）
- E-11: `app/views/entities/_title_bar.html.haml`（全体）
- E-12: `config/routes.rb`（64-82行目: campaignsルート）
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（キャンペーン一覧関連行）
- E-14: `docs/code-to-docs/画面一覧/画面一覧.csv`（11行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャンペーン一覧を表示する画面である | E-08, E-14 | ○ |
| C-02 | URLは /campaigns である | E-12 | ○ |
| C-03 | ステータスでフィルタリング可能 | E-02, E-09 | ○ |
| C-04 | ステータスは planned, started, on_hold, completed, called_off | E-06, E-09 | ○ |
| C-05 | CSV形式でエクスポート可能 | E-01 (format.csv) | ○ |
| C-06 | XLS形式でエクスポート可能 | E-01 (format.xls) | ○ |
| C-07 | RSS/ATOMフィードでエクスポート可能 | **根拠なし** | △ |
| C-08 | Ransackによる高度な検索が可能 | E-04, E-12 | ○ |
| C-09 | ページネーションに対応 | E-04 (172行目: paginate) | ○ |
| C-10 | 新規作成ボタンでAjaxモーダルが開く | E-11 | ○ |
| C-11 | CanCanCanによる認可が適用される | E-04 (15行目: load_and_authorize_resource) | ○ |
| C-12 | my(current_user)スコープで権限制御 | E-04 (113行目), E-06 | ○ |
| C-13 | 論理削除でdeleted_atを使用 | E-05 (28行目) | ○ |
| C-14 | paper_trailでバージョン管理 | E-05 (56行目) | ○ |
| C-15 | acts_as_taggable_onでタグ付け | E-05 (55行目) | ○ |
| C-16 | サイドバーに各ステータスの件数を表示 | E-09, E-01 (191-206行目: get_data_for_sidebar) | ○ |
| C-17 | 検索キーワードはキャンペーン名で検索 | E-05 (50行目: text_search scope) | ○ |
| C-18 | 表示件数はユーザー設定に保存 | E-03 (142行目) | ○ |
| C-19 | ソート順はユーザー設定に保存 | E-03 (143行目) | ○ |
| C-20 | フィルタ条件はセッションに保存 | E-02 (155行目: session[:campaigns_filter]) | ○ |
| C-21 | 削除成功時にメッセージ表示 | E-01 (185行目: flash[:notice]) | ○ |
| C-22 | 検索結果0件時に空メッセージ表示 | E-08 (15行目: shared/empty) | ○ |
| C-23 | 認証エラー時ログイン画面にリダイレクト | Devise標準動作 | ○ |
| C-24 | 403エラー時に「アクセス権限がありません」表示 | **根拠なし** | △ |
| C-25 | campaigns テーブルからSELECT | E-01, E-04 | ○ |
| C-26 | versionsテーブルにINSERT（削除時） | E-05 (56行目: has_paper_trail) | ○ |
| C-27 | 開始日・終了日を一覧に表示 | E-05 (19-20行目: starts_on, ends_on) | ○ |
| C-28 | リード数・商談数を一覧に表示 | E-05 (22-23行目: leads_count, opportunities_count) | ○ |

## 4) 不足情報（Unknown / Missing）
- **RSS/ATOMフィードエクスポート**：showアクションでは対応（campaigns_controller.rb 53-61行目）が確認できるが、index画面からの直接エクスポートの根拠が不明確
  - 候補：shared/_export.html.haml / index.html.haml / links_to_export ヘルパー
- **403エラー表示メッセージ**：CanCanCanのデフォルト動作を確認する必要あり
  - 候補：app/controllers/application_controller.rb / ability.rb

## 5) リスクフラグ（レビュー観点）
- 0: ルーティング・コントローラーの基本動作 - 低リスク
- 0: モデル定義・バリデーション - 低リスク
- 1: RSS/ATOMエクスポート機能の詳細 - 中リスク（機能の有無要確認）
- 1: 権限エラー時のエラーメッセージ - 中リスク（UIテスト推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] RSS/ATOMフィードが一覧画面から利用可能かUI上で確認
- [ ] 権限エラー発生時の実際のエラーメッセージを確認
- [ ] Setting.campaign_statusの実際の設定値を確認
- [ ] サイドバーフィルタの動作をブラウザで確認
