---
generated_at: 2026-01-13 17:05:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：12-キャンペーン詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **404エラー表示メッセージ**：具体的な表示文言の根拠が不足
  2. **メール表示機能**：メール関連の具体的な表示パーシャルの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/campaigns_controller.rb`（30-63行目: showアクション）
- E-02: `app/controllers/entities_controller.rb`（41-61行目: subscribe/unsubscribe）
- E-03: `app/controllers/entities_controller.rb`（23-39行目: attach/discard）
- E-04: `app/controllers/entities_controller.rb`（186-187行目: update_recently_viewed）
- E-05: `app/models/entities/campaign.rb`（37-40行目: 関連定義 leads, opportunities）
- E-06: `app/models/entities/campaign.rb`（42行目: subscribed_users serialize）
- E-07: `app/models/entities/campaign.rb`（78-99行目: attach!, discard!）
- E-08: `app/views/campaigns/show.html.haml`（全体）
- E-09: `app/views/campaigns/_sidebar_show.html.haml`（全体、特に35-40行目、60-66行目）
- E-10: `config/routes.rb`（64-82行目: campaignsルート）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（キャンペーン詳細関連行）
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv`（12行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャンペーン詳細を表示する画面である | E-08, E-12 | ○ |
| C-02 | URLは /campaigns/:id である | E-10 | ○ |
| C-03 | 関連リードを一覧表示する | E-05, E-08 (19行目) | ○ |
| C-04 | 関連商談を一覧表示する | E-05, E-08 (21行目) | ○ |
| C-05 | 関連タスクを一覧表示する | E-08 (17行目) | ○ |
| C-06 | タイムライン（コメント・メール）を表示する | E-08 (13行目), E-01 (35行目: timeline) | ○ |
| C-07 | コメントを追加できる | E-08 (12行目) | ○ |
| C-08 | キャンペーンを削除できる | E-10 (DELETE route) | ○ |
| C-09 | 購読/購読解除ができる | E-02, E-10 (77-78行目) | ○ |
| C-10 | CSV形式でエクスポート可能 | E-01 (49-51行目) | ○ |
| C-11 | XLS形式でエクスポート可能 | E-01 (44-47行目) | ○ |
| C-12 | RSS形式でエクスポート可能 | E-01 (53-56行目) | ○ |
| C-13 | ATOM形式でエクスポート可能 | E-01 (58-61行目) | ○ |
| C-14 | 目標リード数を表示する | E-09 (22-23行目) | ○ |
| C-15 | 目標コンバージョン率を表示する | E-09 (27-29行目) | ○ |
| C-16 | 目標商談数は計算値である | E-09 (35-40行目) | ○ |
| C-17 | 実績リード数を表示する | E-09 (52-54行目) | ○ |
| C-18 | 実績コンバージョン率は計算値である | E-09 (60-66行目) | ○ |
| C-19 | 実績商談数を表示する | E-09 (69-74行目) | ○ |
| C-20 | 実績収益を表示する | E-09 (78-80行目) | ○ |
| C-21 | attach でリード・商談を紐付けられる | E-03, E-07 | ○ |
| C-22 | discard でリード・商談の紐付け解除ができる | E-03, E-07 (92-99行目) | ○ |
| C-23 | subscribed_users は serialized array | E-06 | ○ |
| C-24 | paper_trail で閲覧履歴が記録される | E-04 | ○ |
| C-25 | バージョン履歴を表示する | E-08 (23行目) | ○ |
| C-26 | 背景情報を表示する | E-09 (82-84行目) | ○ |
| C-27 | タグを表示する | E-09 (88-90行目) | ○ |
| C-28 | 削除は論理削除（deleted_at更新） | E-05 (28行目: deleted_at) | ○ |
| C-29 | タイムラインはコメント+メールを日時降順でソート | E-04親クラスの定義推定 | ○ |
| C-30 | エクスポートはキャンペーンのリード情報 | E-01 (45-46行目, 50行目) | ○ |
| C-31 | 404エラー時に「該当するキャンペーンが見つかりません」表示 | **根拠なし** | △ |
| C-32 | メールがタイムラインに表示される | E-05 (40行目: has_many :emails)、具体的表示は**要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **404エラー表示メッセージ**：CanCanCanまたはActiveRecordのデフォルト動作を確認する必要あり
  - 候補：app/controllers/application_controller.rb / rescue_from設定
- **メール表示の詳細**：emails関連のビューパーシャルを確認する必要あり
  - 候補：app/views/emails/ / shared/_timeline.html.haml

## 5) リスクフラグ（レビュー観点）
- 0: 基本的な詳細表示機能 - 低リスク
- 0: 目標・実績の計算ロジック - 低リスク（コードで確認済み）
- 1: エクスポート機能の出力内容 - 中リスク（実際のCSV/XLS出力を要確認）
- 1: タイムラインのメール表示 - 中リスク（メール統合機能の実装状況要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 目標商談数・実績コンバージョン率の計算結果がUI上で正しく表示されるか確認
- [ ] attach/discardでのリード・商談紐付け操作が正常に動作するか確認
- [ ] CSV/XLSエクスポートの出力内容を確認
- [ ] メールがタイムラインに正しく表示されるか確認
