---
generated_at: 2026-01-13 17:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：13-キャンペーン新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **エラーメッセージの日本語化**：I18n翻訳ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/campaigns_controller.rb`（69-82行目: newアクション）
- E-02: `app/controllers/entities/campaigns_controller.rb`（94-104行目: createアクション）
- E-03: `app/models/entities/campaign.rb`（64-68行目: バリデーション）
- E-04: `app/models/entities/campaign.rb`（105-107行目: start_and_end_dates）
- E-05: `app/models/entities/campaign.rb`（111-113行目: users_for_shared_access）
- E-06: `app/views/campaigns/_new.html.haml`（全体）
- E-07: `app/views/campaigns/_top_section.html.haml`（全体）
- E-08: `app/views/campaigns/_objectives.html.haml`（全体）
- E-09: `config/routes.rb`（64-82行目: campaignsルート）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（キャンペーン新規作成関連行）
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv`（13行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規作成フォームがAjaxモーダルで表示される | E-06 (remote: true) | ○ |
| C-02 | URLは GET /campaigns/new である | E-09 | ○ |
| C-03 | POSTは /campaigns に送信される | E-09, E-06 | ○ |
| C-04 | キャンペーン名は必須である | E-03 (validates_presence_of :name) | ○ |
| C-05 | キャンペーン名の最大長は64文字 | E-03 (スキーマ: string(64)) | ○ |
| C-06 | 開始日・終了日が入力可能 | E-07 (10-15行目) | ○ |
| C-07 | 終了日は開始日より後でなければならない | E-04 | ○ |
| C-08 | ステータスのデフォルトは planned | E-07 (19行目: selected: planned) | ○ |
| C-09 | 背景情報は設定により表示/非表示 | E-07 (21行目: if Setting.background_info) | ○ |
| C-10 | タグを入力できる | E-07 (27行目: shared/_tags) | ○ |
| C-11 | 目標リード数を入力できる | E-08 (14行目) | ○ |
| C-12 | 目標コンバージョン率を入力できる | E-08 (18行目) | ○ |
| C-13 | 目標収益を入力できる | E-08 (22行目) | ○ |
| C-14 | 予算を入力できる | E-08 (26行目) | ○ |
| C-15 | カスタムフィールドを入力できる | E-06 (8行目: fields/_edit_custom_field_group) | ○ |
| C-16 | コメントを追加できる | E-06 (9行目: shared/_add_comment) | ○ |
| C-17 | アクセス権限を設定できる | E-06 (12行目: entities/_permissions) | ○ |
| C-18 | デフォルトのアクセス権限は Setting.default_access | E-01 (70行目) | ○ |
| C-19 | Shared選択時に共有先を選択できる | entities/_permissions（構造推定） | ○ |
| C-20 | 同名キャンペーンは重複不可 | E-03 (65行目: validates_uniqueness_of) | ○ |
| C-21 | simple_form_forを使用 | E-06 (1行目) | ○ |
| C-22 | one_submit_onlyでダブルサブミット防止 | E-06 (1行目: one_submit_only) | ○ |
| C-23 | 保存成功時にコメントが追加される | E-02 (99行目) | ○ |
| C-24 | フックポイントで拡張可能 | E-06 (13行目: hook(:entity_form)) | ○ |
| C-25 | 日付フィールドはautocomplete:off | E-07 (11,15行目) | ○ |
| C-26 | エラーメッセージが日本語で表示される | **I18nファイル要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **I18n翻訳ファイル**：エラーメッセージの具体的な日本語表示を確認する必要あり
  - 候補：config/locales/ja.yml / config/locales/fat_free_crm.ja.yml

## 5) リスクフラグ（レビュー観点）
- 0: フォーム構成・入力項目 - 低リスク
- 0: バリデーション定義 - 低リスク
- 0: Ajax送信・レスポンス処理 - 低リスク
- 1: エラーメッセージの翻訳 - 中リスク（実際の表示を要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 新規作成フォームが正しくモーダル表示されるか確認
- [ ] バリデーションエラー時のメッセージ表示を確認
- [ ] 日付ピッカーが正常に動作するか確認
- [ ] Shared選択時のユーザー/グループ選択が正常に動作するか確認
