---
generated_at: 2026-01-13 17:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-キャンペーン編集フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/campaigns_controller.rb`（85-90行目: editアクション）
- E-02: `app/controllers/entities/campaigns_controller.rb`（108-114行目: updateアクション）
- E-03: `app/models/entities/campaign.rb`（64-68行目: バリデーション）
- E-04: `app/views/campaigns/_edit.html.haml`（全体）
- E-05: `app/views/campaigns/_top_section.html.haml`（全体）
- E-06: `app/views/campaigns/_objectives.html.haml`（全体）
- E-07: `config/routes.rb`（64-82行目: campaignsルート）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（キャンペーン編集関連行）
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv`（14行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 編集フォームがAjaxモーダルで表示される | E-04 (remote: true) | ○ |
| C-02 | URLは GET /campaigns/:id/edit である | E-07 | ○ |
| C-03 | PUT/PATCHは /campaigns/:id に送信される | E-07, E-04 | ○ |
| C-04 | キャンペーン名は必須である | E-03 | ○ |
| C-05 | 既存値がプリセットされる | E-04 (simple_form_for @campaign) | ○ |
| C-06 | edit: true パラメータが渡される | E-04 (8-12行目) | ○ |
| C-07 | コメント追加セクションがない | E-04 (新規との比較) | ○ |
| C-08 | ボタンラベルは「Save Campaign」 | E-04 (16行目) | ○ |
| C-09 | access を最初に設定する | E-02 (111行目) | ○ |
| C-10 | 一覧から呼ばれた場合はサイドバー更新 | E-02 (112行目: called_from_index_page?) | ○ |
| C-11 | @previous で前のキャンペーンを取得 | E-01 (87行目) | ○ |
| C-12 | 閉じるリンクがある | E-04 (3行目: link_to_close) | ○ |
| C-13 | simple_form_forを使用 | E-04 (2行目) | ○ |
| C-14 | one_submit_onlyでダブルサブミット防止 | E-04 (2行目: one_submit_only) | ○ |
| C-15 | フックポイントで拡張可能 | E-04 (13行目: hook(:entity_form)) | ○ |
| C-16 | paper_trailで更新履歴が記録される | E-03 (56行目: has_paper_trail) | ○ |
| C-17 | タグを編集できる | E-05 (27行目) | ○ |
| C-18 | 目標値を編集できる | E-06 | ○ |
| C-19 | アクセス権限を変更できる | E-04 (12行目) | ○ |
| C-20 | .remote クラスでコンテナを定義 | E-04 (1行目) | ○ |
| C-21 | カスタムフィールドを編集できる | E-04 (9行目) | ○ |
| C-22 | フィールドグループを編集できる | E-04 (11行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: フォーム構成・入力項目 - 低リスク
- 0: 更新処理 - 低リスク
- 0: バージョン履歴記録 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 編集フォームに既存値が正しくプリセットされるか確認
- [ ] 更新成功時に詳細画面/一覧画面が正しく更新されるか確認
- [ ] 権限変更が正しく反映されるか確認
