---
generated_at: 2026-01-13 17:20:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：15-リード一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Setting.lead_status の具体的な値**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/leads_controller.rb`（14-21行目: indexアクション）
- E-02: `app/controllers/entities/leads_controller.rb`（186-194行目: filterアクション）
- E-03: `app/controllers/entities/leads_controller.rb`（164-183行目: redrawアクション）
- E-04: `app/controllers/entities_controller.rb`（138-178行目: get_list_of_records）
- E-05: `app/models/entities/lead.rb`（8-38行目: スキーマ情報）
- E-06: `app/models/entities/lead.rb`（54-62行目: スコープ定義）
- E-07: `app/models/entities/lead.rb`（76-79行目: バリデーション）
- E-08: `app/models/entities/lead.rb`（81-82行目: after_create/after_destroy コールバック）
- E-09: `app/views/leads/index.html.haml`（全体）
- E-10: `app/views/leads/_sidebar_index.html.haml`（全体）
- E-11: `app/views/leads/_lead.html.haml`（全体）
- E-12: `config/routes.rb`（103-123行目: leadsルート）
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（リード一覧関連行）
- E-14: `docs/code-to-docs/画面一覧/画面一覧.csv`（15行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リード一覧を表示する画面である | E-09, E-14 | ○ |
| C-02 | URLは /leads である | E-12 | ○ |
| C-03 | ステータスでフィルタリング可能 | E-02, E-10 | ○ |
| C-04 | ステータスは new, contacted, converted, rejected | E-06 (stateスコープ), **Setting要確認** | △ |
| C-05 | CSV形式でエクスポート可能 | E-01 (format.csv) | ○ |
| C-06 | XLS形式でエクスポート可能 | E-01 (format.xls) | ○ |
| C-07 | Ransackによる高度な検索が可能 | E-04, E-12 | ○ |
| C-08 | ページネーションに対応 | E-04 (172行目: paginate) | ○ |
| C-09 | 新規作成ボタンでAjaxモーダルが開く | E-09 (entities/_title_bar) | ○ |
| C-10 | テキスト検索は氏名・会社名・メールで行う | E-06 (62行目: text_search scope) | ○ |
| C-11 | 論理削除でdeleted_atを使用 | E-05 (34行目) | ○ |
| C-12 | paper_trailでバージョン管理 | E-05 (68行目) | ○ |
| C-13 | acts_as_taggable_onでタグ付け | E-05 (67行目) | ○ |
| C-14 | サイドバーに各ステータスの件数を表示 | E-10, E-01 (242-262行目: get_data_for_sidebar) | ○ |
| C-15 | 表示件数はユーザー設定に保存 | E-03 (165行目) | ○ |
| C-16 | ソート順はユーザー設定に保存 | E-03 (168-171行目) | ○ |
| C-17 | 名前表示順（naming）の設定がある | E-03 (172-175行目) | ○ |
| C-18 | フィルタ条件はセッションに保存 | E-02 (188行目: session[:leads_filter]) | ○ |
| C-19 | 削除時にキャンペーンのleads_countがデクリメントされる | E-08 (82行目: decrement_leads_count) | ○ |
| C-20 | リードとコンタクトでソート設定が同期可能 | E-03 (170-171, 174-175行目) | ○ |
| C-21 | 会社名オートコンプリートが使用可能 | E-12 (112行目: autocomplete_account_name) | ○ |
| C-22 | CanCanCanによる認可が適用される | E-04 (15行目: load_and_authorize_resource) | ○ |
| C-23 | my(current_user)スコープで権限制御 | E-04 (113行目) | ○ |
| C-24 | キャンペーンとの関連がある | E-05 (42行目: belongs_to :campaign) | ○ |
| C-25 | コンタクトへの変換関連がある | E-05 (44行目: has_one :contact) | ○ |
| C-26 | レーティングフィールドがある | E-05 (32-33行目) | ○ |
| C-27 | 削除成功時にメッセージ表示 | E-01 (236行目: flash[:notice]) | ○ |
| C-28 | 検索結果0件時に空メッセージ表示 | E-09 (15行目: shared/empty) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Setting.lead_status の具体的な値**：実際の設定値を確認する必要あり
  - 候補：config/settings.yml / db/seeds.rb / Setting モデル

## 5) リスクフラグ（レビュー観点）
- 0: ルーティング・コントローラーの基本動作 - 低リスク
- 0: モデル定義・バリデーション - 低リスク
- 1: ステータス設定値の確認 - 中リスク
- 0: キャンペーンとの関連処理 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] Setting.lead_status の実際の設定値を確認
- [ ] ステータスフィルタの動作をブラウザで確認
- [ ] 名前表示順の切り替えが正常に動作するか確認
- [ ] 削除時のキャンペーンleads_countデクリメントを確認
