---
generated_at: 2026-01-13 17:25:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：16-リード詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **リサーチツールへのリンク表示**：設定の有無により表示が変わる

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/leads_controller.rb`（26-32行目: showアクション）
- E-02: `app/controllers/entities/leads_controller.rb`（138-148行目: rejectアクション）
- E-03: `app/controllers/entities_controller.rb`（41-61行目: subscribe/unsubscribe）
- E-04: `app/models/entities/lead.rb`（136-143行目: convert, reject）
- E-05: `app/models/entities/lead.rb`（158-164行目: full_name）
- E-06: `app/views/leads/show.html.haml`（全体）
- E-07: `app/views/leads/_sidebar_show.html.haml`（全体）
- E-08: `config/routes.rb`（103-123行目: leadsルート）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（リード詳細関連行）
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv`（16行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リード詳細を表示する画面である | E-06, E-10 | ○ |
| C-02 | URLは /leads/:id である | E-08 | ○ |
| C-03 | vCard形式でエクスポート可能 | E-01 (30行目) | ○ |
| C-04 | 関連タスクを表示する | E-06 (16行目) | ○ |
| C-05 | タイムライン（コメント・メール）を表示する | E-06 (12行目) | ○ |
| C-06 | コメントを追加できる | E-06 (11行目) | ○ |
| C-07 | リードを削除できる | E-08 (DELETE route) | ○ |
| C-08 | 購読/購読解除ができる | E-03, E-08 (118-119行目) | ○ |
| C-09 | リード変換画面へ遷移できる | E-08 (115行目: convert) | ○ |
| C-10 | リードを却下できる | E-02, E-08 (121行目: reject) | ○ |
| C-11 | 却下するとステータスがrejectedになる | E-04 (141-143行目) | ○ |
| C-12 | do_not_callフラグで電話番号表示制御 | E-07 (14-16行目) | ○ |
| C-13 | アバターを表示する | E-07 (2行目: avatar_for) | ○ |
| C-14 | 役職・会社名を表示する | E-07 (4-8行目) | ○ |
| C-15 | 住所を表示する | E-07 (10行目: address_show) | ○ |
| C-16 | Web情報（SNS等）を表示する | E-07 (21行目: web_presence_icons) | ○ |
| C-17 | ステータス・ソース・レーティングを表示する | E-07 (26-33行目) | ○ |
| C-18 | キャンペーンへのリンクを表示する | E-07 (42-46行目) | ○ |
| C-19 | 変換後の連絡先へのリンクを表示する | E-07 (48-53行目) | ○ |
| C-20 | 背景情報を表示する | E-07 (55-57行目) | ○ |
| C-21 | タグを表示する | E-07 (61-63行目) | ○ |
| C-22 | リサーチツールへのリンクを表示する | E-07 (65行目)、**設定要確認** | △ |
| C-23 | バージョン履歴を表示する | E-06 (18行目) | ○ |
| C-24 | paper_trailで閲覧履歴が記録される | entities_controller.rb | ○ |
| C-25 | 削除は論理削除（deleted_at更新） | lead.rb (deleted_at) | ○ |
| C-26 | 削除時にキャンペーンのleads_countがデクリメントされる | lead.rb (82行目) | ○ |
| C-27 | 却下成功時にメッセージ表示 | E-02 (144行目: flash[:notice]) | ○ |
| C-28 | 却下後にリード一覧にリダイレクト | E-02 (145行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **リサーチツールの設定**：admin/research_tools の設定に依存
  - 候補：app/views/shared/_research_tools.html.haml / Setting モデル

## 5) リスクフラグ（レビュー観点）
- 0: 基本的な詳細表示機能 - 低リスク
- 0: コメント・タスク関連 - 低リスク
- 1: リサーチツール表示 - 中リスク（設定依存）
- 0: vCardエクスポート - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] do_not_callフラグがtrueの場合、電話番号が取り消し線で表示されるか確認
- [ ] キャンペーン/連絡先へのリンクが正しく動作するか確認
- [ ] vCardエクスポートの出力内容を確認
- [ ] 却下操作が正常に動作するか確認
