---
generated_at: 2026-01-13 17:30:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-リード新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/leads_controller.rb`（35-50行目: newアクション）
- E-02: `app/controllers/entities/leads_controller.rb`（63-79行目: createアクション）
- E-03: `app/models/entities/lead.rb`（76-79行目: バリデーション）
- E-04: `app/models/entities/lead.rb`（96-104行目: save_with_permissions）
- E-05: `app/views/leads/_new.html.haml`（全体）
- E-06: `app/views/leads/_top_section.html.haml`（全体）
- E-07: `app/views/leads/_status.html.haml`（全体）
- E-08: `app/views/leads/_contact.html.haml`（全体）
- E-09: `config/routes.rb`（103-123行目: leadsルート）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（リード新規作成関連行）
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv`（17行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規作成フォームがAjaxモーダルで表示される | E-05 (remote: true) | ○ |
| C-02 | URLは GET /leads/new である | E-09 | ○ |
| C-03 | POSTは /leads に送信される | E-09, E-05 | ○ |
| C-04 | 名の必須は設定依存 | E-03 (76行目: if Setting.require_first_names) | ○ |
| C-05 | 姓の必須は設定依存 | E-03 (77行目: if Setting.require_last_names) | ○ |
| C-06 | キャンペーンIDを隠しフィールドで送信 | E-05 (4行目) | ○ |
| C-07 | キャンペーン選択でCampaign権限が有効化 | E-07 (36行目: flip_campaign_permissions) | ○ |
| C-08 | キャンペーン詳細からの作成時ソースは campaign に固定 | E-07 (25-27行目) | ○ |
| C-09 | キャンペーン詳細からの作成時キャンペーンは自動選択 | E-07 (33-34行目) | ○ |
| C-10 | 会社名はオートコンプリート | E-08 (16行目: autocomplete_field) | ○ |
| C-11 | do_not_call チェックボックスがある | E-08 (34-35行目) | ○ |
| C-12 | save_with_permissionsでキャンペーン紐付け | E-04 (97行目) | ○ |
| C-13 | Campaign権限でキャンペーンの権限を継承 | E-04 (98-99行目) | ○ |
| C-14 | コメント追加後にadd_comment_by_user | E-02 (70行目) | ○ |
| C-15 | キャンペーンのleads_countがインクリメント | E-04 + lead.rb (after_create) | ○ |
| C-16 | simple_form_forを使用 | E-05 (1行目) | ○ |
| C-17 | one_submit_onlyでダブルサブミット防止 | E-05 (1行目) | ○ |
| C-18 | Setting.compound_addressで保存ボタン処理が分岐 | E-05 (19-22行目) | ○ |
| C-19 | フックポイントで拡張可能 | E-05 (16行目: hook(:entity_form)) | ○ |
| C-20 | タグを入力できる | E-06 (28行目) | ○ |
| C-21 | レーティングを選択できる | E-07 (21行目: rating_select) | ○ |
| C-22 | ステータスを選択できる | E-07 (17行目) | ○ |
| C-23 | ソースを選択できる | E-07 (25-29行目) | ○ |
| C-24 | 担当者を選択できる | E-07 (13行目: user_select) | ○ |
| C-25 | 住所を入力できる | E-08 (27行目: shared/address) | ○ |
| C-26 | 背景情報は設定により表示/非表示 | E-06 (22-26行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: フォーム構成・入力項目 - 低リスク
- 0: バリデーション定義 - 低リスク
- 0: キャンペーン連携 - 低リスク
- 0: 権限設定（Campaign権限含む） - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] キャンペーン詳細画面からのリード作成が正常に動作するか確認
- [ ] Campaign権限選択時にキャンペーンの権限が正しく継承されるか確認
- [ ] 会社名オートコンプリートが正常に動作するか確認
- [ ] 名/姓の必須設定が正しく反映されるか確認
