---
generated_at: 2026-01-13 17:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-リード編集フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/leads_controller.rb`（53-60行目: editアクション）
- E-02: `app/controllers/entities/leads_controller.rb`（82-93行目: updateアクション）
- E-03: `app/models/entities/lead.rb`（108-119行目: update_with_lead_counters）
- E-04: `app/views/leads/_edit.html.haml`（全体）
- E-05: `app/views/leads/_top_section.html.haml`（全体）
- E-06: `app/views/leads/_status.html.haml`（全体）
- E-07: `app/views/leads/_contact.html.haml`（全体）
- E-08: `app/views/leads/_web.html.haml`（全体）
- E-09: `app/views/entities/_permissions.html.haml`（全体）
- E-10: `config/routes.rb`（103-123行目: leadsルート）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（リード編集関連行）
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv`（18行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 編集フォームがAjaxモーダルで表示される | E-04 (remote: true) | ○ |
| C-02 | URLは GET /leads/:id/edit である | E-10 | ○ |
| C-03 | PUT/PATCHは /leads/:id に送信される | E-10, E-04 | ○ |
| C-04 | 名の必須は設定依存 | lead.rb (76行目: if Setting.require_first_names) | ○ |
| C-05 | 姓の必須は設定依存 | lead.rb (77行目: if Setting.require_last_names) | ○ |
| C-06 | 編集時に get_campaigns でキャンペーン一覧取得 | E-01 (54行目) | ○ |
| C-07 | update で access を最初に設定 | E-02 (86行目) | ○ |
| C-08 | update_with_lead_counters で更新実行 | E-02 (87行目) | ○ |
| C-09 | キャンペーン変更時に旧キャンペーンの leads_count がデクリメント | E-03 (112-114行目) | ○ |
| C-10 | キャンペーン変更時に新キャンペーンの leads_count がインクリメント | E-03 (115-117行目) | ○ |
| C-11 | 会社名はオートコンプリート | E-07 (16行目: autocomplete_field) | ○ |
| C-12 | do_not_call チェックボックスがある | E-07 (34-35行目) | ○ |
| C-13 | simple_form_for を使用 | E-04 (2行目) | ○ |
| C-14 | one_submit_only でダブルサブミット防止 | E-04 (2行目) | ○ |
| C-15 | Setting.compound_address で保存ボタン処理が分岐 | E-04 (17-22行目) | ○ |
| C-16 | edit: true パラメータが各パーシャルに渡される | E-04 (8-14行目) | ○ |
| C-17 | タグを編集できる | E-05 (28行目) | ○ |
| C-18 | レーティングを選択できる | E-06 (21行目: rating_select) | ○ |
| C-19 | ステータスを選択できる | E-06 (17行目) | ○ |
| C-20 | ソースを選択できる | E-06 (25-29行目) | ○ |
| C-21 | 担当者を選択できる | E-06 (13行目: user_select) | ○ |
| C-22 | 住所を編集できる | E-07 (27行目: shared/address) | ○ |
| C-23 | 背景情報は設定により表示/非表示 | E-05 (22-26行目) | ○ |
| C-24 | 権限（Public/Private/Shared）を変更できる | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: フォーム構成・入力項目 - 低リスク
- 0: バリデーション定義 - 低リスク
- 0: キャンペーン変更時のカウンター更新 - 低リスク
- 0: 権限設定 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] キャンペーン変更時に leads_count が正しく更新されるか確認
- [ ] 既存値が正しくプリセットされるか確認
- [ ] 会社名オートコンプリートが正常に動作するか確認
- [ ] 名/姓の必須設定が正しく反映されるか確認
