---
generated_at: 2026-01-13 17:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-リード変換画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/leads_controller.rb`（106-116行目: convertアクション）
- E-02: `app/controllers/entities/leads_controller.rb`（120-134行目: promoteアクション）
- E-03: `app/models/entities/lead.rb`（124-133行目: promoteメソッド）
- E-04: `app/models/entities/lead.rb`（136-138行目: convertメソッド）
- E-05: `app/models/entities/contact.rb`（171-191行目: create_forメソッド）
- E-06: `app/models/entities/opportunity.rb`（153-167行目: create_forメソッド）
- E-07: `app/models/entities/account.rb`（119-124行目: create_or_select_forメソッド）
- E-08: `app/views/leads/_convert.html.haml`（全体）
- E-09: `app/views/leads/_opportunity.html.haml`（全体）
- E-10: `app/views/leads/_convert_permissions.html.haml`（全体）
- E-11: `config/routes.rb`（115行目: convert, 117行目: promote）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（リード変換関連行）
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv`（19行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 変換フォームがAjaxモーダルで表示される | E-08 (remote: true) | ○ |
| C-02 | URLは GET /leads/:id/convert である | E-11 | ○ |
| C-03 | PUT /leads/:id/promote で変換実行 | E-11 | ○ |
| C-04 | リードの会社名が取引先名にプリセットされる | E-01 (109行目) | ○ |
| C-05 | Opportunityはprospectingステージで初期化 | E-01 (111行目) | ○ |
| C-06 | キャンペーンとソースがリードから引き継がれる | E-01 (111行目) | ○ |
| C-07 | promoteでAccount,Opportunity,Contactが作成される | E-03 (128-130行目) | ○ |
| C-08 | すべて成功時のみconvertが実行される | E-02 (126-127行目) | ○ |
| C-09 | convertでstatusがconvertedに変更される | E-04 (137行目) | ○ |
| C-10 | Contact.create_forでリード情報が引き継がれる | E-05 (178-180行目) | ○ |
| C-11 | lead_idで元リードへの参照が保持される | E-05 (173行目) | ○ |
| C-12 | 住所情報も連絡先に引き継がれる | E-05 (191行目) | ○ |
| C-13 | カスタムフィールドも引き継がれる | E-05 (185-188行目) | ○ |
| C-14 | 商談は名前入力時のみ作成される | E-06 (157行目: if opportunity.name?) | ○ |
| C-15 | Lead権限で権限を引き継げる | E-10 (8行目) | ○ |
| C-16 | Private/Public/Sharedも選択可能 | E-10 (11-17行目) | ○ |
| C-17 | Shared選択時に共有先UI表示 | E-10 (20-31行目) | ○ |
| C-18 | 取引先は選択または新規作成 | E-08 (15行目: account_select_or_create) | ○ |
| C-19 | 担当者を選択できる | E-08 (19行目: user_select) | ○ |
| C-20 | 商談ステージを選択できる | E-09 (19行目) | ○ |
| C-21 | 成約予定日を入力できる | E-09 (25行目) | ○ |
| C-22 | 確度を入力できる | E-09 (29行目) | ○ |
| C-23 | 金額を入力できる | E-09 (33行目) | ○ |
| C-24 | 割引を入力できる | E-09 (37行目) | ○ |
| C-25 | one_submit_onlyでダブルサブミット防止 | E-08 (2行目) | ○ |
| C-26 | Account.create_or_select_forで既存選択または新規作成 | E-07 (121行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 変換フロー（promote/convert） - 低リスク
- 0: エンティティ間の関連付け - 低リスク
- 0: 権限設定（Lead継承含む） - 低リスク
- 0: リードからのデータ引き継ぎ - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 変換後に連絡先が正しく作成されるか確認
- [ ] リードの情報（氏名、連絡先、住所）が連絡先に引き継がれるか確認
- [ ] 商談名未入力時に商談が作成されないことを確認
- [ ] Lead権限選択時にリードの権限が正しく引き継がれるか確認
- [ ] 変換後にリードのステータスがconvertedになるか確認
