---
generated_at: 2026-01-13 17:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-連絡先一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/contacts_controller.rb`（13-20行目: indexアクション）
- E-02: `app/controllers/entities/contacts_controller.rb`（109-128行目: redrawアクション）
- E-03: `app/controllers/entities/contacts_controller.rb`（136-138行目: list_includes）
- E-04: `app/models/entities/contact.rb`（40-52行目: 関連定義）
- E-05: `app/models/entities/contact.rb`（66-84行目: text_searchスコープ）
- E-06: `app/models/entities/contact.rb`（94行目: sortable）
- E-07: `app/views/contacts/index.html.haml`（全体）
- E-08: `app/views/contacts/_contact.html.haml`（全体）
- E-09: `app/views/contacts/_index_long.html.haml`（全体）
- E-10: `config/routes.rb`（84-101行目: contactsルート）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（連絡先一覧関連行）
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv`（20行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 連絡先一覧を表示する画面である | E-07, E-12 | ○ |
| C-02 | URLは /contacts である | E-10 (84行目) | ○ |
| C-03 | Excel/CSV形式でエクスポート可能 | E-01 (17-18行目) | ○ |
| C-04 | 高度な検索が利用できる | E-10 (86行目: advanced_search) | ○ |
| C-05 | フィルターが利用できる | E-10 (87行目: filter) | ○ |
| C-06 | 表示オプションが利用できる | E-10 (88行目: options) | ○ |
| C-07 | redrawで再描画できる | E-02 | ○ |
| C-08 | オートコンプリートが利用できる | E-10 (90行目: auto_complete) | ○ |
| C-09 | list_includesで:accountと:tagsをプリロード | E-03 | ○ |
| C-10 | belongs_to :lead でリードと関連 | E-04 (42行目) | ○ |
| C-11 | has_one :account で取引先と関連 | E-04 (45-46行目) | ○ |
| C-12 | text_searchで氏名・メール・電話を検索 | E-05 | ○ |
| C-13 | 氏名の順序入れ替えに対応 | E-05 (70-74行目) | ○ |
| C-14 | デフォルトソートはcreated_at DESC | E-06 | ○ |
| C-15 | 名前表示形式がリードと連動 | E-02 (117-120行目) | ○ |
| C-16 | ソート順がリードと連動 | E-02 (113-116行目) | ○ |
| C-17 | template_for_current_viewでテンプレートカスタマイズ可能 | E-08 (1行目) | ○ |
| C-18 | デフォルトは_index_longテンプレート | E-08 (5行目) | ○ |
| C-19 | アバターを表示する | E-09 (2行目: avatar_for) | ○ |
| C-20 | brief_account_infoで取引先情報表示 | E-09 (19行目) | ○ |
| C-21 | 紹介者情報を表示する（リードから） | E-09 (21-23行目) | ○ |
| C-22 | メール・電話リンクを表示する | E-09 (27-36行目) | ○ |
| C-23 | タグを表示する | E-09 (40-42行目) | ○ |
| C-24 | hookポイントで拡張可能 | E-09 (5行目, 44行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 一覧表示機能 - 低リスク
- 0: 検索機能（text_search） - 低リスク
- 0: エクスポート機能 - 低リスク
- 0: リード連動設定 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 氏名検索で「姓 名」「名 姓」両方の順序で検索できるか確認
- [ ] 名前表示形式の設定がリードと連動するか確認
- [ ] Excel/CSVエクスポートが正常に動作するか確認
- [ ] リードから変換された連絡先で紹介者情報が表示されるか確認
