---
generated_at: 2026-01-13 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：21-連絡先詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **vCardエクスポート機能の詳細仕様**：ヘルパーメソッドの実装詳細未確認
  2. **カスタムフィールド表示仕様**：動的フィールド表示ロジックの詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/entities/contacts_controller.rb` - ContactsController定義
- E-02: `app/models/entities/contact.rb` - Contactモデル定義
- E-03: `app/views/contacts/show.html.haml` - 詳細画面ビュー
- E-04: `app/views/contacts/_title_bar.html.haml` - タイトルバーパーシャル
- E-05: `app/views/contacts/_sidebar_show.html.haml` - サイドバーパーシャル
- E-06: `app/controllers/entities_controller.rb` - EntitiesController基底クラス
- E-07: `config/routes.rb` - ルーティング定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/contacts/:id` でアクセス可能 | E-07 (84行目) | ○ |
| C-02 | ContactsController#showで処理される | E-01 (25-32行目) | ○ |
| C-03 | @stageにopportunity_stageがセットされる | E-01 (26行目) | ○ |
| C-04 | @commentに新規Commentがセットされる | E-01 (27行目) | ○ |
| C-05 | @timelineにコメントとメールの配列がセットされる | E-01 (28行目), E-06 (215-217行目) | ○ |
| C-06 | vCard形式でエクスポート可能 | E-01 (30行目) | ○ |
| C-07 | タイトルバーに編集・削除リンクが表示される | E-04 (3-4行目) | ○ |
| C-08 | サイドバーにアバター画像が表示される | E-05 (2行目) | ○ |
| C-09 | do_not_callがtrueの場合、電話番号に取り消し線 | E-05 (9-13行目) | ○ |
| C-10 | 関連タスクが表示される | E-03 (17行目) | ○ |
| C-11 | 関連商談が表示される | E-03 (19行目) | ○ |
| C-12 | バージョン履歴が表示される | E-03 (21行目) | ○ |
| C-13 | コメントフォームが表示される | E-03 (12行目) | ○ |
| C-14 | タイムラインが表示される | E-03 (13行目) | ○ |
| C-15 | Contactモデルはuserにbelongs_to | E-02 (41行目) | ○ |
| C-16 | Contactモデルはaccountにhas_one through | E-02 (45-46行目) | ○ |
| C-17 | Contactモデルはopportunitiesにhas_many through | E-02 (47-48行目) | ○ |
| C-18 | Contactモデルはtasksにhas_many as: :asset | E-02 (49行目) | ○ |
| C-19 | 機能No.16 連絡先詳細表示が主機能 | E-08 (44行目) | ○ |
| C-20 | 機能No.42 コメント一覧表示が補助機能 | E-08 (45行目) | ○ |
| C-21 | 機能No.43 コメント作成が補助機能 | E-08 (46行目) | ○ |
| C-22 | 機能No.86 購読/購読解除が補助機能 | E-08 (47行目) | ○ |
| C-23 | 機能No.19 連絡先削除が遷移先機能 | E-08 (101行目) | ○ |
| C-24 | 機能No.85 バージョン履歴が補助機能 | E-08 (110行目) | ○ |
| C-25 | update_recently_viewedでversion記録 | E-06 (186-188行目) | ○ |
| C-26 | subscribed_usersでシリアライズ保存 | E-02 (59行目) | ○ |
| C-27 | vCard生成はcontact_helperのvcard_forメソッド | E-01 (30行目) | △ |
| C-28 | カスタムフィールドがサイドバーに動的表示 | E-05 (46行目) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-27**: vcard_forヘルパーメソッドの実装詳細を直接確認していない。`app/helpers/contacts_helper.rb`の実装を確認する必要がある
  - 候補：`app/helpers/contacts_helper.rb` / `app/helpers/application_helper.rb` / Gem依存
- **C-28**: カスタムフィールド表示の詳細ロジックはFieldsパーシャルに委譲されており、詳細未確認
  - 候補：`app/views/fields/_sidebar_show.html.haml` / `app/models/polymorphic/field.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的なCRUD操作とビュー構造は十分に検証済み
- **1: 中リスク** - vCardエクスポート機能の詳細実装
- **0: 低リスク** - アクセス権限制御（CanCanによる標準実装）

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターン `/contacts/:id` が正しくルーティングされることを確認
- [ ] vCard出力のフォーマットが標準仕様に準拠していることを確認
- [ ] do_not_callフラグによる電話番号表示制御の動作確認
- [ ] アクセス権限（Public/Private/Shared）による表示制御の動作確認
- [ ] タイムラインの時系列ソートが降順であることを確認
