---
generated_at: 2026-01-13 10:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：22-連絡先新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **crm.create_contact()のJavaScript実装詳細**：フロントエンド実装の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/contacts_controller.rb` - ContactsController定義
- E-02: `app/models/entities/contact.rb` - Contactモデル定義
- E-03: `app/views/contacts/_new.html.haml` - 新規作成フォームビュー
- E-04: `app/views/contacts/_top_section.html.haml` - 基本情報セクション
- E-05: `app/views/contacts/_extra.html.haml` - 追加情報セクション
- E-06: `app/views/contacts/_web.html.haml` - Web Presenceセクション
- E-07: `config/routes.rb` - ルーティング定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/contacts/new` でフォーム表示 | E-07 (84行目) | ○ |
| C-02 | POST `/contacts` で作成実行 | E-07 (84行目) | ○ |
| C-03 | ContactsController#newで処理される | E-01 (36-50行目) | ○ |
| C-04 | ContactsController#createで作成処理 | E-01 (63-74行目) | ○ |
| C-05 | デフォルトでcurrent_userがセットされる | E-01 (37行目) | ○ |
| C-06 | デフォルトアクセス権限がセットされる | E-01 (37行目) | ○ |
| C-07 | 関連エンティティをrelatedパラメータで受け取る | E-01 (40-46行目) | ○ |
| C-08 | save_with_account_and_permissionsで保存 | E-01 (66行目), E-02 (136-141行目) | ○ |
| C-09 | コメント追加はadd_comment_by_userで実行 | E-01 (67行目) | ○ |
| C-10 | first_nameのバリデーション（条件付き必須） | E-02 (96行目) | ○ |
| C-11 | last_nameのバリデーション（条件付き必須） | E-02 (97行目) | ○ |
| C-12 | first_name最大長64文字 | E-02 (100行目) | ○ |
| C-13 | last_name最大長64文字 | E-02 (101行目) | ○ |
| C-14 | email最大長254文字 | E-02 (104行目) | ○ |
| C-15 | Sharedアクセス時のユーザー選択必須 | E-02 (98行目, 211-213行目) | ○ |
| C-16 | フォームはremote: trueでAjax送信 | E-03 (1行目) | ○ |
| C-17 | one_submit_only属性で二重送信防止 | E-03 (1行目) | ○ |
| C-18 | 作成ボタンでcrm.create_contact()呼び出し | E-03 (18行目) | ○ |
| C-19 | 基本情報にfirst_name, last_name, email, phone | E-04 (6-20行目) | ○ |
| C-20 | 取引先選択/新規作成に対応 | E-04 (28-31行目) | ○ |
| C-21 | 追加情報にtitle, department, mobile等 | E-05 (10-36行目) | ○ |
| C-22 | Web Presenceにblog, twitter, linkedin, facebook | E-06 (10-24行目) | ○ |
| C-23 | 機能No.17 連絡先作成が主機能 | E-08 (48行目) | ○ |
| C-24 | 機能No.83 タグ付けが補助機能 | E-08 (118行目) | ○ |
| C-25 | crm.create_contact()の具体的な処理内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-25**: `crm.create_contact()` JavaScriptメソッドの具体的な実装内容を確認していない
  - 候補：`app/assets/javascripts/crm_contacts.js.coffee` / `app/assets/javascripts/crm.js.coffee`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - バリデーションルールはモデルで明確に定義
- **0: 低リスク** - 取引先連携処理はsave_with_account_and_permissionsで確認済み
- **1: 中リスク** - JavaScriptフロントエンド処理の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] first_name/last_nameの必須設定がSetting値と連動することを確認
- [ ] 取引先の新規作成と既存選択の切り替えが正しく動作することを確認
- [ ] Sharedアクセス設定時のユーザー選択UIが表示されることを確認
- [ ] Ajax送信後のレスポンス処理（成功/失敗）が正しく動作することを確認
- [ ] 二重送信防止機能が正しく動作することを確認
