---
generated_at: 2026-01-13 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：24-商談一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **サイドバーフィルターパネルの具体的な項目**：Setting値依存のため動的

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/opportunities_controller.rb` - OpportunitiesController定義
- E-02: `app/models/entities/opportunity.rb` - Opportunityモデル定義
- E-03: `app/views/opportunities/index.html.haml` - 一覧画面ビュー
- E-04: `app/controllers/entities_controller.rb` - EntitiesController基底クラス
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/opportunities` でアクセス可能 | E-05 (125行目) | ○ |
| C-02 | OpportunitiesController#indexで処理される | E-01 (15-22行目) | ○ |
| C-03 | @opportunitiesに商談一覧がセットされる | E-01 (16行目) | ○ |
| C-04 | CSV/XLSエクスポートに対応 | E-01 (18-19行目) | ○ |
| C-05 | @stageにステージ選択肢がセットされる | E-01 (221-222行目) | ○ |
| C-06 | @opportunity_stage_totalにステージ別件数 | E-01 (200-216行目) | ○ |
| C-07 | stateスコープでステージフィルタリング | E-02 (43-45行目), E-04 (151行目) | ○ |
| C-08 | text_searchで商談名・IDを検索 | E-02 (56-62行目), E-04 (154行目) | ○ |
| C-09 | weighted_sortでカスタムソート | E-02 (53行目), E-01 (162-164行目) | ○ |
| C-10 | ページネーション対応 | E-04 (172行目) | ○ |
| C-11 | filterアクションでフィルター適用 | E-01 (153-158行目), E-05 (127行目) | ○ |
| C-12 | セッションにフィルター状態を保存 | E-01 (228行目) | ○ |
| C-13 | redrawアクションで表示再描画 | E-01 (142-149行目), E-05 (133行目) | ○ |
| C-14 | advanced_searchアクションで高度な検索 | E-05 (126行目) | ○ |
| C-15 | 商談削除時にキャンペーンカウント減算 | E-02 (183-185行目) | ○ |
| C-16 | 検索結果0件時にemptyパーシャル表示 | E-03 (15行目) | ○ |
| C-17 | 機能No.28 商談一覧表示が主機能 | E-06 (50行目) | ○ |
| C-18 | 機能No.81 高度な検索が補助機能 | E-06 (51行目) | ○ |
| C-19 | 機能No.32 商談削除が補助機能 | E-06 (102行目) | ○ |
| C-20 | Opportunityモデルはaccountにhas_one through | E-02 (34-35行目) | ○ |
| C-21 | Opportunityモデルはcampaignにbelongs_to | E-02 (32行目) | ○ |
| C-22 | sortableでソート項目を定義 | E-02 (79行目) | ○ |
| C-23 | Ransackによる高度な検索対応 | E-02 (81-82行目) | ○ |
| C-24 | サイドバーのステージ項目の具体的な値 | **根拠なし（Setting依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-24**: サイドバーに表示されるステージ項目は`Setting.unroll(:opportunity_stage)`から動的に取得されるため、実際の値はシステム設定に依存する
  - 候補：`config/settings/opportunity_stage.yml` / DB設定

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 一覧取得とフィルタリングロジックは明確に定義
- **0: 低リスク** - ページネーションとソートは標準実装
- **1: 中リスク** - ステージ設定がシステム設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] ステージフィルターが正しく動作することを確認
- [ ] weighted_sort（金額×確度）ソートが正しく計算されることを確認
- [ ] CSV/XLSエクスポートが現在のフィルター条件を反映することを確認
- [ ] 検索が商談名とID両方に対応することを確認
- [ ] ページネーションがエクスポート時に無効化されることを確認
