---
generated_at: 2026-01-13 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：25-商談詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **カスタムフィールド表示の詳細仕様**：動的フィールド表示ロジックの詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/opportunities_controller.rb` - OpportunitiesController定義
- E-02: `app/models/entities/opportunity.rb` - Opportunityモデル定義
- E-03: `app/views/opportunities/show.html.haml` - 詳細画面ビュー
- E-04: `app/views/opportunities/_title_bar.html.haml` - タイトルバー
- E-05: `app/views/opportunities/_sidebar_show.html.haml` - サイドバー
- E-06: `app/controllers/entities_controller.rb` - EntitiesController基底クラス
- E-07: `config/routes.rb` - ルーティング定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/opportunities/:id` でアクセス可能 | E-07 (125行目) | ○ |
| C-02 | OpportunitiesController#showで処理される | E-01 (27-31行目) | ○ |
| C-03 | @commentに新規Commentがセットされる | E-01 (28行目) | ○ |
| C-04 | @timelineにコメントとメールの配列がセットされる | E-01 (29行目) | ○ |
| C-05 | タイトルバーに編集・削除リンクが表示される | E-04 (3-4行目) | ○ |
| C-06 | サイドバーにステージが表示される | E-05 (5-6行目) | ○ |
| C-07 | サイドバーにクローズ日が表示される | E-05 (8行目) | ○ |
| C-08 | 残り日数/遅延日数の計算と表示 | E-05 (10-18行目) | ○ |
| C-09 | 確度の表示 | E-05 (20-21行目) | ○ |
| C-10 | 金額の表示 | E-05 (23行目) | ○ |
| C-11 | 割引額と割引率の表示 | E-05 (26-30行目) | ○ |
| C-12 | 加重金額の表示 | E-05 (32-33行目) | ○ |
| C-13 | weighted_amountメソッドによる計算 | E-02 (103-105行目) | ○ |
| C-14 | 担当者の表示 | E-05 (35-36行目) | ○ |
| C-15 | 取引先へのリンク表示 | E-05 (39-43行目) | ○ |
| C-16 | キャンペーンへのリンク表示 | E-05 (46-50行目) | ○ |
| C-17 | 関連タスクが表示される | E-03 (17行目) | ○ |
| C-18 | 関連連絡先が表示される | E-03 (19行目) | ○ |
| C-19 | バージョン履歴が表示される | E-03 (21行目) | ○ |
| C-20 | 機能No.29 商談詳細表示が主機能 | E-08 (52行目) | ○ |
| C-21 | 機能No.42 コメント一覧表示が補助機能 | E-08 (53行目) | ○ |
| C-22 | 機能No.43 コメント作成が補助機能 | E-08 (54行目) | ○ |
| C-23 | 機能No.86 購読/購読解除が補助機能 | E-08 (55行目) | ○ |
| C-24 | 機能No.32 商談削除が遷移先機能 | E-08 (103行目) | ○ |
| C-25 | 機能No.85 バージョン履歴が補助機能 | E-08 (111行目) | ○ |
| C-26 | カスタムフィールドがサイドバーに動的表示 | E-05 (56行目) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-26**: カスタムフィールド表示の詳細ロジックはFieldsパーシャルに委譲されており、詳細未確認
  - 候補：`app/views/fields/_sidebar_show.html.haml`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的な表示項目は十分に検証済み
- **0: 低リスク** - weighted_amount計算ロジックは明確
- **1: 中リスク** - カスタムフィールド表示の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] weighted_amount計算が（金額-割引）×確度/100であることを確認
- [ ] クローズ日超過時の警告表示が正しく動作することを確認
- [ ] 取引先・キャンペーンへのリンクがnilの場合の表示を確認
- [ ] タイムラインの時系列ソートが降順であることを確認
- [ ] アクセス権限（Public/Private/Shared）による表示制御の動作確認
