---
generated_at: 2026-01-13 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-商談新規作成フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/opportunities_controller.rb` - OpportunitiesController定義
- E-02: `app/models/entities/opportunity.rb` - Opportunityモデル定義
- E-03: `app/views/opportunities/_new.html.haml` - 新規作成フォームビュー
- E-04: `app/views/opportunities/_top_section.html.haml` - 入力項目セクション
- E-05: `config/routes.rb` - ルーティング定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/opportunities/new` でフォーム表示 | E-05 (125行目) | ○ |
| C-02 | POST `/opportunities` で作成実行 | E-05 (125行目) | ○ |
| C-03 | OpportunitiesController#newで処理 | E-01 (34-52行目) | ○ |
| C-04 | OpportunitiesController#createで作成処理 | E-01 (67-87行目) | ○ |
| C-05 | デフォルトでdefault_stageがセットされる | E-01 (36行目), E-02 (98-100行目) | ○ |
| C-06 | 関連エンティティをrelatedパラメータで受け取る | E-01 (40-48行目) | ○ |
| C-07 | save_with_account_and_permissionsで保存 | E-01 (70行目), E-02 (108-119行目) | ○ |
| C-08 | nameの必須バリデーション | E-02 (84行目) | ○ |
| C-09 | stageのバリデーション（Setting値から動的） | E-02 (87行目) | ○ |
| C-10 | 数値フィールドのnumericality検証 | E-02 (85行目) | ○ |
| C-11 | Sharedアクセス時のユーザー選択必須 | E-02 (86行目, 171-175行目) | ○ |
| C-12 | フォームはremote: trueでAjax送信 | E-03 (1行目) | ○ |
| C-13 | 作成ボタンでassigned_toをコピー | E-03 (16行目) | ○ |
| C-14 | 商談作成時にキャンペーンカウント増加 | E-02 (89行目, 178-180行目) | ○ |
| C-15 | 連絡先との紐付け | E-02 (117行目) | ○ |
| C-16 | 機能No.30 商談作成が主機能 | E-06 (56行目) | ○ |
| C-17 | 機能No.83 タグ付けが補助機能 | E-06 (120行目) | ○ |
| C-18 | 機能No.84 アクセス権限管理が補助機能 | E-06 (130行目) | ○ |
| C-19 | キャンペーン選択にopportunity_campaign_select使用 | E-04 (49行目) | ○ |
| C-20 | 取引先選択にaccount_select_or_create使用 | E-04 (38行目) | ○ |
| C-21 | 呼び出し元に応じたサイドバーデータ更新 | E-01 (72-79行目) | ○ |
| C-22 | コメント追加機能 | E-01 (68行目, 71行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - バリデーションルールはモデルで明確に定義
- **0: 低リスク** - 保存ロジックはsave_with_account_and_permissionsで確認済み
- **0: 低リスク** - JavaScript処理もソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトステージがSetting値と連動することを確認
- [ ] 取引先の担当者が商談の担当者と同期されることを確認
- [ ] キャンペーンカウントが正しく増加することを確認
- [ ] 関連エンティティ（contact/account/campaign）からの作成時に紐付けが正しく行われることを確認
