---
generated_at: 2026-01-13 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-商談編集フォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/entities/opportunities_controller.rb` - OpportunitiesController定義
- E-02: `app/models/entities/opportunity.rb` - Opportunityモデル定義
- E-03: `app/views/opportunities/_edit.html.haml` - 編集フォームビュー
- E-04: `config/routes.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL `/opportunities/:id/edit` でフォーム表示 | E-04 (125行目) | ○ |
| C-02 | PATCH `/opportunities/:id` で更新実行 | E-04 (125行目) | ○ |
| C-03 | OpportunitiesController#editで処理 | E-01 (55-63行目) | ○ |
| C-04 | OpportunitiesController#updateで更新処理 | E-01 (91-110行目) | ○ |
| C-05 | @accountに既存取引先またはAccount.newをセット | E-01 (57行目) | ○ |
| C-06 | @accountsで選択可能取引先一覧を取得 | E-01 (58行目) | ○ |
| C-07 | @previousで前の商談を取得 | E-01 (60行目) | ○ |
| C-08 | update_with_account_and_permissionsで更新 | E-01 (93行目), E-02 (122-133行目) | ○ |
| C-09 | 取引先紐付け解除の条件 | E-02 (124-128行目) | ○ |
| C-10 | accessを先に設定してからattributes更新 | E-02 (130-131行目) | ○ |
| C-11 | フォームはremote: trueでAjax送信 | E-03 (2行目) | ○ |
| C-12 | campaign_idをhidden_fieldで保持 | E-03 (5行目) | ○ |
| C-13 | 保存ボタンでassigned_toをコピー | E-03 (16行目) | ○ |
| C-14 | 機能No.31 商談編集が主機能 | E-05 (57行目) | ○ |
| C-15 | 機能No.83 タグ付けが補助機能 | E-05 (121行目) | ○ |
| C-16 | 機能No.84 アクセス権限管理が補助機能 | E-05 (131行目) | ○ |
| C-17 | 呼び出し元に応じたサイドバーデータ更新 | E-01 (94-100行目) | ○ |
| C-18 | PaperTrailによる変更履歴追跡 | E-02 (76行目) | ○ |
| C-19 | バリデーションは新規作成と同じ | E-02 (84-87行目) | ○ |
| C-20 | CanCanによる認可チェック | E-01 (load_and_authorize_resource継承) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 更新ロジックはモデルで明確に定義
- **0: 低リスク** - 認可チェックはCanCanで標準実装
- **0: 低リスク** - サイドバー更新ロジックも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 取引先紐付けの解除が正しく動作することを確認
- [ ] キャンペーンIDがhidden_fieldで保持され変更されないことを確認
- [ ] accessを先に設定してからattributes更新する順序が守られることを確認
- [ ] 編集権限のないユーザーがアクセスした場合の挙動を確認
- [ ] 呼び出し元に応じたサイドバー更新が正しく動作することを確認
